/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jira;

import io.qameta.allure.jira.JiraService;
import io.qameta.allure.jira.retrofit.BasicAuthInterceptor;
import io.qameta.allure.jira.retrofit.DefaultCallAdapterFactory;
import io.qameta.allure.util.PropertyUtils;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class JiraServiceBuilder {
    private static final String JIRA_ENDPOINT = "ALLURE_JIRA_ENDPOINT";
    private static final String JIRA_USERNAME = "ALLURE_JIRA_USERNAME";
    private static final String JIRA_PASSWORD = "ALLURE_JIRA_PASSWORD";
    private String endpoint;
    private String username;
    private String password;

    public JiraServiceBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint);
        this.endpoint = JiraServiceBuilder.addSlashIfMissing(endpoint);
        return this;
    }

    public JiraServiceBuilder username(String username) {
        Objects.requireNonNull(username);
        this.username = username;
        return this;
    }

    public JiraServiceBuilder password(String password) {
        Objects.requireNonNull(password);
        this.password = password;
        return this;
    }

    public JiraServiceBuilder defaults() {
        this.endpoint(PropertyUtils.requireProperty((String)JIRA_ENDPOINT));
        this.username(PropertyUtils.requireProperty((String)JIRA_USERNAME));
        this.password(PropertyUtils.requireProperty((String)JIRA_PASSWORD));
        return this;
    }

    public JiraService build() {
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new BasicAuthInterceptor(this.username, this.password)).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.endpoint).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).addCallAdapterFactory(new DefaultCallAdapterFactory()).client(client).build();
        return (JiraService)retrofit.create(JiraService.class);
    }

    private static String addSlashIfMissing(String endpoint) {
        String slash = "/";
        return endpoint.endsWith("/") ? endpoint : endpoint + "/";
    }
}

