(function(){(function(){var InstalledExtension,InstalledExtensionCollection;InstalledExtension=Backbone.Model.extend({defaults:{author:null,authorURL:null,configURL:null,dbURL:null,enabled:false,loadable:true,loadError:null,name:null,summary:null,version:null},url:function(){return Backbone.Model.prototype.url.call(this)+"/"},enable:function(){this.save({enabled:true},{wait:true,error:_.bind(function(model,xhr){this.set({loadable:false,loadError:xhr.errorRsp.load_error,canEnable:!xhr.errorRsp.needs_reload})},this)})},disable:function(){this.save({enabled:false},{wait:true,error:function(model,xhr){alert(gettext("Failed to disable extension. ")+xhr.errorText+".")}})},toJSON:function(){return{enabled:this.get("enabled")}},parse:function(rsp){var configLink,dbLink;if(rsp.stat!==undefined){rsp=rsp.extension}configLink=rsp.links["admin-configure"];dbLink=rsp.links["admin-database"];return{author:rsp.author,authorURL:rsp.author_url,canDisable:rsp.can_disable,canEnable:rsp.can_enable,configURL:configLink?configLink.href:null,dbURL:dbLink?dbLink.href:null,enabled:rsp.enabled,loadable:rsp.loadable,loadError:rsp.load_error,id:rsp.class_name,name:rsp.name,summary:rsp.summary,version:rsp.version}},sync:function(method,model,options){Backbone.sync.call(this,method,model,_.defaults({contentType:"application/x-www-form-urlencoded",data:model.toJSON(options),processData:true,error:_.bind(function(xhr){var rsp=null,loadError,text;try{rsp=$.parseJSON(xhr.responseText);text=rsp.err.msg;loadError=rsp.load_error}catch(e){text="HTTP "+xhr.status+" "+xhr.statusText}if(_.isFunction(options.error)){xhr.errorText=text;xhr.errorRsp=rsp;options.error(xhr,options)}},this)},options))}});InstalledExtensionCollection=Backbone.Collection.extend({model:InstalledExtension,parse:function(rsp){return rsp.extensions}});Djblets.ExtensionManager=Backbone.Model.extend({defaults:{apiRoot:null},initialize:function(){this.installedExtensions=new InstalledExtensionCollection([],{url:this.get("apiRoot")})},load:function(){this.installedExtensions.fetch({success:_.bind(function(){this.trigger("loaded")},this)})}})})();(function(){var InstalledExtensionView;InstalledExtensionView=Backbone.View.extend({className:"extension",tagName:"li",events:{"click .enable-toggle":"_toggleEnableState","click .reload-link":"_reloadExtensions"},template:_.template(['<div class="extension-header">',' <h1><%- name %> <span class="version"><%- version %></span></h1>',' <p class="author">',"  <% if (authorURL) { %>",'   <a href="<%- authorURL %>"><%- author %></a>',"  <% } else { %>","   <%- author %>","  <% } %>"," </p>","</div>",'<div class="description"><%- summary %></div>',"<% if (!loadable) { %>",' <div class="extension-load-error">',"  <p><%- loadFailureText %></p>","  <pre><%- loadError %></pre>"," </div>","<% } %>",'<ul class="object-tools">',' <li><a href="#" class="enable-toggle"></a></li>'," <% if (loadError) { %>",'  <li><a href="#" class="reload-link"><%- reloadText %></a></li>'," <% } else { %>","  <% if (configURL) { %>",'   <li><a href="<%- configURL %>" class="enabled-only changelink">',"       <%- configureText %></a></li>","  <% } %>","  <% if (dbURL) { %>",'   <li><a href="<%- dbURL %>" class="enabled-only changelink">',"       <%- databaseText %></a></li>","  <% } %>"," <% } %>","</ul>"].join("")),render:function(){this._renderTemplate();this.listenTo(this.model,"change:loadable change:loadError",this._renderTemplate);this.listenTo(this.model,"change:enabled change:canEnable change:canDisable",this._showEnabledState);return this},_renderTemplate:function(){this.$el.html(this.template(_.defaults({configureText:gettext("Configure"),databaseText:gettext("Database"),loadFailureText:gettext("This extension failed to load with the following error:"),reloadText:gettext("Reload")},this.model.attributes)));if(this.model.get("loadable")){this.$el.removeClass("error")}else{this.$el.addClass("error")}this._$enableToggle=this.$(".enable-toggle");this._$enabledToolLinks=this.$(".enabled-only");this._showEnabledState()},_showEnabledState:function(){var enabled=this.model.get("enabled");this.$el.removeClass(enabled?"disabled":"enabled").addClass(enabled?"enabled":"disabled");this._$enableToggle.text(enabled?gettext("Disable"):gettext("Enable")).addClass(enabled?"disablelink":"enablelink").removeClass(enabled?"enablelink":"disablelink").setVisible(enabled&&this.model.get("canDisable")||!enabled&&this.model.get("canEnable"));this._$enabledToolLinks.setVisible(enabled)},_toggleEnableState:function(){if(this.model.get("enabled")){this.model.disable()}else{this.model.enable()}return false},_reloadExtensions:function(){this.trigger("reloadClicked");return false}});Djblets.ExtensionManagerView=Backbone.View.extend({events:{"click #reload-extensions":"_reloadFull"},initialize:function(){this._$extensions=null},render:function(){this._$extensions=this.$(".extensions");this.listenTo(this.model,"loaded",this._onLoaded);this.model.load();return this},_onLoaded:function(){var evenRow=false;this._$extensions.empty();if(this.model.installedExtensions.length===0){this._$extensions.append($("<li/>").text(gettext("There are no extensions installed.")))}else{this.model.installedExtensions.each(function(extension){var view=new InstalledExtensionView({model:extension});this._$extensions.append(view.$el);view.$el.addClass(evenRow?"row2":"row1");view.render();this.listenTo(view,"reloadClicked",this._reloadFull);evenRow=!evenRow},this);this._$extensions.appendTo(this.$el)}},_reloadFull:function(){this.el.submit()}})})()}).call(this);
