"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'create a parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new lib_1.ParameterGroup(stack, 'Params', {
            family: 'hello',
            description: 'desc',
            parameters: {
                key: 'value',
            },
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBParameterGroup', {
            Description: 'desc',
            Family: 'hello',
            Parameters: {
                key: 'value',
            },
        }));
        test.done();
    },
    'create a cluster parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new lib_1.ClusterParameterGroup(stack, 'Params', {
            family: 'hello',
            description: 'desc',
            parameters: {
                key: 'value',
            },
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBClusterParameterGroup', {
            Description: 'desc',
            Family: 'hello',
            Parameters: {
                key: 'value',
            },
        }));
        test.done();
    },
    'Add an additional parameter to an existing parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const clusterParameterGroup = new lib_1.ClusterParameterGroup(stack, 'Params', {
            family: 'hello',
            description: 'desc',
            parameters: {
                key1: 'value1',
            },
        });
        clusterParameterGroup.addParameter('key2', 'value2');
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBClusterParameterGroup', {
            Description: 'desc',
            Family: 'hello',
            Parameters: {
                key1: 'value1',
                key2: 'value2',
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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