"use strict";
const assert_1 = require("@aws-cdk/assert");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'create an option group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new lib_1.OptionGroup(stack, 'Options', {
            engine: lib_1.DatabaseInstanceEngine.ORACLE_SE1,
            majorEngineVersion: '11.2',
            configurations: [
                {
                    name: 'XMLDB',
                },
            ],
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::OptionGroup', {
            EngineName: 'oracle-se1',
            MajorEngineVersion: '11.2',
            OptionGroupDescription: 'Option group for oracle-se1 11.2',
            OptionConfigurations: [
                {
                    OptionName: 'XMLDB',
                },
            ],
        }));
        test.done();
    },
    'option group with security groups'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const vpc = new ec2.Vpc(stack, 'VPC');
        // WHEN
        const optionGroup = new lib_1.OptionGroup(stack, 'Options', {
            engine: lib_1.DatabaseInstanceEngine.ORACLE_SE1,
            majorEngineVersion: '11.2',
            configurations: [
                {
                    name: 'OEM',
                    port: 1158,
                    vpc,
                },
            ],
        });
        optionGroup.optionConnections.OEM.connections.allowDefaultPortFromAnyIpv4();
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::OptionGroup', {
            EngineName: 'oracle-se1',
            MajorEngineVersion: '11.2',
            OptionGroupDescription: 'Option group for oracle-se1 11.2',
            OptionConfigurations: [
                {
                    OptionName: 'OEM',
                    Port: 1158,
                    VpcSecurityGroupMemberships: [
                        {
                            'Fn::GetAtt': [
                                'OptionsSecurityGroupOEM6C9FE79D',
                                'GroupId',
                            ],
                        },
                    ],
                },
            ],
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::SecurityGroup', {
            GroupDescription: 'Security group for OEM option',
            SecurityGroupIngress: [
                {
                    CidrIp: '0.0.0.0/0',
                    Description: 'from 0.0.0.0/0:1158',
                    FromPort: 1158,
                    IpProtocol: 'tcp',
                    ToPort: 1158,
                },
            ],
            VpcId: {
                Ref: 'VPCB9E5F0B4',
            },
        }));
        test.done();
    },
    'throws when using an option with port and no vpc'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // THEN
        test.throws(() => new lib_1.OptionGroup(stack, 'Options', {
            engine: lib_1.DatabaseInstanceEngine.ORACLE_SE1,
            majorEngineVersion: '11.2',
            configurations: [
                {
                    name: 'OEM',
                    port: 1158,
                },
            ],
        }), /`port`.*`vpc`/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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