"use strict";
const version_1 = require("../../lib/private/version");
module.exports = {
    'compare - same versions'(test) {
        test.equals(version_1.compare('1', '1'), 0);
        test.equals(version_1.compare('1.0', '1.0'), 0);
        test.done();
    },
    'compare - a < b'(test) {
        test.equals(version_1.compare('1', '2'), -1);
        test.equals(version_1.compare('1.0', '1.2'), -1);
        test.equals(version_1.compare('1.3', '4'), -1);
        test.equals(version_1.compare('1', '1.2'), -1);
        test.equals(version_1.compare('1.0', '2.0'), -1);
        test.equals(version_1.compare('4', '10'), -1);
        test.done();
    },
    'compare - a > b'(test) {
        test.equals(version_1.compare('2', '1'), 1);
        test.equals(version_1.compare('1.2', '1.0'), 1);
        test.equals(version_1.compare('1.2', '1'), 1);
        test.equals(version_1.compare('4', '1.2'), 1);
        test.equals(version_1.compare('2.0', '1.0'), 1);
        test.equals(version_1.compare('10', '4'), 1);
        test.done();
    },
    'compare - NaN'(test) {
        test.throws(() => version_1.compare('1', ''), /only compare version strings with numbers/);
        test.throws(() => version_1.compare('', '1'), /only compare version strings with numbers/);
        test.throws(() => version_1.compare('', ''), /only compare version strings with numbers/);
        test.throws(() => version_1.compare('4x', '1.0'), /only compare version strings with numbers/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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