"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const parameter_group_1 = require("../lib/parameter-group");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-rds-integ');
const vpc = new ec2.Vpc(stack, 'VPC', { maxAzs: 2 });
const params = new parameter_group_1.ClusterParameterGroup(stack, 'Params', {
    family: 'aurora5.6',
    description: 'A nice parameter group',
    parameters: {
        character_set_database: 'utf8mb4',
    },
});
const kmsKey = new kms.Key(stack, 'DbSecurity');
const cluster = new lib_1.DatabaseCluster(stack, 'Database', {
    engine: lib_1.DatabaseClusterEngine.AURORA,
    masterUser: {
        username: 'admin',
        password: cdk.SecretValue.plainText('7959866cacc02c2d243ecfe177464fe6'),
    },
    instanceProps: {
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.SMALL),
        vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC },
        vpc,
    },
    parameterGroup: params,
    storageEncryptionKey: kmsKey,
});
cluster.connections.allowDefaultPortFromAnyIpv4('Open to the world');
app.synth();
//# sourceMappingURL=data:application/json;base64,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