import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
declare module "./instance" {
    interface IDatabaseInstance {
        /**
         * Return the given named metric for this DBInstance
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The percentage of CPU utilization.
         *
         * Average over 5 minutes
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of database connections in use.
         *
         * Average over 5 minutes
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available storage space.
         *
         * Average over 5 minutes
         */
        metricFreeStorageSpace(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available random access memory.
         *
         * Average over 5 minutes
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk read I/O operations per second.
         *
         * Average over 5 minutes
         */
        metricWriteIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk write I/O operations per second.
         *
         * Average over 5 minutes
         */
        metricReadIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    interface DatabaseInstanceBase {
        /**
         * Return the given named metric for this DBInstance
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The percentage of CPU utilization.
         *
         * Average over 5 minutes
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of database connections in use.
         *
         * Average over 5 minutes
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available storage space.
         *
         * Average over 5 minutes
         */
        metricFreeStorageSpace(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available random access memory.
         *
         * Average over 5 minutes
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk read I/O operations per second.
         *
         * Average over 5 minutes
         */
        metricWriteIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk write I/O operations per second.
         *
         * Average over 5 minutes
         */
        metricReadIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
