import * as ec2 from '@aws-cdk/aws-ec2';
import { Construct, IResource, Resource } from '@aws-cdk/core';
import { DatabaseInstanceEngine } from './instance';
/**
 * An option group
 */
export interface IOptionGroup extends IResource {
    /**
     * The name of the option group.
     *
     * @attribute
     */
    readonly optionGroupName: string;
}
/**
 * Configuration properties for an option.
 */
export interface OptionConfiguration {
    /**
     * The name of the option.
     */
    readonly name: string;
    /**
     * The settings for the option.
     *
     * @default - no settings
     */
    readonly settings?: {
        [name: string]: string;
    };
    /**
     * The version for the option.
     *
     * @default - no version
     */
    readonly version?: string;
    /**
     * The port number that this option uses. If `port` is specified then `vpc`
     * must also be specified.
     *
     * @default - no port
     */
    readonly port?: number;
    /**
     * The VPC where a security group should be created for this option. If `vpc`
     * is specified then `port` must also be specified.
     *
     * @default - no VPC
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * Construction properties for an OptionGroup.
 */
export interface OptionGroupProps {
    /**
     * The database engine that this option group is associated with.
     */
    readonly engine: DatabaseInstanceEngine;
    /**
     * The major version number of the database engine that this option group
     * is associated with.
     */
    readonly majorEngineVersion: string;
    /**
     * A description of the option group.
     *
     * @default a CDK generated description
     */
    readonly description?: string;
    /**
     * The configurations for this option group.
     */
    readonly configurations: OptionConfiguration[];
}
/**
 * An option group
 */
export declare class OptionGroup extends Resource implements IOptionGroup {
    /**
     * Import an existing option group.
     */
    static fromOptionGroupName(scope: Construct, id: string, optionGroupName: string): IOptionGroup;
    /**
     * The name of the option group.
     */
    readonly optionGroupName: string;
    /**
     * The connections object for the options.
     */
    readonly optionConnections: {
        [key: string]: ec2.Connections;
    };
    constructor(scope: Construct, id: string, props: OptionGroupProps);
    /**
     * Renders the option configurations specifications.
     */
    private renderConfigurations;
}
