# Generated by Django 2.2.7 on 2019-11-10 07:47

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('crypted_key', models.BinaryField()),
            ],
        ),
        migrations.CreateModel(
            name='Block',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('number', models.PositiveIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Blockchain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('endpoint', models.CharField(max_length=255)),
                ('provider_class', models.CharField(choices=[('djblockchain.ethereum.Provider', 'Ethereum'), ('djblockchain.tezos.Provider', 'Tezos')], max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('txhash', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('accepted', models.BooleanField(default=None, help_text='Has this transaction been accepted by the blockchain', null=True)),
                ('status', models.BooleanField(db_index=True, default=False, help_text='Has this transaction been accepted by the blockchain')),
                ('gasprice', models.BigIntegerField(blank=True, null=True)),
                ('gas', models.BigIntegerField(blank=True, null=True)),
                ('contract_address', models.CharField(max_length=255, null=True)),
                ('contract_name', models.CharField(max_length=100, null=True)),
                ('function', models.CharField(max_length=100, null=True)),
                ('args', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('hold', models.BooleanField(default=False)),
                ('block', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='djblockchain.Block')),
                ('receiver', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='transactions_received', to='djblockchain.Account')),
                ('sender', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='transactions_sent', to='djblockchain.Account')),
            ],
        ),
        migrations.AddField(
            model_name='block',
            name='blockchain',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djblockchain.Blockchain'),
        ),
        migrations.AddField(
            model_name='account',
            name='blockchain',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djblockchain.Blockchain'),
        ),
        migrations.AddField(
            model_name='account',
            name='owner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='account',
            unique_together={('blockchain', 'address')},
        ),
    ]
