"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudscapeReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a Cloudscape React Typescript Website Project.
 *
 * @pjid cloudscape-react-ts-website
 */
class CloudscapeReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            ...options,
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.addDevDeps("@babel/plugin-proposal-private-property-in-object");
        this.addDeps("@cloudscape-design/global-styles", "@cloudscape-design/components", "@cloudscape-design/collection-hooks", "react-router-dom", "aws-amplify", "@aws-amplify/auth", "@aws-amplify/core", "@aws-amplify/ui-react", "aws4fetch");
        this.testTask.reset();
        const lintTask = this.tasks.tryFind("eslint");
        lintTask && this.testTask.spawn(lintTask);
        this.testTask.exec("react-scripts test --watchAll=false --passWithNoTests");
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../samples/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(this.buildSampleDirEntries(srcDir)),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../samples/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
    buildSampleDirEntries(dir, pathPrefixes = []) {
        return fs
            .readdirSync(dir, { withFileTypes: true })
            .filter((f) => f.name !== "config.json")
            .flatMap((f) => f.isDirectory()
            ? this.buildSampleDirEntries(`${dir}/${f.name}`, [
                ...pathPrefixes,
                f.name,
            ])
            : [
                [
                    `${path.join(...pathPrefixes, f.name)}`,
                    fs.readFileSync(`${dir}/${f.name}`).toString(),
                ],
            ]);
    }
}
exports.CloudscapeReactTsWebsiteProject = CloudscapeReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
CloudscapeReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/cloudscape-react-ts-website.CloudscapeReactTsWebsiteProject", version: "0.14.7" };
//# sourceMappingURL=data:application/json;base64,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