# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdaptingOSStepResponse',
    'ApplianceVersionResponse',
    'AppliedLicenseResponse',
    'AvailableUpdatesResponse',
    'AwsSourceVmDetailsResponse',
    'CloneJobResponse',
    'CloneStepResponse',
    'ComputeEngineTargetDefaultsResponse',
    'ComputeEngineTargetDetailsResponse',
    'ComputeSchedulingResponse',
    'CutoverJobResponse',
    'CutoverStepResponse',
    'CycleStepResponse',
    'InitializingReplicationStepResponse',
    'InstantiatingMigratedVMStepResponse',
    'NetworkInterfaceResponse',
    'PostProcessingStepResponse',
    'PreparingVMDisksStepResponse',
    'ReplicatingStepResponse',
    'ReplicationCycleResponse',
    'ReplicationSyncResponse',
    'SchedulePolicyResponse',
    'SchedulingNodeAffinityResponse',
    'ShuttingDownSourceVMStepResponse',
    'StatusResponse',
    'TargetVMDetailsResponse',
    'UpgradeStatusResponse',
    'VmUtilizationInfoResponse',
    'VmUtilizationMetricsResponse',
    'VmwareSourceDetailsResponse',
    'VmwareVmDetailsResponse',
]

@pulumi.output_type
class AdaptingOSStepResponse(dict):
    """
    AdaptingOSStep contains specific step details.
    """
    def __init__(__self__):
        """
        AdaptingOSStep contains specific step details.
        """
        pass


@pulumi.output_type
class ApplianceVersionResponse(dict):
    """
    Describes an appliance version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "releaseNotesUri":
            suggest = "release_notes_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplianceVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplianceVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplianceVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: bool,
                 release_notes_uri: str,
                 uri: str,
                 version: str):
        """
        Describes an appliance version.
        :param bool critical: Determine whether it's critical to upgrade the appliance to this version.
        :param str release_notes_uri: Link to a page that contains the version release notes.
        :param str uri: A link for downloading the version.
        :param str version: The appliance version.
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "release_notes_uri", release_notes_uri)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def critical(self) -> bool:
        """
        Determine whether it's critical to upgrade the appliance to this version.
        """
        return pulumi.get(self, "critical")

    @property
    @pulumi.getter(name="releaseNotesUri")
    def release_notes_uri(self) -> str:
        """
        Link to a page that contains the version release notes.
        """
        return pulumi.get(self, "release_notes_uri")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        A link for downloading the version.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The appliance version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AppliedLicenseResponse(dict):
    """
    AppliedLicense holds the license data returned by adaptation module report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osLicense":
            suggest = "os_license"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppliedLicenseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppliedLicenseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppliedLicenseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_license: str,
                 type: str):
        """
        AppliedLicense holds the license data returned by adaptation module report.
        :param str os_license: The OS license returned from the adaptation module's report.
        :param str type: The license type that was used in OS adaptation.
        """
        pulumi.set(__self__, "os_license", os_license)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="osLicense")
    def os_license(self) -> str:
        """
        The OS license returned from the adaptation module's report.
        """
        return pulumi.get(self, "os_license")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The license type that was used in OS adaptation.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AvailableUpdatesResponse(dict):
    """
    Holds informatiom about the available versions for upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inPlaceUpdate":
            suggest = "in_place_update"
        elif key == "newDeployableAppliance":
            suggest = "new_deployable_appliance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvailableUpdatesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvailableUpdatesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvailableUpdatesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_place_update: 'outputs.ApplianceVersionResponse',
                 new_deployable_appliance: 'outputs.ApplianceVersionResponse'):
        """
        Holds informatiom about the available versions for upgrade.
        :param 'ApplianceVersionResponse' in_place_update: The latest version for in place update. The current appliance can be updated to this version using the API or m4c CLI.
        :param 'ApplianceVersionResponse' new_deployable_appliance: The newest deployable version of the appliance. The current appliance can't be updated into this version, and the owner must manually deploy this OVA to a new appliance.
        """
        pulumi.set(__self__, "in_place_update", in_place_update)
        pulumi.set(__self__, "new_deployable_appliance", new_deployable_appliance)

    @property
    @pulumi.getter(name="inPlaceUpdate")
    def in_place_update(self) -> 'outputs.ApplianceVersionResponse':
        """
        The latest version for in place update. The current appliance can be updated to this version using the API or m4c CLI.
        """
        return pulumi.get(self, "in_place_update")

    @property
    @pulumi.getter(name="newDeployableAppliance")
    def new_deployable_appliance(self) -> 'outputs.ApplianceVersionResponse':
        """
        The newest deployable version of the appliance. The current appliance can't be updated into this version, and the owner must manually deploy this OVA to a new appliance.
        """
        return pulumi.get(self, "new_deployable_appliance")


@pulumi.output_type
class AwsSourceVmDetailsResponse(dict):
    """
    Represent the source AWS VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "committedStorageBytes":
            suggest = "committed_storage_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSourceVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSourceVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSourceVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 committed_storage_bytes: str,
                 firmware: str):
        """
        Represent the source AWS VM details.
        :param str committed_storage_bytes: The total size of the disks being migrated in bytes.
        :param str firmware: The firmware type of the source VM.
        """
        pulumi.set(__self__, "committed_storage_bytes", committed_storage_bytes)
        pulumi.set(__self__, "firmware", firmware)

    @property
    @pulumi.getter(name="committedStorageBytes")
    def committed_storage_bytes(self) -> str:
        """
        The total size of the disks being migrated in bytes.
        """
        return pulumi.get(self, "committed_storage_bytes")

    @property
    @pulumi.getter
    def firmware(self) -> str:
        """
        The firmware type of the source VM.
        """
        return pulumi.get(self, "firmware")


@pulumi.output_type
class CloneJobResponse(dict):
    """
    CloneJob describes the process of creating a clone of a MigratingVM to the requested target based on the latest successful uploaded snapshots. While the migration cycles of a MigratingVm take place, it is possible to verify the uploaded VM can be started in the cloud, by creating a clone. The clone can be created without any downtime, and it is created using the latest snapshots which are already in the cloud. The cloneJob is only responsible for its work, not its products, which means once it is finished, it will never touch the instance it created. It will only delete it in case of the CloneJob being cancelled or upon failure to clone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeEngineTargetDetails":
            suggest = "compute_engine_target_details"
        elif key == "computeEngineVmDetails":
            suggest = "compute_engine_vm_details"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "stateTime":
            suggest = "state_time"
        elif key == "targetDetails":
            suggest = "target_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloneJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloneJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloneJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_engine_target_details: 'outputs.ComputeEngineTargetDetailsResponse',
                 compute_engine_vm_details: 'outputs.TargetVMDetailsResponse',
                 create_time: str,
                 end_time: str,
                 error: 'outputs.StatusResponse',
                 name: str,
                 state: str,
                 state_time: str,
                 steps: Sequence['outputs.CloneStepResponse'],
                 target_details: 'outputs.TargetVMDetailsResponse'):
        """
        CloneJob describes the process of creating a clone of a MigratingVM to the requested target based on the latest successful uploaded snapshots. While the migration cycles of a MigratingVm take place, it is possible to verify the uploaded VM can be started in the cloud, by creating a clone. The clone can be created without any downtime, and it is created using the latest snapshots which are already in the cloud. The cloneJob is only responsible for its work, not its products, which means once it is finished, it will never touch the instance it created. It will only delete it in case of the CloneJob being cancelled or upon failure to clone.
        :param 'ComputeEngineTargetDetailsResponse' compute_engine_target_details: Details of the target VM in Compute Engine.
        :param 'TargetVMDetailsResponse' compute_engine_vm_details: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_details instead.
        :param str create_time: The time the clone job was created (as an API call, not when it was actually created in the target).
        :param str end_time: The time the clone job was ended.
        :param 'StatusResponse' error: Provides details for the errors that led to the Clone Job's state.
        :param str name: The name of the clone.
        :param str state: State of the clone job.
        :param str state_time: The time the state was last updated.
        :param Sequence['CloneStepResponse'] steps: The clone steps list representing its progress.
        :param 'TargetVMDetailsResponse' target_details: Details of the VM to create as the target of this clone job. Deprecated: Use compute_engine_target_details instead.
        """
        pulumi.set(__self__, "compute_engine_target_details", compute_engine_target_details)
        pulumi.set(__self__, "compute_engine_vm_details", compute_engine_vm_details)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_time", state_time)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "target_details", target_details)

    @property
    @pulumi.getter(name="computeEngineTargetDetails")
    def compute_engine_target_details(self) -> 'outputs.ComputeEngineTargetDetailsResponse':
        """
        Details of the target VM in Compute Engine.
        """
        return pulumi.get(self, "compute_engine_target_details")

    @property
    @pulumi.getter(name="computeEngineVmDetails")
    def compute_engine_vm_details(self) -> 'outputs.TargetVMDetailsResponse':
        """
        Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_details instead.
        """
        return pulumi.get(self, "compute_engine_vm_details")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time the clone job was created (as an API call, not when it was actually created in the target).
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time the clone job was ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        Provides details for the errors that led to the Clone Job's state.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the clone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the clone job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> str:
        """
        The time the state was last updated.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.CloneStepResponse']:
        """
        The clone steps list representing its progress.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="targetDetails")
    def target_details(self) -> 'outputs.TargetVMDetailsResponse':
        """
        Details of the VM to create as the target of this clone job. Deprecated: Use compute_engine_target_details instead.
        """
        return pulumi.get(self, "target_details")


@pulumi.output_type
class CloneStepResponse(dict):
    """
    CloneStep holds information about the clone step progress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adaptingOs":
            suggest = "adapting_os"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "instantiatingMigratedVm":
            suggest = "instantiating_migrated_vm"
        elif key == "preparingVmDisks":
            suggest = "preparing_vm_disks"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloneStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloneStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloneStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapting_os: 'outputs.AdaptingOSStepResponse',
                 end_time: str,
                 instantiating_migrated_vm: 'outputs.InstantiatingMigratedVMStepResponse',
                 preparing_vm_disks: 'outputs.PreparingVMDisksStepResponse',
                 start_time: str):
        """
        CloneStep holds information about the clone step progress.
        :param 'AdaptingOSStepResponse' adapting_os: Adapting OS step.
        :param str end_time: The time the step has ended.
        :param 'InstantiatingMigratedVMStepResponse' instantiating_migrated_vm: Instantiating migrated VM step.
        :param 'PreparingVMDisksStepResponse' preparing_vm_disks: Preparing VM disks step.
        :param str start_time: The time the step has started.
        """
        pulumi.set(__self__, "adapting_os", adapting_os)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "instantiating_migrated_vm", instantiating_migrated_vm)
        pulumi.set(__self__, "preparing_vm_disks", preparing_vm_disks)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="adaptingOs")
    def adapting_os(self) -> 'outputs.AdaptingOSStepResponse':
        """
        Adapting OS step.
        """
        return pulumi.get(self, "adapting_os")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time the step has ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="instantiatingMigratedVm")
    def instantiating_migrated_vm(self) -> 'outputs.InstantiatingMigratedVMStepResponse':
        """
        Instantiating migrated VM step.
        """
        return pulumi.get(self, "instantiating_migrated_vm")

    @property
    @pulumi.getter(name="preparingVmDisks")
    def preparing_vm_disks(self) -> 'outputs.PreparingVMDisksStepResponse':
        """
        Preparing VM disks step.
        """
        return pulumi.get(self, "preparing_vm_disks")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time the step has started.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ComputeEngineTargetDefaultsResponse(dict):
    """
    ComputeEngineTargetDefaults is a collection of details for creating a VM in a target Compute Engine project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalLicenses":
            suggest = "additional_licenses"
        elif key == "appliedLicense":
            suggest = "applied_license"
        elif key == "bootOption":
            suggest = "boot_option"
        elif key == "computeScheduling":
            suggest = "compute_scheduling"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "machineTypeSeries":
            suggest = "machine_type_series"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "secureBoot":
            suggest = "secure_boot"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "targetProject":
            suggest = "target_project"
        elif key == "vmName":
            suggest = "vm_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEngineTargetDefaultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEngineTargetDefaultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEngineTargetDefaultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_licenses: Sequence[str],
                 applied_license: 'outputs.AppliedLicenseResponse',
                 boot_option: str,
                 compute_scheduling: 'outputs.ComputeSchedulingResponse',
                 disk_type: str,
                 hostname: str,
                 labels: Mapping[str, str],
                 license_type: str,
                 machine_type: str,
                 machine_type_series: str,
                 metadata: Mapping[str, str],
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 network_tags: Sequence[str],
                 secure_boot: bool,
                 service_account: str,
                 target_project: str,
                 vm_name: str,
                 zone: str):
        """
        ComputeEngineTargetDefaults is a collection of details for creating a VM in a target Compute Engine project.
        :param Sequence[str] additional_licenses: Additional licenses to assign to the VM.
        :param 'AppliedLicenseResponse' applied_license: The OS license returned from the adaptation module report.
        :param str boot_option: The VM Boot Option, as set in the source vm.
        :param 'ComputeSchedulingResponse' compute_scheduling: Compute instance scheduling information (if empty default is used).
        :param str disk_type: The disk type to use in the VM.
        :param str hostname: The hostname to assign to the VM.
        :param Mapping[str, str] labels: A map of labels to associate with the VM.
        :param str license_type: The license type to use in OS adaptation.
        :param str machine_type: The machine type to create the VM with.
        :param str machine_type_series: The machine type series to create the VM with.
        :param Mapping[str, str] metadata: The metadata key/value pairs to assign to the VM.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: List of NICs connected to this VM.
        :param Sequence[str] network_tags: A map of network tags to associate with the VM.
        :param bool secure_boot: Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        :param str service_account: The service account to associate the VM with.
        :param str target_project: The full path of the resource of type TargetProject which represents the Compute Engine project in which to create this VM.
        :param str vm_name: The name of the VM to create.
        :param str zone: The zone in which to create the VM.
        """
        pulumi.set(__self__, "additional_licenses", additional_licenses)
        pulumi.set(__self__, "applied_license", applied_license)
        pulumi.set(__self__, "boot_option", boot_option)
        pulumi.set(__self__, "compute_scheduling", compute_scheduling)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "license_type", license_type)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "machine_type_series", machine_type_series)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "network_tags", network_tags)
        pulumi.set(__self__, "secure_boot", secure_boot)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "target_project", target_project)
        pulumi.set(__self__, "vm_name", vm_name)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalLicenses")
    def additional_licenses(self) -> Sequence[str]:
        """
        Additional licenses to assign to the VM.
        """
        return pulumi.get(self, "additional_licenses")

    @property
    @pulumi.getter(name="appliedLicense")
    def applied_license(self) -> 'outputs.AppliedLicenseResponse':
        """
        The OS license returned from the adaptation module report.
        """
        return pulumi.get(self, "applied_license")

    @property
    @pulumi.getter(name="bootOption")
    def boot_option(self) -> str:
        """
        The VM Boot Option, as set in the source vm.
        """
        return pulumi.get(self, "boot_option")

    @property
    @pulumi.getter(name="computeScheduling")
    def compute_scheduling(self) -> 'outputs.ComputeSchedulingResponse':
        """
        Compute instance scheduling information (if empty default is used).
        """
        return pulumi.get(self, "compute_scheduling")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        The disk type to use in the VM.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname to assign to the VM.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map of labels to associate with the VM.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license type to use in OS adaptation.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to create the VM with.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="machineTypeSeries")
    def machine_type_series(self) -> str:
        """
        The machine type series to create the VM with.
        """
        return pulumi.get(self, "machine_type_series")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata key/value pairs to assign to the VM.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        List of NICs connected to this VM.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Sequence[str]:
        """
        A map of network tags to associate with the VM.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        """
        return pulumi.get(self, "secure_boot")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The service account to associate the VM with.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="targetProject")
    def target_project(self) -> str:
        """
        The full path of the resource of type TargetProject which represents the Compute Engine project in which to create this VM.
        """
        return pulumi.get(self, "target_project")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> str:
        """
        The name of the VM to create.
        """
        return pulumi.get(self, "vm_name")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone in which to create the VM.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ComputeEngineTargetDetailsResponse(dict):
    """
    ComputeEngineTargetDetails is a collection of details for creating a VM in a target Compute Engine project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalLicenses":
            suggest = "additional_licenses"
        elif key == "appliedLicense":
            suggest = "applied_license"
        elif key == "bootOption":
            suggest = "boot_option"
        elif key == "computeScheduling":
            suggest = "compute_scheduling"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "machineTypeSeries":
            suggest = "machine_type_series"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "secureBoot":
            suggest = "secure_boot"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vmName":
            suggest = "vm_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEngineTargetDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEngineTargetDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEngineTargetDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_licenses: Sequence[str],
                 applied_license: 'outputs.AppliedLicenseResponse',
                 boot_option: str,
                 compute_scheduling: 'outputs.ComputeSchedulingResponse',
                 disk_type: str,
                 hostname: str,
                 labels: Mapping[str, str],
                 license_type: str,
                 machine_type: str,
                 machine_type_series: str,
                 metadata: Mapping[str, str],
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 network_tags: Sequence[str],
                 project: str,
                 secure_boot: bool,
                 service_account: str,
                 vm_name: str,
                 zone: str):
        """
        ComputeEngineTargetDetails is a collection of details for creating a VM in a target Compute Engine project.
        :param Sequence[str] additional_licenses: Additional licenses to assign to the VM.
        :param 'AppliedLicenseResponse' applied_license: The OS license returned from the adaptation module report.
        :param str boot_option: The VM Boot Option, as set in the source vm.
        :param 'ComputeSchedulingResponse' compute_scheduling: Compute instance scheduling information (if empty default is used).
        :param str disk_type: The disk type to use in the VM.
        :param str hostname: The hostname to assign to the VM.
        :param Mapping[str, str] labels: A map of labels to associate with the VM.
        :param str license_type: The license type to use in OS adaptation.
        :param str machine_type: The machine type to create the VM with.
        :param str machine_type_series: The machine type series to create the VM with.
        :param Mapping[str, str] metadata: The metadata key/value pairs to assign to the VM.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: List of NICs connected to this VM.
        :param Sequence[str] network_tags: A map of network tags to associate with the VM.
        :param str project: The GCP target project ID or project name.
        :param bool secure_boot: Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        :param str service_account: The service account to associate the VM with.
        :param str vm_name: The name of the VM to create.
        :param str zone: The zone in which to create the VM.
        """
        pulumi.set(__self__, "additional_licenses", additional_licenses)
        pulumi.set(__self__, "applied_license", applied_license)
        pulumi.set(__self__, "boot_option", boot_option)
        pulumi.set(__self__, "compute_scheduling", compute_scheduling)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "license_type", license_type)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "machine_type_series", machine_type_series)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "network_tags", network_tags)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "secure_boot", secure_boot)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "vm_name", vm_name)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalLicenses")
    def additional_licenses(self) -> Sequence[str]:
        """
        Additional licenses to assign to the VM.
        """
        return pulumi.get(self, "additional_licenses")

    @property
    @pulumi.getter(name="appliedLicense")
    def applied_license(self) -> 'outputs.AppliedLicenseResponse':
        """
        The OS license returned from the adaptation module report.
        """
        return pulumi.get(self, "applied_license")

    @property
    @pulumi.getter(name="bootOption")
    def boot_option(self) -> str:
        """
        The VM Boot Option, as set in the source vm.
        """
        return pulumi.get(self, "boot_option")

    @property
    @pulumi.getter(name="computeScheduling")
    def compute_scheduling(self) -> 'outputs.ComputeSchedulingResponse':
        """
        Compute instance scheduling information (if empty default is used).
        """
        return pulumi.get(self, "compute_scheduling")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        The disk type to use in the VM.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname to assign to the VM.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map of labels to associate with the VM.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license type to use in OS adaptation.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to create the VM with.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="machineTypeSeries")
    def machine_type_series(self) -> str:
        """
        The machine type series to create the VM with.
        """
        return pulumi.get(self, "machine_type_series")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata key/value pairs to assign to the VM.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        List of NICs connected to this VM.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Sequence[str]:
        """
        A map of network tags to associate with the VM.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The GCP target project ID or project name.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        """
        return pulumi.get(self, "secure_boot")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The service account to associate the VM with.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> str:
        """
        The name of the VM to create.
        """
        return pulumi.get(self, "vm_name")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone in which to create the VM.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ComputeSchedulingResponse(dict):
    """
    Scheduling information for VM on maintenance/restart behaviour and node allocation in sole tenant nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticRestart":
            suggest = "automatic_restart"
        elif key == "minNodeCpus":
            suggest = "min_node_cpus"
        elif key == "nodeAffinities":
            suggest = "node_affinities"
        elif key == "onHostMaintenance":
            suggest = "on_host_maintenance"
        elif key == "restartType":
            suggest = "restart_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeSchedulingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeSchedulingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeSchedulingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_restart: bool,
                 min_node_cpus: int,
                 node_affinities: Sequence['outputs.SchedulingNodeAffinityResponse'],
                 on_host_maintenance: str,
                 restart_type: str):
        """
        Scheduling information for VM on maintenance/restart behaviour and node allocation in sole tenant nodes.
        :param int min_node_cpus: The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node. Ignored if no node_affinites are configured.
        :param Sequence['SchedulingNodeAffinityResponse'] node_affinities: A set of node affinity and anti-affinity configurations for sole tenant nodes.
        :param str on_host_maintenance: How the instance should behave when the host machine undergoes maintenance that may temporarily impact instance performance.
        :param str restart_type: Whether the Instance should be automatically restarted whenever it is terminated by Compute Engine (not terminated by user). This configuration is identical to `automaticRestart` field in Compute Engine create instance under scheduling. It was changed to an enum (instead of a boolean) to match the default value in Compute Engine which is automatic restart.
        """
        pulumi.set(__self__, "automatic_restart", automatic_restart)
        pulumi.set(__self__, "min_node_cpus", min_node_cpus)
        pulumi.set(__self__, "node_affinities", node_affinities)
        pulumi.set(__self__, "on_host_maintenance", on_host_maintenance)
        pulumi.set(__self__, "restart_type", restart_type)

    @property
    @pulumi.getter(name="automaticRestart")
    def automatic_restart(self) -> bool:
        return pulumi.get(self, "automatic_restart")

    @property
    @pulumi.getter(name="minNodeCpus")
    def min_node_cpus(self) -> int:
        """
        The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node. Ignored if no node_affinites are configured.
        """
        return pulumi.get(self, "min_node_cpus")

    @property
    @pulumi.getter(name="nodeAffinities")
    def node_affinities(self) -> Sequence['outputs.SchedulingNodeAffinityResponse']:
        """
        A set of node affinity and anti-affinity configurations for sole tenant nodes.
        """
        return pulumi.get(self, "node_affinities")

    @property
    @pulumi.getter(name="onHostMaintenance")
    def on_host_maintenance(self) -> str:
        """
        How the instance should behave when the host machine undergoes maintenance that may temporarily impact instance performance.
        """
        return pulumi.get(self, "on_host_maintenance")

    @property
    @pulumi.getter(name="restartType")
    def restart_type(self) -> str:
        """
        Whether the Instance should be automatically restarted whenever it is terminated by Compute Engine (not terminated by user). This configuration is identical to `automaticRestart` field in Compute Engine create instance under scheduling. It was changed to an enum (instead of a boolean) to match the default value in Compute Engine which is automatic restart.
        """
        return pulumi.get(self, "restart_type")


@pulumi.output_type
class CutoverJobResponse(dict):
    """
    CutoverJob message describes a cutover of a migrating VM. The CutoverJob is the operation of shutting down the VM, creating a snapshot and clonning the VM using the replicated snapshot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeEngineTargetDetails":
            suggest = "compute_engine_target_details"
        elif key == "computeEngineVmDetails":
            suggest = "compute_engine_vm_details"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "progressPercent":
            suggest = "progress_percent"
        elif key == "stateMessage":
            suggest = "state_message"
        elif key == "stateTime":
            suggest = "state_time"
        elif key == "targetDetails":
            suggest = "target_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CutoverJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CutoverJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CutoverJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_engine_target_details: 'outputs.ComputeEngineTargetDetailsResponse',
                 compute_engine_vm_details: 'outputs.TargetVMDetailsResponse',
                 create_time: str,
                 end_time: str,
                 error: 'outputs.StatusResponse',
                 name: str,
                 progress: int,
                 progress_percent: int,
                 state: str,
                 state_message: str,
                 state_time: str,
                 steps: Sequence['outputs.CutoverStepResponse'],
                 target_details: 'outputs.TargetVMDetailsResponse'):
        """
        CutoverJob message describes a cutover of a migrating VM. The CutoverJob is the operation of shutting down the VM, creating a snapshot and clonning the VM using the replicated snapshot.
        :param 'ComputeEngineTargetDetailsResponse' compute_engine_target_details: Details of the target VM in Compute Engine.
        :param 'TargetVMDetailsResponse' compute_engine_vm_details: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_details instead.
        :param str create_time: The time the cutover job was created (as an API call, not when it was actually created in the target).
        :param str end_time: The time the cutover job had finished.
        :param 'StatusResponse' error: Provides details for the errors that led to the Cutover Job's state.
        :param str name: The name of the cutover job.
        :param int progress: The current progress in percentage of the cutover job.
        :param int progress_percent: The current progress in percentage of the cutover job.
        :param str state: State of the cutover job.
        :param str state_message: A message providing possible extra details about the current state.
        :param str state_time: The time the state was last updated.
        :param Sequence['CutoverStepResponse'] steps: The cutover steps list representing its progress.
        :param 'TargetVMDetailsResponse' target_details: Details of the VM to create as the target of this cutover job. Deprecated: Use compute_engine_target_details instead.
        """
        pulumi.set(__self__, "compute_engine_target_details", compute_engine_target_details)
        pulumi.set(__self__, "compute_engine_vm_details", compute_engine_vm_details)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "progress_percent", progress_percent)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "state_time", state_time)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "target_details", target_details)

    @property
    @pulumi.getter(name="computeEngineTargetDetails")
    def compute_engine_target_details(self) -> 'outputs.ComputeEngineTargetDetailsResponse':
        """
        Details of the target VM in Compute Engine.
        """
        return pulumi.get(self, "compute_engine_target_details")

    @property
    @pulumi.getter(name="computeEngineVmDetails")
    def compute_engine_vm_details(self) -> 'outputs.TargetVMDetailsResponse':
        """
        Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_details instead.
        """
        return pulumi.get(self, "compute_engine_vm_details")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time the cutover job was created (as an API call, not when it was actually created in the target).
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time the cutover job had finished.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        Provides details for the errors that led to the Cutover Job's state.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the cutover job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def progress(self) -> int:
        """
        The current progress in percentage of the cutover job.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="progressPercent")
    def progress_percent(self) -> int:
        """
        The current progress in percentage of the cutover job.
        """
        return pulumi.get(self, "progress_percent")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the cutover job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        A message providing possible extra details about the current state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> str:
        """
        The time the state was last updated.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.CutoverStepResponse']:
        """
        The cutover steps list representing its progress.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="targetDetails")
    def target_details(self) -> 'outputs.TargetVMDetailsResponse':
        """
        Details of the VM to create as the target of this cutover job. Deprecated: Use compute_engine_target_details instead.
        """
        return pulumi.get(self, "target_details")


@pulumi.output_type
class CutoverStepResponse(dict):
    """
    CutoverStep holds information about the cutover step progress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "finalSync":
            suggest = "final_sync"
        elif key == "instantiatingMigratedVm":
            suggest = "instantiating_migrated_vm"
        elif key == "preparingVmDisks":
            suggest = "preparing_vm_disks"
        elif key == "previousReplicationCycle":
            suggest = "previous_replication_cycle"
        elif key == "shuttingDownSourceVm":
            suggest = "shutting_down_source_vm"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CutoverStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CutoverStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CutoverStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 final_sync: 'outputs.ReplicationCycleResponse',
                 instantiating_migrated_vm: 'outputs.InstantiatingMigratedVMStepResponse',
                 preparing_vm_disks: 'outputs.PreparingVMDisksStepResponse',
                 previous_replication_cycle: 'outputs.ReplicationCycleResponse',
                 shutting_down_source_vm: 'outputs.ShuttingDownSourceVMStepResponse',
                 start_time: str):
        """
        CutoverStep holds information about the cutover step progress.
        :param str end_time: The time the step has ended.
        :param 'ReplicationCycleResponse' final_sync: Final sync step.
        :param 'InstantiatingMigratedVMStepResponse' instantiating_migrated_vm: Instantiating migrated VM step.
        :param 'PreparingVMDisksStepResponse' preparing_vm_disks: Preparing VM disks step.
        :param 'ReplicationCycleResponse' previous_replication_cycle: A replication cycle prior cutover step.
        :param 'ShuttingDownSourceVMStepResponse' shutting_down_source_vm: Shutting down VM step.
        :param str start_time: The time the step has started.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "final_sync", final_sync)
        pulumi.set(__self__, "instantiating_migrated_vm", instantiating_migrated_vm)
        pulumi.set(__self__, "preparing_vm_disks", preparing_vm_disks)
        pulumi.set(__self__, "previous_replication_cycle", previous_replication_cycle)
        pulumi.set(__self__, "shutting_down_source_vm", shutting_down_source_vm)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time the step has ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="finalSync")
    def final_sync(self) -> 'outputs.ReplicationCycleResponse':
        """
        Final sync step.
        """
        return pulumi.get(self, "final_sync")

    @property
    @pulumi.getter(name="instantiatingMigratedVm")
    def instantiating_migrated_vm(self) -> 'outputs.InstantiatingMigratedVMStepResponse':
        """
        Instantiating migrated VM step.
        """
        return pulumi.get(self, "instantiating_migrated_vm")

    @property
    @pulumi.getter(name="preparingVmDisks")
    def preparing_vm_disks(self) -> 'outputs.PreparingVMDisksStepResponse':
        """
        Preparing VM disks step.
        """
        return pulumi.get(self, "preparing_vm_disks")

    @property
    @pulumi.getter(name="previousReplicationCycle")
    def previous_replication_cycle(self) -> 'outputs.ReplicationCycleResponse':
        """
        A replication cycle prior cutover step.
        """
        return pulumi.get(self, "previous_replication_cycle")

    @property
    @pulumi.getter(name="shuttingDownSourceVm")
    def shutting_down_source_vm(self) -> 'outputs.ShuttingDownSourceVMStepResponse':
        """
        Shutting down VM step.
        """
        return pulumi.get(self, "shutting_down_source_vm")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time the step has started.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class CycleStepResponse(dict):
    """
    CycleStep holds information about a step progress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "initializingReplication":
            suggest = "initializing_replication"
        elif key == "postProcessing":
            suggest = "post_processing"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CycleStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CycleStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CycleStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 initializing_replication: 'outputs.InitializingReplicationStepResponse',
                 post_processing: 'outputs.PostProcessingStepResponse',
                 replicating: 'outputs.ReplicatingStepResponse',
                 start_time: str):
        """
        CycleStep holds information about a step progress.
        :param str end_time: The time the cycle step has ended.
        :param 'InitializingReplicationStepResponse' initializing_replication: Initializing replication step.
        :param 'PostProcessingStepResponse' post_processing: Post processing step.
        :param 'ReplicatingStepResponse' replicating: Replicating step.
        :param str start_time: The time the cycle step has started.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "initializing_replication", initializing_replication)
        pulumi.set(__self__, "post_processing", post_processing)
        pulumi.set(__self__, "replicating", replicating)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time the cycle step has ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="initializingReplication")
    def initializing_replication(self) -> 'outputs.InitializingReplicationStepResponse':
        """
        Initializing replication step.
        """
        return pulumi.get(self, "initializing_replication")

    @property
    @pulumi.getter(name="postProcessing")
    def post_processing(self) -> 'outputs.PostProcessingStepResponse':
        """
        Post processing step.
        """
        return pulumi.get(self, "post_processing")

    @property
    @pulumi.getter
    def replicating(self) -> 'outputs.ReplicatingStepResponse':
        """
        Replicating step.
        """
        return pulumi.get(self, "replicating")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time the cycle step has started.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InitializingReplicationStepResponse(dict):
    """
    InitializingReplicationStep contains specific step details.
    """
    def __init__(__self__):
        """
        InitializingReplicationStep contains specific step details.
        """
        pass


@pulumi.output_type
class InstantiatingMigratedVMStepResponse(dict):
    """
    InstantiatingMigratedVMStep contains specific step details.
    """
    def __init__(__self__):
        """
        InstantiatingMigratedVMStep contains specific step details.
        """
        pass


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    NetworkInterface represents a NIC of a VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalIp":
            suggest = "external_ip"
        elif key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_ip: str,
                 internal_ip: str,
                 network: str,
                 subnetwork: str):
        """
        NetworkInterface represents a NIC of a VM.
        :param str external_ip: The external IP to define in the NIC.
        :param str internal_ip: The internal IP to define in the NIC. The formats accepted are: `ephemeral` \ ipv4 address \ a named address resource full path.
        :param str network: The network to connect the NIC to.
        :param str subnetwork: The subnetwork to connect the NIC to.
        """
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        The external IP to define in the NIC.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        The internal IP to define in the NIC. The formats accepted are: `ephemeral` \ ipv4 address \ a named address resource full path.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The network to connect the NIC to.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The subnetwork to connect the NIC to.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class PostProcessingStepResponse(dict):
    """
    PostProcessingStep contains specific step details.
    """
    def __init__(__self__):
        """
        PostProcessingStep contains specific step details.
        """
        pass


@pulumi.output_type
class PreparingVMDisksStepResponse(dict):
    """
    PreparingVMDisksStep contains specific step details.
    """
    def __init__(__self__):
        """
        PreparingVMDisksStep contains specific step details.
        """
        pass


@pulumi.output_type
class ReplicatingStepResponse(dict):
    """
    ReplicatingStep contains specific step details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastThirtyMinutesAverageBytesPerSecond":
            suggest = "last_thirty_minutes_average_bytes_per_second"
        elif key == "lastTwoMinutesAverageBytesPerSecond":
            suggest = "last_two_minutes_average_bytes_per_second"
        elif key == "replicatedBytes":
            suggest = "replicated_bytes"
        elif key == "totalBytes":
            suggest = "total_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatingStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatingStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatingStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_thirty_minutes_average_bytes_per_second: str,
                 last_two_minutes_average_bytes_per_second: str,
                 replicated_bytes: str,
                 total_bytes: str):
        """
        ReplicatingStep contains specific step details.
        :param str last_thirty_minutes_average_bytes_per_second: The source disks replication rate for the last 30 minutes in bytes per second.
        :param str last_two_minutes_average_bytes_per_second: The source disks replication rate for the last 2 minutes in bytes per second.
        :param str replicated_bytes: Replicated bytes in the step.
        :param str total_bytes: Total bytes to be handled in the step.
        """
        pulumi.set(__self__, "last_thirty_minutes_average_bytes_per_second", last_thirty_minutes_average_bytes_per_second)
        pulumi.set(__self__, "last_two_minutes_average_bytes_per_second", last_two_minutes_average_bytes_per_second)
        pulumi.set(__self__, "replicated_bytes", replicated_bytes)
        pulumi.set(__self__, "total_bytes", total_bytes)

    @property
    @pulumi.getter(name="lastThirtyMinutesAverageBytesPerSecond")
    def last_thirty_minutes_average_bytes_per_second(self) -> str:
        """
        The source disks replication rate for the last 30 minutes in bytes per second.
        """
        return pulumi.get(self, "last_thirty_minutes_average_bytes_per_second")

    @property
    @pulumi.getter(name="lastTwoMinutesAverageBytesPerSecond")
    def last_two_minutes_average_bytes_per_second(self) -> str:
        """
        The source disks replication rate for the last 2 minutes in bytes per second.
        """
        return pulumi.get(self, "last_two_minutes_average_bytes_per_second")

    @property
    @pulumi.getter(name="replicatedBytes")
    def replicated_bytes(self) -> str:
        """
        Replicated bytes in the step.
        """
        return pulumi.get(self, "replicated_bytes")

    @property
    @pulumi.getter(name="totalBytes")
    def total_bytes(self) -> str:
        """
        Total bytes to be handled in the step.
        """
        return pulumi.get(self, "total_bytes")


@pulumi.output_type
class ReplicationCycleResponse(dict):
    """
    ReplicationCycle contains information about the current replication cycle status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "progressPercent":
            suggest = "progress_percent"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "totalPauseDuration":
            suggest = "total_pause_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationCycleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationCycleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationCycleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 name: str,
                 progress: int,
                 progress_percent: int,
                 start_time: str,
                 steps: Sequence['outputs.CycleStepResponse'],
                 total_pause_duration: str):
        """
        ReplicationCycle contains information about the current replication cycle status.
        :param str end_time: The time the replication cycle has ended.
        :param str name: The identifier of the ReplicationCycle.
        :param int progress: The current progress in percentage of this cycle.
        :param int progress_percent: The current progress in percentage of this cycle.
        :param str start_time: The time the replication cycle has started.
        :param Sequence['CycleStepResponse'] steps: The cycle's steps list representing its progress.
        :param str total_pause_duration: The accumulated duration the replication cycle was paused.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "progress_percent", progress_percent)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "total_pause_duration", total_pause_duration)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time the replication cycle has ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The identifier of the ReplicationCycle.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def progress(self) -> int:
        """
        The current progress in percentage of this cycle.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="progressPercent")
    def progress_percent(self) -> int:
        """
        The current progress in percentage of this cycle.
        """
        return pulumi.get(self, "progress_percent")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time the replication cycle has started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.CycleStepResponse']:
        """
        The cycle's steps list representing its progress.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="totalPauseDuration")
    def total_pause_duration(self) -> str:
        """
        The accumulated duration the replication cycle was paused.
        """
        return pulumi.get(self, "total_pause_duration")


@pulumi.output_type
class ReplicationSyncResponse(dict):
    """
    ReplicationSync contain information about the last replica sync to the cloud.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastSyncTime":
            suggest = "last_sync_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationSyncResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationSyncResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationSyncResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_sync_time: str):
        """
        ReplicationSync contain information about the last replica sync to the cloud.
        :param str last_sync_time: The most updated snapshot created time in the source that finished replication.
        """
        pulumi.set(__self__, "last_sync_time", last_sync_time)

    @property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> str:
        """
        The most updated snapshot created time in the source that finished replication.
        """
        return pulumi.get(self, "last_sync_time")


@pulumi.output_type
class SchedulePolicyResponse(dict):
    """
    A policy for scheduling replications.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleDuration":
            suggest = "idle_duration"
        elif key == "skipOsAdaptation":
            suggest = "skip_os_adaptation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_duration: str,
                 skip_os_adaptation: bool):
        """
        A policy for scheduling replications.
        :param str idle_duration: The idle duration between replication stages.
        :param bool skip_os_adaptation: A flag to indicate whether to skip OS adaptation during the replication sync. OS adaptation is a process where the VM's operating system undergoes changes and adaptations to fully function on Compute Engine.
        """
        pulumi.set(__self__, "idle_duration", idle_duration)
        pulumi.set(__self__, "skip_os_adaptation", skip_os_adaptation)

    @property
    @pulumi.getter(name="idleDuration")
    def idle_duration(self) -> str:
        """
        The idle duration between replication stages.
        """
        return pulumi.get(self, "idle_duration")

    @property
    @pulumi.getter(name="skipOsAdaptation")
    def skip_os_adaptation(self) -> bool:
        """
        A flag to indicate whether to skip OS adaptation during the replication sync. OS adaptation is a process where the VM's operating system undergoes changes and adaptations to fully function on Compute Engine.
        """
        return pulumi.get(self, "skip_os_adaptation")


@pulumi.output_type
class SchedulingNodeAffinityResponse(dict):
    """
    Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled. Based on https://cloud.google.com/compute/docs/reference/rest/v1/instances/setScheduling
    """
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled. Based on https://cloud.google.com/compute/docs/reference/rest/v1/instances/setScheduling
        :param str key: The label key of Node resource to reference.
        :param str operator: The operator to use for the node resources specified in the `values` parameter.
        :param Sequence[str] values: Corresponds to the label values of Node resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The label key of Node resource to reference.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use for the node resources specified in the `values` parameter.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Corresponds to the label values of Node resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ShuttingDownSourceVMStepResponse(dict):
    """
    ShuttingDownSourceVMStep contains specific step details.
    """
    def __init__(__self__):
        """
        ShuttingDownSourceVMStep contains specific step details.
        """
        pass


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class TargetVMDetailsResponse(dict):
    """
    TargetVMDetails is a collection of details for creating a VM in a target Compute Engine project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedLicense":
            suggest = "applied_license"
        elif key == "bootOption":
            suggest = "boot_option"
        elif key == "computeScheduling":
            suggest = "compute_scheduling"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "externalIp":
            suggest = "external_ip"
        elif key == "internalIp":
            suggest = "internal_ip"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "machineTypeSeries":
            suggest = "machine_type_series"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "secureBoot":
            suggest = "secure_boot"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "targetProject":
            suggest = "target_project"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetVMDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetVMDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetVMDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_license: 'outputs.AppliedLicenseResponse',
                 boot_option: str,
                 compute_scheduling: 'outputs.ComputeSchedulingResponse',
                 disk_type: str,
                 external_ip: str,
                 internal_ip: str,
                 labels: Mapping[str, str],
                 license_type: str,
                 machine_type: str,
                 machine_type_series: str,
                 metadata: Mapping[str, str],
                 name: str,
                 network: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 network_tags: Sequence[str],
                 project: str,
                 secure_boot: bool,
                 service_account: str,
                 subnetwork: str,
                 target_project: str,
                 zone: str):
        """
        TargetVMDetails is a collection of details for creating a VM in a target Compute Engine project.
        :param 'AppliedLicenseResponse' applied_license: The OS license returned from the adaptation module report.
        :param str boot_option: The VM Boot Option, as set in the source vm.
        :param 'ComputeSchedulingResponse' compute_scheduling: Compute instance scheduling information (if empty default is used).
        :param str disk_type: The disk type to use in the VM.
        :param str external_ip: The external IP to define in the VM.
        :param str internal_ip: The internal IP to define in the VM. The formats accepted are: `ephemeral` \ ipv4 address \ a named address resource full path.
        :param Mapping[str, str] labels: A map of labels to associate with the VM.
        :param str license_type: The license type to use in OS adaptation.
        :param str machine_type: The machine type to create the VM with.
        :param str machine_type_series: The machine type series to create the VM with.
        :param Mapping[str, str] metadata: The metadata key/value pairs to assign to the VM.
        :param str name: The name of the VM to create.
        :param str network: The network to connect the VM to.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: List of NICs connected to this VM.
        :param Sequence[str] network_tags: A map of network tags to associate with the VM.
        :param str project: The project in which to create the VM.
        :param bool secure_boot: Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        :param str service_account: The service account to associate the VM with.
        :param str subnetwork: The subnetwork to connect the VM to.
        :param str target_project: The full path of the resource of type TargetProject which represents the Compute Engine project in which to create this VM.
        :param str zone: The zone in which to create the VM.
        """
        pulumi.set(__self__, "applied_license", applied_license)
        pulumi.set(__self__, "boot_option", boot_option)
        pulumi.set(__self__, "compute_scheduling", compute_scheduling)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "license_type", license_type)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "machine_type_series", machine_type_series)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "network_tags", network_tags)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "secure_boot", secure_boot)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "target_project", target_project)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="appliedLicense")
    def applied_license(self) -> 'outputs.AppliedLicenseResponse':
        """
        The OS license returned from the adaptation module report.
        """
        return pulumi.get(self, "applied_license")

    @property
    @pulumi.getter(name="bootOption")
    def boot_option(self) -> str:
        """
        The VM Boot Option, as set in the source vm.
        """
        return pulumi.get(self, "boot_option")

    @property
    @pulumi.getter(name="computeScheduling")
    def compute_scheduling(self) -> 'outputs.ComputeSchedulingResponse':
        """
        Compute instance scheduling information (if empty default is used).
        """
        return pulumi.get(self, "compute_scheduling")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        The disk type to use in the VM.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        The external IP to define in the VM.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        The internal IP to define in the VM. The formats accepted are: `ephemeral` \ ipv4 address \ a named address resource full path.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map of labels to associate with the VM.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license type to use in OS adaptation.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to create the VM with.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="machineTypeSeries")
    def machine_type_series(self) -> str:
        """
        The machine type series to create the VM with.
        """
        return pulumi.get(self, "machine_type_series")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata key/value pairs to assign to the VM.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the VM to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The network to connect the VM to.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        List of NICs connected to this VM.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Sequence[str]:
        """
        A map of network tags to associate with the VM.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The project in which to create the VM.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        """
        return pulumi.get(self, "secure_boot")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The service account to associate the VM with.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The subnetwork to connect the VM to.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="targetProject")
    def target_project(self) -> str:
        """
        The full path of the resource of type TargetProject which represents the Compute Engine project in which to create this VM.
        """
        return pulumi.get(self, "target_project")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone in which to create the VM.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class UpgradeStatusResponse(dict):
    """
    UpgradeStatus contains information about upgradeAppliance operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "previousVersion":
            suggest = "previous_version"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: 'outputs.StatusResponse',
                 previous_version: str,
                 start_time: str,
                 state: str,
                 version: str):
        """
        UpgradeStatus contains information about upgradeAppliance operation.
        :param 'StatusResponse' error: Provides details on the state of the upgrade operation in case of an error.
        :param str previous_version: The version from which we upgraded.
        :param str start_time: The time the operation was started.
        :param str state: The state of the upgradeAppliance operation.
        :param str version: The version to upgrade to.
        """
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "previous_version", previous_version)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        Provides details on the state of the upgrade operation in case of an error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="previousVersion")
    def previous_version(self) -> str:
        """
        The version from which we upgraded.
        """
        return pulumi.get(self, "previous_version")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time the operation was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the upgradeAppliance operation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version to upgrade to.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VmUtilizationInfoResponse(dict):
    """
    Utilization information of a single VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmId":
            suggest = "vm_id"
        elif key == "vmwareVmDetails":
            suggest = "vmware_vm_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmUtilizationInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmUtilizationInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmUtilizationInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 utilization: 'outputs.VmUtilizationMetricsResponse',
                 vm_id: str,
                 vmware_vm_details: 'outputs.VmwareVmDetailsResponse'):
        """
        Utilization information of a single VM.
        :param 'VmUtilizationMetricsResponse' utilization: Utilization metrics for this VM.
        :param str vm_id: The VM's ID in the source.
        :param 'VmwareVmDetailsResponse' vmware_vm_details: The description of the VM in a Source of type Vmware.
        """
        pulumi.set(__self__, "utilization", utilization)
        pulumi.set(__self__, "vm_id", vm_id)
        pulumi.set(__self__, "vmware_vm_details", vmware_vm_details)

    @property
    @pulumi.getter
    def utilization(self) -> 'outputs.VmUtilizationMetricsResponse':
        """
        Utilization metrics for this VM.
        """
        return pulumi.get(self, "utilization")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> str:
        """
        The VM's ID in the source.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmwareVmDetails")
    def vmware_vm_details(self) -> 'outputs.VmwareVmDetailsResponse':
        """
        The description of the VM in a Source of type Vmware.
        """
        return pulumi.get(self, "vmware_vm_details")


@pulumi.output_type
class VmUtilizationMetricsResponse(dict):
    """
    Utilization metrics values for a single VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuAverage":
            suggest = "cpu_average"
        elif key == "cpuAveragePercent":
            suggest = "cpu_average_percent"
        elif key == "cpuMax":
            suggest = "cpu_max"
        elif key == "cpuMaxPercent":
            suggest = "cpu_max_percent"
        elif key == "diskIoRateAverage":
            suggest = "disk_io_rate_average"
        elif key == "diskIoRateAverageKbps":
            suggest = "disk_io_rate_average_kbps"
        elif key == "diskIoRateMax":
            suggest = "disk_io_rate_max"
        elif key == "diskIoRateMaxKbps":
            suggest = "disk_io_rate_max_kbps"
        elif key == "memoryAverage":
            suggest = "memory_average"
        elif key == "memoryAveragePercent":
            suggest = "memory_average_percent"
        elif key == "memoryMax":
            suggest = "memory_max"
        elif key == "memoryMaxPercent":
            suggest = "memory_max_percent"
        elif key == "networkThroughputAverage":
            suggest = "network_throughput_average"
        elif key == "networkThroughputAverageKbps":
            suggest = "network_throughput_average_kbps"
        elif key == "networkThroughputMax":
            suggest = "network_throughput_max"
        elif key == "networkThroughputMaxKbps":
            suggest = "network_throughput_max_kbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmUtilizationMetricsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmUtilizationMetricsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmUtilizationMetricsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_average: int,
                 cpu_average_percent: int,
                 cpu_max: int,
                 cpu_max_percent: int,
                 disk_io_rate_average: str,
                 disk_io_rate_average_kbps: str,
                 disk_io_rate_max: str,
                 disk_io_rate_max_kbps: str,
                 memory_average: int,
                 memory_average_percent: int,
                 memory_max: int,
                 memory_max_percent: int,
                 network_throughput_average: str,
                 network_throughput_average_kbps: str,
                 network_throughput_max: str,
                 network_throughput_max_kbps: str):
        """
        Utilization metrics values for a single VM.
        :param int cpu_average: Average CPU usage, percent.
        :param int cpu_average_percent: Average CPU usage, percent.
        :param int cpu_max: Max CPU usage, percent.
        :param int cpu_max_percent: Max CPU usage, percent.
        :param str disk_io_rate_average: Average disk IO rate, in kilobytes per second.
        :param str disk_io_rate_average_kbps: Average disk IO rate, in kilobytes per second.
        :param str disk_io_rate_max: Max disk IO rate, in kilobytes per second.
        :param str disk_io_rate_max_kbps: Max disk IO rate, in kilobytes per second.
        :param int memory_average: Average memory usage, percent.
        :param int memory_average_percent: Average memory usage, percent.
        :param int memory_max: Max memory usage, percent.
        :param int memory_max_percent: Max memory usage, percent.
        :param str network_throughput_average: Average network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        :param str network_throughput_average_kbps: Average network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        :param str network_throughput_max: Max network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        :param str network_throughput_max_kbps: Max network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        pulumi.set(__self__, "cpu_average", cpu_average)
        pulumi.set(__self__, "cpu_average_percent", cpu_average_percent)
        pulumi.set(__self__, "cpu_max", cpu_max)
        pulumi.set(__self__, "cpu_max_percent", cpu_max_percent)
        pulumi.set(__self__, "disk_io_rate_average", disk_io_rate_average)
        pulumi.set(__self__, "disk_io_rate_average_kbps", disk_io_rate_average_kbps)
        pulumi.set(__self__, "disk_io_rate_max", disk_io_rate_max)
        pulumi.set(__self__, "disk_io_rate_max_kbps", disk_io_rate_max_kbps)
        pulumi.set(__self__, "memory_average", memory_average)
        pulumi.set(__self__, "memory_average_percent", memory_average_percent)
        pulumi.set(__self__, "memory_max", memory_max)
        pulumi.set(__self__, "memory_max_percent", memory_max_percent)
        pulumi.set(__self__, "network_throughput_average", network_throughput_average)
        pulumi.set(__self__, "network_throughput_average_kbps", network_throughput_average_kbps)
        pulumi.set(__self__, "network_throughput_max", network_throughput_max)
        pulumi.set(__self__, "network_throughput_max_kbps", network_throughput_max_kbps)

    @property
    @pulumi.getter(name="cpuAverage")
    def cpu_average(self) -> int:
        """
        Average CPU usage, percent.
        """
        return pulumi.get(self, "cpu_average")

    @property
    @pulumi.getter(name="cpuAveragePercent")
    def cpu_average_percent(self) -> int:
        """
        Average CPU usage, percent.
        """
        return pulumi.get(self, "cpu_average_percent")

    @property
    @pulumi.getter(name="cpuMax")
    def cpu_max(self) -> int:
        """
        Max CPU usage, percent.
        """
        return pulumi.get(self, "cpu_max")

    @property
    @pulumi.getter(name="cpuMaxPercent")
    def cpu_max_percent(self) -> int:
        """
        Max CPU usage, percent.
        """
        return pulumi.get(self, "cpu_max_percent")

    @property
    @pulumi.getter(name="diskIoRateAverage")
    def disk_io_rate_average(self) -> str:
        """
        Average disk IO rate, in kilobytes per second.
        """
        return pulumi.get(self, "disk_io_rate_average")

    @property
    @pulumi.getter(name="diskIoRateAverageKbps")
    def disk_io_rate_average_kbps(self) -> str:
        """
        Average disk IO rate, in kilobytes per second.
        """
        return pulumi.get(self, "disk_io_rate_average_kbps")

    @property
    @pulumi.getter(name="diskIoRateMax")
    def disk_io_rate_max(self) -> str:
        """
        Max disk IO rate, in kilobytes per second.
        """
        return pulumi.get(self, "disk_io_rate_max")

    @property
    @pulumi.getter(name="diskIoRateMaxKbps")
    def disk_io_rate_max_kbps(self) -> str:
        """
        Max disk IO rate, in kilobytes per second.
        """
        return pulumi.get(self, "disk_io_rate_max_kbps")

    @property
    @pulumi.getter(name="memoryAverage")
    def memory_average(self) -> int:
        """
        Average memory usage, percent.
        """
        return pulumi.get(self, "memory_average")

    @property
    @pulumi.getter(name="memoryAveragePercent")
    def memory_average_percent(self) -> int:
        """
        Average memory usage, percent.
        """
        return pulumi.get(self, "memory_average_percent")

    @property
    @pulumi.getter(name="memoryMax")
    def memory_max(self) -> int:
        """
        Max memory usage, percent.
        """
        return pulumi.get(self, "memory_max")

    @property
    @pulumi.getter(name="memoryMaxPercent")
    def memory_max_percent(self) -> int:
        """
        Max memory usage, percent.
        """
        return pulumi.get(self, "memory_max_percent")

    @property
    @pulumi.getter(name="networkThroughputAverage")
    def network_throughput_average(self) -> str:
        """
        Average network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        return pulumi.get(self, "network_throughput_average")

    @property
    @pulumi.getter(name="networkThroughputAverageKbps")
    def network_throughput_average_kbps(self) -> str:
        """
        Average network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        return pulumi.get(self, "network_throughput_average_kbps")

    @property
    @pulumi.getter(name="networkThroughputMax")
    def network_throughput_max(self) -> str:
        """
        Max network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        return pulumi.get(self, "network_throughput_max")

    @property
    @pulumi.getter(name="networkThroughputMaxKbps")
    def network_throughput_max_kbps(self) -> str:
        """
        Max network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        return pulumi.get(self, "network_throughput_max_kbps")


@pulumi.output_type
class VmwareSourceDetailsResponse(dict):
    """
    VmwareSourceDetails message describes a specific source details for the vmware source type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vcenterIp":
            suggest = "vcenter_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmwareSourceDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmwareSourceDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmwareSourceDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 thumbprint: str,
                 username: str,
                 vcenter_ip: str):
        """
        VmwareSourceDetails message describes a specific source details for the vmware source type.
        :param str password: Input only. The credentials password. This is write only and can not be read in a GET operation.
        :param str thumbprint: The thumbprint representing the certificate for the vcenter.
        :param str username: The credentials username.
        :param str vcenter_ip: The ip address of the vcenter this Source represents.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "vcenter_ip", vcenter_ip)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Input only. The credentials password. This is write only and can not be read in a GET operation.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        The thumbprint representing the certificate for the vcenter.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The credentials username.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vcenterIp")
    def vcenter_ip(self) -> str:
        """
        The ip address of the vcenter this Source represents.
        """
        return pulumi.get(self, "vcenter_ip")


@pulumi.output_type
class VmwareVmDetailsResponse(dict):
    """
    VmwareVmDetails describes a VM in vCenter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootOption":
            suggest = "boot_option"
        elif key == "committedStorage":
            suggest = "committed_storage"
        elif key == "committedStorageMb":
            suggest = "committed_storage_mb"
        elif key == "cpuCount":
            suggest = "cpu_count"
        elif key == "datacenterDescription":
            suggest = "datacenter_description"
        elif key == "datacenterId":
            suggest = "datacenter_id"
        elif key == "diskCount":
            suggest = "disk_count"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "guestDescription":
            suggest = "guest_description"
        elif key == "memoryMb":
            suggest = "memory_mb"
        elif key == "powerState":
            suggest = "power_state"
        elif key == "vmId":
            suggest = "vm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmwareVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmwareVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmwareVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_option: str,
                 committed_storage: str,
                 committed_storage_mb: str,
                 cpu_count: int,
                 datacenter_description: str,
                 datacenter_id: str,
                 disk_count: int,
                 display_name: str,
                 guest_description: str,
                 memory_mb: int,
                 power_state: str,
                 uuid: str,
                 vm_id: str):
        """
        VmwareVmDetails describes a VM in vCenter.
        :param str boot_option: The VM Boot Option.
        :param str committed_storage: The total size of the storage allocated to the VM in MB.
        :param str committed_storage_mb: The total size of the storage allocated to the VM in MB.
        :param int cpu_count: The number of cpus in the VM.
        :param str datacenter_description: The descriptive name of the vCenter's datacenter this VM is contained in.
        :param str datacenter_id: The id of the vCenter's datacenter this VM is contained in.
        :param int disk_count: The number of disks the VM has.
        :param str display_name: The display name of the VM. Note that this is not necessarily unique.
        :param str guest_description: The VM's OS. See for example https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html for types of strings this might hold.
        :param int memory_mb: The size of the memory of the VM in MB.
        :param str power_state: The power state of the VM at the moment list was taken.
        :param str uuid: The unique identifier of the VM in vCenter.
        :param str vm_id: The VM's id in the source (note that this is not the MigratingVm's id). This is the moref id of the VM.
        """
        pulumi.set(__self__, "boot_option", boot_option)
        pulumi.set(__self__, "committed_storage", committed_storage)
        pulumi.set(__self__, "committed_storage_mb", committed_storage_mb)
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "datacenter_description", datacenter_description)
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        pulumi.set(__self__, "disk_count", disk_count)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "guest_description", guest_description)
        pulumi.set(__self__, "memory_mb", memory_mb)
        pulumi.set(__self__, "power_state", power_state)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vm_id", vm_id)

    @property
    @pulumi.getter(name="bootOption")
    def boot_option(self) -> str:
        """
        The VM Boot Option.
        """
        return pulumi.get(self, "boot_option")

    @property
    @pulumi.getter(name="committedStorage")
    def committed_storage(self) -> str:
        """
        The total size of the storage allocated to the VM in MB.
        """
        return pulumi.get(self, "committed_storage")

    @property
    @pulumi.getter(name="committedStorageMb")
    def committed_storage_mb(self) -> str:
        """
        The total size of the storage allocated to the VM in MB.
        """
        return pulumi.get(self, "committed_storage_mb")

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> int:
        """
        The number of cpus in the VM.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="datacenterDescription")
    def datacenter_description(self) -> str:
        """
        The descriptive name of the vCenter's datacenter this VM is contained in.
        """
        return pulumi.get(self, "datacenter_description")

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> str:
        """
        The id of the vCenter's datacenter this VM is contained in.
        """
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> int:
        """
        The number of disks the VM has.
        """
        return pulumi.get(self, "disk_count")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the VM. Note that this is not necessarily unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="guestDescription")
    def guest_description(self) -> str:
        """
        The VM's OS. See for example https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html for types of strings this might hold.
        """
        return pulumi.get(self, "guest_description")

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> int:
        """
        The size of the memory of the VM in MB.
        """
        return pulumi.get(self, "memory_mb")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> str:
        """
        The power state of the VM at the moment list was taken.
        """
        return pulumi.get(self, "power_state")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The unique identifier of the VM in vCenter.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> str:
        """
        The VM's id in the source (note that this is not the MigratingVm's id). This is the moref id of the VM.
        """
        return pulumi.get(self, "vm_id")


