# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetHistoryResult',
    'AwaitableGetHistoryResult',
    'get_history',
    'get_history_output',
]

@pulumi.output_type
class GetHistoryResult:
    def __init__(__self__, display_name=None, history_id=None, name=None, test_platform=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if history_id and not isinstance(history_id, str):
            raise TypeError("Expected argument 'history_id' to be a str")
        pulumi.set(__self__, "history_id", history_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if test_platform and not isinstance(test_platform, str):
            raise TypeError("Expected argument 'test_platform' to be a str")
        pulumi.set(__self__, "test_platform", test_platform)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A short human-readable (plain text) name to display in the UI. Maximum of 100 characters. - In response: present if set during create. - In create request: optional
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="historyId")
    def history_id(self) -> str:
        """
        A unique identifier within a project for this History. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response always set - In create request: never set
        """
        return pulumi.get(self, "history_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name to uniquely identify a history within a project. Maximum of 200 characters. - In response always set - In create request: always set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="testPlatform")
    def test_platform(self) -> str:
        """
        The platform of the test history. - In response: always set. Returns the platform of the last execution if unknown.
        """
        return pulumi.get(self, "test_platform")


class AwaitableGetHistoryResult(GetHistoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHistoryResult(
            display_name=self.display_name,
            history_id=self.history_id,
            name=self.name,
            test_platform=self.test_platform)


def get_history(history_id: Optional[str] = None,
                project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHistoryResult:
    """
    Gets a History. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to read project - INVALID_ARGUMENT - if the request is malformed - NOT_FOUND - if the History does not exist
    """
    __args__ = dict()
    __args__['historyId'] = history_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:toolresults/v1beta3:getHistory', __args__, opts=opts, typ=GetHistoryResult).value

    return AwaitableGetHistoryResult(
        display_name=__ret__.display_name,
        history_id=__ret__.history_id,
        name=__ret__.name,
        test_platform=__ret__.test_platform)


@_utilities.lift_output_func(get_history)
def get_history_output(history_id: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHistoryResult]:
    """
    Gets a History. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to read project - INVALID_ARGUMENT - if the request is malformed - NOT_FOUND - if the History does not exist
    """
    ...
