# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['BackupRunArgs', 'BackupRun']

@pulumi.input_type
class BackupRunArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[str],
                 backup_kind: Optional[pulumi.Input['BackupRunBackupKind']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_configuration: Optional[pulumi.Input['DiskEncryptionConfigurationArgs']] = None,
                 disk_encryption_status: Optional[pulumi.Input['DiskEncryptionStatusArgs']] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 enqueued_time: Optional[pulumi.Input[str]] = None,
                 error: Optional[pulumi.Input['OperationErrorArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['BackupRunType']] = None,
                 window_start_time: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BackupRun resource.
        :param pulumi.Input[str] instance: Name of the database instance.
        :param pulumi.Input['BackupRunBackupKind'] backup_kind: Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
        :param pulumi.Input[str] description: The description of this run, only applicable to on-demand backups.
        :param pulumi.Input['DiskEncryptionConfigurationArgs'] disk_encryption_configuration: Encryption configuration specific to a backup.
        :param pulumi.Input['DiskEncryptionStatusArgs'] disk_encryption_status: Encryption status specific to a backup.
        :param pulumi.Input[str] end_time: The time the backup operation completed in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input[str] enqueued_time: The time the run was enqueued in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input['OperationErrorArgs'] error: Information about why the backup operation failed. This is only present if the run has the FAILED status.
        :param pulumi.Input[str] id: The identifier for this backup run. Unique only for a specific Cloud SQL instance.
        :param pulumi.Input[str] kind: This is always `sql#backupRun`.
        :param pulumi.Input[str] location: Location of the backups.
        :param pulumi.Input[str] self_link: The URI of this resource.
        :param pulumi.Input[str] start_time: The time the backup operation actually started in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input['BackupRunType'] type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
        :param pulumi.Input[str] window_start_time: The start time of the backup window during which this the backup was attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        pulumi.set(__self__, "instance", instance)
        if backup_kind is not None:
            pulumi.set(__self__, "backup_kind", backup_kind)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_configuration is not None:
            pulumi.set(__self__, "disk_encryption_configuration", disk_encryption_configuration)
        if disk_encryption_status is not None:
            pulumi.set(__self__, "disk_encryption_status", disk_encryption_status)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if enqueued_time is not None:
            pulumi.set(__self__, "enqueued_time", enqueued_time)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[str]:
        """
        Name of the database instance.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="backupKind")
    def backup_kind(self) -> Optional[pulumi.Input['BackupRunBackupKind']]:
        """
        Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
        """
        return pulumi.get(self, "backup_kind")

    @backup_kind.setter
    def backup_kind(self, value: Optional[pulumi.Input['BackupRunBackupKind']]):
        pulumi.set(self, "backup_kind", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of this run, only applicable to on-demand backups.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> Optional[pulumi.Input['DiskEncryptionConfigurationArgs']]:
        """
        Encryption configuration specific to a backup.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @disk_encryption_configuration.setter
    def disk_encryption_configuration(self, value: Optional[pulumi.Input['DiskEncryptionConfigurationArgs']]):
        pulumi.set(self, "disk_encryption_configuration", value)

    @property
    @pulumi.getter(name="diskEncryptionStatus")
    def disk_encryption_status(self) -> Optional[pulumi.Input['DiskEncryptionStatusArgs']]:
        """
        Encryption status specific to a backup.
        """
        return pulumi.get(self, "disk_encryption_status")

    @disk_encryption_status.setter
    def disk_encryption_status(self, value: Optional[pulumi.Input['DiskEncryptionStatusArgs']]):
        pulumi.set(self, "disk_encryption_status", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the backup operation completed in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="enqueuedTime")
    def enqueued_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the run was enqueued in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "enqueued_time")

    @enqueued_time.setter
    def enqueued_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enqueued_time", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input['OperationErrorArgs']]:
        """
        Information about why the backup operation failed. This is only present if the run has the FAILED status.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input['OperationErrorArgs']]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for this backup run. Unique only for a specific Cloud SQL instance.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always `sql#backupRun`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the backups.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the backup operation actually started in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['BackupRunType']]:
        """
        The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['BackupRunType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the backup window during which this the backup was attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_start_time", value)


class BackupRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_kind: Optional[pulumi.Input['BackupRunBackupKind']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']]] = None,
                 disk_encryption_status: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 enqueued_time: Optional[pulumi.Input[str]] = None,
                 error: Optional[pulumi.Input[pulumi.InputType['OperationErrorArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['BackupRunType']] = None,
                 window_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new backup run on demand.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['BackupRunBackupKind'] backup_kind: Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
        :param pulumi.Input[str] description: The description of this run, only applicable to on-demand backups.
        :param pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']] disk_encryption_configuration: Encryption configuration specific to a backup.
        :param pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']] disk_encryption_status: Encryption status specific to a backup.
        :param pulumi.Input[str] end_time: The time the backup operation completed in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input[str] enqueued_time: The time the run was enqueued in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input[pulumi.InputType['OperationErrorArgs']] error: Information about why the backup operation failed. This is only present if the run has the FAILED status.
        :param pulumi.Input[str] id: The identifier for this backup run. Unique only for a specific Cloud SQL instance.
        :param pulumi.Input[str] instance: Name of the database instance.
        :param pulumi.Input[str] kind: This is always `sql#backupRun`.
        :param pulumi.Input[str] location: Location of the backups.
        :param pulumi.Input[str] self_link: The URI of this resource.
        :param pulumi.Input[str] start_time: The time the backup operation actually started in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input['BackupRunType'] type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
        :param pulumi.Input[str] window_start_time: The start time of the backup window during which this the backup was attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new backup run on demand.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param BackupRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_kind: Optional[pulumi.Input['BackupRunBackupKind']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']]] = None,
                 disk_encryption_status: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 enqueued_time: Optional[pulumi.Input[str]] = None,
                 error: Optional[pulumi.Input[pulumi.InputType['OperationErrorArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['BackupRunType']] = None,
                 window_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupRunArgs.__new__(BackupRunArgs)

            __props__.__dict__["backup_kind"] = backup_kind
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_configuration"] = disk_encryption_configuration
            __props__.__dict__["disk_encryption_status"] = disk_encryption_status
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["enqueued_time"] = enqueued_time
            __props__.__dict__["error"] = error
            __props__.__dict__["id"] = id
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["self_link"] = self_link
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["type"] = type
            __props__.__dict__["window_start_time"] = window_start_time
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instance", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(BackupRun, __self__).__init__(
            'google-native:sqladmin/v1beta4:BackupRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BackupRun':
        """
        Get an existing BackupRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BackupRunArgs.__new__(BackupRunArgs)

        __props__.__dict__["backup_kind"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["disk_encryption_configuration"] = None
        __props__.__dict__["disk_encryption_status"] = None
        __props__.__dict__["end_time"] = None
        __props__.__dict__["enqueued_time"] = None
        __props__.__dict__["error"] = None
        __props__.__dict__["instance"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["start_time"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["window_start_time"] = None
        return BackupRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupKind")
    def backup_kind(self) -> pulumi.Output[str]:
        """
        Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
        """
        return pulumi.get(self, "backup_kind")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of this run, only applicable to on-demand backups.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> pulumi.Output['outputs.DiskEncryptionConfigurationResponse']:
        """
        Encryption configuration specific to a backup.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @property
    @pulumi.getter(name="diskEncryptionStatus")
    def disk_encryption_status(self) -> pulumi.Output['outputs.DiskEncryptionStatusResponse']:
        """
        Encryption status specific to a backup.
        """
        return pulumi.get(self, "disk_encryption_status")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        The time the backup operation completed in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="enqueuedTime")
    def enqueued_time(self) -> pulumi.Output[str]:
        """
        The time the run was enqueued in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "enqueued_time")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output['outputs.OperationErrorResponse']:
        """
        Information about why the backup operation failed. This is only present if the run has the FAILED status.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        This is always `sql#backupRun`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location of the backups.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        The time the backup operation actually started in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of this run.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> pulumi.Output[str]:
        """
        The start time of the backup window during which this the backup was attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "window_start_time")

