# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudRunV2BinaryAuthorizationResponse',
    'GoogleCloudRunV2CloudSqlInstanceResponse',
    'GoogleCloudRunV2ConditionResponse',
    'GoogleCloudRunV2ContainerPortResponse',
    'GoogleCloudRunV2ContainerResponse',
    'GoogleCloudRunV2EnvVarResponse',
    'GoogleCloudRunV2EnvVarSourceResponse',
    'GoogleCloudRunV2ExecutionReferenceResponse',
    'GoogleCloudRunV2ExecutionTemplateResponse',
    'GoogleCloudRunV2ResourceRequirementsResponse',
    'GoogleCloudRunV2RevisionScalingResponse',
    'GoogleCloudRunV2RevisionTemplateResponse',
    'GoogleCloudRunV2SecretKeySelectorResponse',
    'GoogleCloudRunV2SecretVolumeSourceResponse',
    'GoogleCloudRunV2TaskTemplateResponse',
    'GoogleCloudRunV2TrafficTargetResponse',
    'GoogleCloudRunV2TrafficTargetStatusResponse',
    'GoogleCloudRunV2VersionToPathResponse',
    'GoogleCloudRunV2VolumeMountResponse',
    'GoogleCloudRunV2VolumeResponse',
    'GoogleCloudRunV2VpcAccessResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'GoogleTypeExprResponse',
]

@pulumi.output_type
class GoogleCloudRunV2BinaryAuthorizationResponse(dict):
    """
    Settings for Binary Authorization feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2BinaryAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2BinaryAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2BinaryAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: str,
                 use_default: bool):
        """
        Settings for Binary Authorization feature.
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If use_default is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> str:
        """
        If present, indicates to use Breakglass using this justification. If use_default is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> bool:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class GoogleCloudRunV2CloudSqlInstanceResponse(dict):
    """
    Represents a specific Cloud SQL instance.
    """
    def __init__(__self__, *,
                 instances: Sequence[str]):
        """
        Represents a specific Cloud SQL instance.
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class GoogleCloudRunV2ConditionResponse(dict):
    """
    Defines a status condition for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2ConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2ConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2ConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: str,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 revision_reason: str,
                 severity: str,
                 state: str,
                 type: str):
        """
        Defines a status condition for a resource.
        :param str execution_reason: A reason for the execution condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
        :param str message: Human readable message indicating details about the current status.
        :param str reason: A common (service-level) reason for this condition.
        :param str revision_reason: A reason for the revision condition.
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: State of the condition.
        :param str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudRunV2ContainerPortResponse(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2ContainerPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2ContainerPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2ContainerPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: int,
                 name: str):
        """
        ContainerPort represents a network port in a single container.
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < container_port < 65536.
        :param str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < container_port < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleCloudRunV2ContainerResponse(dict):
    """
    A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 command: Sequence[str],
                 env: Sequence['outputs.GoogleCloudRunV2EnvVarResponse'],
                 image: str,
                 name: str,
                 ports: Sequence['outputs.GoogleCloudRunV2ContainerPortResponse'],
                 resources: 'outputs.GoogleCloudRunV2ResourceRequirementsResponse',
                 volume_mounts: Sequence['outputs.GoogleCloudRunV2VolumeMountResponse']):
        """
        A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[str] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['GoogleCloudRunV2EnvVarResponse'] env: List of environment variables to set in the container.
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param str name: Name of the container specified as a DNS_LABEL.
        :param Sequence['GoogleCloudRunV2ContainerPortResponse'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible. If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on.
        :param 'GoogleCloudRunV2ResourceRequirementsResponse' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param Sequence['GoogleCloudRunV2VolumeMountResponse'] volume_mounts: Volume to mount into the container's filesystem.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Sequence['outputs.GoogleCloudRunV2EnvVarResponse']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GoogleCloudRunV2ContainerPortResponse']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible. If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> 'outputs.GoogleCloudRunV2ResourceRequirementsResponse':
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GoogleCloudRunV2VolumeMountResponse']:
        """
        Volume to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GoogleCloudRunV2EnvVarResponse(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2EnvVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2EnvVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2EnvVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_source: 'outputs.GoogleCloudRunV2EnvVarSourceResponse'):
        """
        EnvVar represents an environment variable present in a Container.
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param str value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes.
        :param 'GoogleCloudRunV2EnvVarSourceResponse' value_source: Source for the environment variable's value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> 'outputs.GoogleCloudRunV2EnvVarSourceResponse':
        """
        Source for the environment variable's value.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GoogleCloudRunV2EnvVarSourceResponse(dict):
    """
    EnvVarSource represents a source for the value of an EnvVar.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2EnvVarSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2EnvVarSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2EnvVarSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: 'outputs.GoogleCloudRunV2SecretKeySelectorResponse'):
        """
        EnvVarSource represents a source for the value of an EnvVar.
        :param 'GoogleCloudRunV2SecretKeySelectorResponse' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
        """
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> 'outputs.GoogleCloudRunV2SecretKeySelectorResponse':
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GoogleCloudRunV2ExecutionReferenceResponse(dict):
    """
    Reference to an Execution. Use /Executions.GetExecution with the given name to get full execution including the latest status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2ExecutionReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2ExecutionReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2ExecutionReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time: str,
                 create_time: str,
                 name: str):
        """
        Reference to an Execution. Use /Executions.GetExecution with the given name to get full execution including the latest status.
        :param str completion_time: Creation timestamp of the execution.
        :param str create_time: Creation timestamp of the execution.
        :param str name: Name of the execution.
        """
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Creation timestamp of the execution.
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation timestamp of the execution.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the execution.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleCloudRunV2ExecutionTemplateResponse(dict):
    """
    ExecutionTemplate describes the data an execution should have when created from a template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2ExecutionTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2ExecutionTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2ExecutionTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 labels: Mapping[str, str],
                 parallelism: int,
                 task_count: int,
                 template: 'outputs.GoogleCloudRunV2TaskTemplateResponse'):
        """
        ExecutionTemplate describes the data an execution should have when created from a template.
        :param Mapping[str, str] annotations: KRM-style annotations for the resource.
        :param Mapping[str, str] labels: KRM-style labels for the resource.
        :param int parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= task_count. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param int task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param 'GoogleCloudRunV2TaskTemplateResponse' template: Describes the task(s) that will be created when executing an execution.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "task_count", task_count)
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        KRM-style annotations for the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        KRM-style labels for the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def parallelism(self) -> int:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= task_count. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> int:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.GoogleCloudRunV2TaskTemplateResponse':
        """
        Describes the task(s) that will be created when executing an execution.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class GoogleCloudRunV2ResourceRequirementsResponse(dict):
    """
    ResourceRequirements describes the compute resource requirements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuIdle":
            suggest = "cpu_idle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2ResourceRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2ResourceRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2ResourceRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_idle: bool,
                 limits: Mapping[str, str]):
        """
        ResourceRequirements describes the compute resource requirements.
        :param bool cpu_idle: Determines whether CPU should be throttled or not outside of requests.
        :param Mapping[str, str] limits: Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', and '4'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "cpu_idle", cpu_idle)
        pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> bool:
        """
        Determines whether CPU should be throttled or not outside of requests.
        """
        return pulumi.get(self, "cpu_idle")

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', and '4'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class GoogleCloudRunV2RevisionScalingResponse(dict):
    """
    Settings for revision-level scaling settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2RevisionScalingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2RevisionScalingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2RevisionScalingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: int,
                 min_instance_count: int):
        """
        Settings for revision-level scaling settings.
        :param int max_instance_count: Maximum number of serving instances that this resource should have.
        :param int min_instance_count: Minimum number of serving instances that this resource should have.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> int:
        """
        Maximum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> int:
        """
        Minimum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class GoogleCloudRunV2RevisionTemplateResponse(dict):
    """
    RevisionTemplate describes the data a revision should have when created from a template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxInstanceRequestConcurrency":
            suggest = "max_instance_request_concurrency"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2RevisionTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2RevisionTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2RevisionTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 containers: Sequence['outputs.GoogleCloudRunV2ContainerResponse'],
                 encryption_key: str,
                 execution_environment: str,
                 labels: Mapping[str, str],
                 max_instance_request_concurrency: int,
                 revision: str,
                 scaling: 'outputs.GoogleCloudRunV2RevisionScalingResponse',
                 service_account: str,
                 timeout: str,
                 volumes: Sequence['outputs.GoogleCloudRunV2VolumeResponse'],
                 vpc_access: 'outputs.GoogleCloudRunV2VpcAccessResponse'):
        """
        RevisionTemplate describes the data a revision should have when created from a template.
        :param Mapping[str, str] annotations: KRM-style annotations for the resource.
        :param Sequence['GoogleCloudRunV2ContainerResponse'] containers: Holds the single container that defines the unit of execution for this Revision.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The sandbox environment to host this Revision.
        :param Mapping[str, str] labels: KRM-style labels for the resource.
        :param int max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
        :param str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param 'GoogleCloudRunV2RevisionScalingResponse' scaling: Scaling settings for this Revision.
        :param str service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param str timeout: Max allowed time for an instance to respond to a request.
        :param Sequence['GoogleCloudRunV2VolumeResponse'] volumes: A list of Volumes to make available to containers.
        :param 'GoogleCloudRunV2VpcAccessResponse' vpc_access: VPC Access configuration to use for this Revision. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "execution_environment", execution_environment)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "scaling", scaling)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        KRM-style annotations for the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GoogleCloudRunV2ContainerResponse']:
        """
        Holds the single container that defines the unit of execution for this Revision.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> str:
        """
        The sandbox environment to host this Revision.
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        KRM-style labels for the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> int:
        """
        Sets the maximum number of requests that each serving instance can receive.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def scaling(self) -> 'outputs.GoogleCloudRunV2RevisionScalingResponse':
        """
        Scaling settings for this Revision.
        """
        return pulumi.get(self, "scaling")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Max allowed time for an instance to respond to a request.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GoogleCloudRunV2VolumeResponse']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> 'outputs.GoogleCloudRunV2VpcAccessResponse':
        """
        VPC Access configuration to use for this Revision. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class GoogleCloudRunV2SecretKeySelectorResponse(dict):
    """
    SecretEnvVarSource represents a source for the value of an EnvVar.
    """
    def __init__(__self__, *,
                 secret: str,
                 version: str):
        """
        SecretEnvVarSource represents a source for the value of an EnvVar.
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret_name} if the secret is in the same project. projects/{project}/secrets/{secret_name} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret_name} if the secret is in the same project. projects/{project}/secrets/{secret_name} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleCloudRunV2SecretVolumeSourceResponse(dict):
    """
    The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secret.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2SecretVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2SecretVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2SecretVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.GoogleCloudRunV2VersionToPathResponse'],
                 secret: str):
        """
        The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secret.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. This might be in conflict with other options that affect the file mode, like fsGroup, and as a result, other mode bits could be set.
        :param Sequence['GoogleCloudRunV2VersionToPathResponse'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. This might be in conflict with other options that affect the file mode, like fsGroup, and as a result, other mode bits could be set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GoogleCloudRunV2VersionToPathResponse']:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GoogleCloudRunV2TaskTemplateResponse(dict):
    """
    TaskTemplate describes the data a task should have when created from a template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2TaskTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2TaskTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2TaskTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Sequence['outputs.GoogleCloudRunV2ContainerResponse'],
                 encryption_key: str,
                 execution_environment: str,
                 max_retries: int,
                 service_account: str,
                 timeout: str,
                 volumes: Sequence['outputs.GoogleCloudRunV2VolumeResponse'],
                 vpc_access: 'outputs.GoogleCloudRunV2VpcAccessResponse'):
        """
        TaskTemplate describes the data a task should have when created from a template.
        :param Sequence['GoogleCloudRunV2ContainerResponse'] containers: Holds the single container that defines the unit of execution for this task.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The execution environment being used to host this Task.
        :param int max_retries: Number of retries allowed per Task, before marking this Task failed.
        :param str service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param str timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        :param Sequence['GoogleCloudRunV2VolumeResponse'] volumes: A list of Volumes to make available to containers.
        :param 'GoogleCloudRunV2VpcAccessResponse' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "execution_environment", execution_environment)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GoogleCloudRunV2ContainerResponse']:
        """
        Holds the single container that defines the unit of execution for this task.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> str:
        """
        The execution environment being used to host this Task.
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> int:
        """
        Number of retries allowed per Task, before marking this Task failed.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GoogleCloudRunV2VolumeResponse']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> 'outputs.GoogleCloudRunV2VpcAccessResponse':
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class GoogleCloudRunV2TrafficTargetResponse(dict):
    """
    Holds a single traffic routing entry for the Service. Allocations can be done to a specific Revision name, or pointing to the latest Ready Revision.
    """
    def __init__(__self__, *,
                 percent: int,
                 revision: str,
                 tag: str,
                 type: str):
        """
        Holds a single traffic routing entry for the Service. Allocations can be done to a specific Revision name, or pointing to the latest Ready Revision.
        :param int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param str revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target.
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudRunV2TrafficTargetStatusResponse(dict):
    """
    Represents the observed state of a single `TrafficTarget` entry.
    """
    def __init__(__self__, *,
                 percent: int,
                 revision: str,
                 tag: str,
                 type: str,
                 uri: str):
        """
        Represents the observed state of a single `TrafficTarget` entry.
        :param int percent: Specifies percent of the traffic to this Revision.
        :param str revision: Revision to which this traffic is sent.
        :param str tag: Indicates the string used in the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target.
        :param str uri: Displays the target URI.
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies percent of the traffic to this Revision.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        Revision to which this traffic is sent.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Indicates the string used in the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Displays the target URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudRunV2VersionToPathResponse(dict):
    """
    VersionToPath maps a specific version of a secret to a relative file to mount to, relative to VolumeMount's mount_path.
    """
    def __init__(__self__, *,
                 mode: int,
                 path: str,
                 version: str):
        """
        VersionToPath maps a specific version of a secret to a relative file to mount to, relative to VolumeMount's mount_path.
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param str path: The relative path of the secret in the container.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleCloudRunV2VolumeMountResponse(dict):
    """
    VolumeMount describes a mounting of a Volume within a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2VolumeMountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2VolumeMountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2VolumeMountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be `/cloudsql`. All instances defined in the Volume will be available as `/cloudsql/[instance]`. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be `/cloudsql`. All instances defined in the Volume will be available as `/cloudsql/[instance]`. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleCloudRunV2VolumeResponse(dict):
    """
    Volume represents a named volume in a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV2VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV2VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV2VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_instance: 'outputs.GoogleCloudRunV2CloudSqlInstanceResponse',
                 name: str,
                 secret: 'outputs.GoogleCloudRunV2SecretVolumeSourceResponse'):
        """
        Volume represents a named volume in a container.
        :param 'GoogleCloudRunV2CloudSqlInstanceResponse' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        :param str name: Volume's name.
        :param 'GoogleCloudRunV2SecretVolumeSourceResponse' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> 'outputs.GoogleCloudRunV2CloudSqlInstanceResponse':
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> 'outputs.GoogleCloudRunV2SecretVolumeSourceResponse':
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GoogleCloudRunV2VpcAccessResponse(dict):
    """
    VPC Access settings. For more information on creating a VPC Connector, visit https://cloud.google.com/vpc/docs/configure-serverless-vpc-access For information on how to configure Cloud Run with an existing VPC Connector, visit https://cloud.google.com/run/docs/configuring/connecting-vpc
    """
    def __init__(__self__, *,
                 connector: str,
                 egress: str):
        """
        VPC Access settings. For more information on creating a VPC Connector, visit https://cloud.google.com/vpc/docs/configure-serverless-vpc-access For information on how to configure Cloud Run with an existing VPC Connector, visit https://cloud.google.com/run/docs/configuring/connecting-vpc
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}
        :param str egress: Traffic VPC egress settings.
        """
        pulumi.set(__self__, "connector", connector)
        pulumi.set(__self__, "egress", egress)

    @property
    @pulumi.getter
    def connector(self) -> str:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> str:
        """
        Traffic VPC egress settings.
        """
        return pulumi.get(self, "egress")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GoogleTypeExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'GoogleTypeExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleTypeExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GoogleTypeExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


