# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ServingConfigArgs', 'ServingConfig']

@pulumi.input_type
class ServingConfigArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 serving_config_id: pulumi.Input[str],
                 solution_types: pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]],
                 boost_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 diversity_level: Optional[pulumi.Input[str]] = None,
                 do_not_associate_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dynamic_facet_spec: Optional[pulumi.Input['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs']] = None,
                 enable_category_filter_level: Optional[pulumi.Input[str]] = None,
                 facet_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oneway_synonyms_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 price_reranking_level: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 redirect_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 replacement_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 twoway_synonyms_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ServingConfig resource.
        :param pulumi.Input[str] display_name: The human readable serving config display name. Used in Retail UI. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[str] serving_config_id: Required. The ID to use for the ServingConfig, which will become the final component of the ServingConfig's resource name. This value should be 4-63 characters, and valid characters are /a-z-_/.
        :param pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]] solution_types: Immutable. Specifies the solution types that a serving config can be associated with. Currently we support setting only one type of solution.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] boost_control_ids: Condition boost specifications. If a product matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 100. Notice that if both ServingConfig.boost_control_ids and SearchRequest.boost_spec are set, the boost conditions from both places are evaluated. If a search request matches multiple boost conditions, the final boost score is equal to the sum of the boost scores from all matched boost conditions. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] diversity_level: How much diversity to use in recommendation model results e.g. 'medium-diversity' or 'high-diversity'. Currently supported values: * 'no-diversity' * 'low-diversity' * 'medium-diversity' * 'high-diversity' * 'auto-diversity' If not specified, we choose default based on recommendation model type. Default value: 'no-diversity'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] do_not_associate_control_ids: Condition do not associate specifications. If multiple do not associate conditions match, all matching do not associate controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs'] dynamic_facet_spec: The specification for dynamically generated facets. Notice that only textual facets can be dynamically generated. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] enable_category_filter_level: Whether to add additional category filters on the 'similar-items' model. If not specified, we enable it by default. Allowed values are: * 'no-category-match': No additional filtering of original results from the model and the customer's filters. * 'relaxed-category-match': Only keep results with categories that match at least one item categories in the PredictRequests's context item. * If customer also sends filters in the PredictRequest, then the results will satisfy both conditions (user given and category match). Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facet_control_ids: Facet specifications for faceted search. If empty, no facets are returned. The ids refer to the ids of Control resources with only the Facet control set. These controls are assumed to be in the same Catalog as the ServingConfig. A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error is returned. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_control_ids: Condition filter specifications. If a product matches multiple conditions in the specifications, filters from these specifications are all applied and combined via the AND operator. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_control_ids: Condition ignore specifications. If multiple ignore conditions match, all matching ignore controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] model_id: The id of the model to use at serving time. Currently only RecommendationModels are supported: https://cloud.google.com/retail/recommendations-ai/docs/create-models Can be changed but only to a compatible model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required when solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[str] name: Immutable. Fully qualified name `projects/*/locations/global/catalogs/*/servingConfig/*`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oneway_synonyms_control_ids: Condition oneway synonyms specifications. If multiple oneway synonyms conditions match, all matching oneway synonyms controls in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] price_reranking_level: How much price ranking we want in serving results. Price reranking causes product items with a similar recommendation probability to be ordered by price, with the highest-priced items first. This setting could result in a decrease in click-through and conversion rates. Allowed values are: * 'no-price-reranking' * 'low-price-raranking' * 'medium-price-reranking' * 'high-price-reranking' If not specified, we choose default based on model type. Default value: 'no-price-reranking'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_control_ids: Condition redirect specifications. Only the first triggered redirect action is applied, even if multiple apply. Maximum number of specifications is 1000. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replacement_control_ids: Condition replacement specifications. - Applied according to the order in the list. - A previously replaced term can not be re-replaced. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] twoway_synonyms_control_ids: Condition synonyms specifications. If multiple syonyms conditions match, all matching synonyms control in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "serving_config_id", serving_config_id)
        pulumi.set(__self__, "solution_types", solution_types)
        if boost_control_ids is not None:
            pulumi.set(__self__, "boost_control_ids", boost_control_ids)
        if diversity_level is not None:
            pulumi.set(__self__, "diversity_level", diversity_level)
        if do_not_associate_control_ids is not None:
            pulumi.set(__self__, "do_not_associate_control_ids", do_not_associate_control_ids)
        if dynamic_facet_spec is not None:
            pulumi.set(__self__, "dynamic_facet_spec", dynamic_facet_spec)
        if enable_category_filter_level is not None:
            pulumi.set(__self__, "enable_category_filter_level", enable_category_filter_level)
        if facet_control_ids is not None:
            pulumi.set(__self__, "facet_control_ids", facet_control_ids)
        if filter_control_ids is not None:
            pulumi.set(__self__, "filter_control_ids", filter_control_ids)
        if ignore_control_ids is not None:
            pulumi.set(__self__, "ignore_control_ids", ignore_control_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oneway_synonyms_control_ids is not None:
            pulumi.set(__self__, "oneway_synonyms_control_ids", oneway_synonyms_control_ids)
        if price_reranking_level is not None:
            pulumi.set(__self__, "price_reranking_level", price_reranking_level)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if redirect_control_ids is not None:
            pulumi.set(__self__, "redirect_control_ids", redirect_control_ids)
        if replacement_control_ids is not None:
            pulumi.set(__self__, "replacement_control_ids", replacement_control_ids)
        if twoway_synonyms_control_ids is not None:
            pulumi.set(__self__, "twoway_synonyms_control_ids", twoway_synonyms_control_ids)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human readable serving config display name. Used in Retail UI. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="servingConfigId")
    def serving_config_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the ServingConfig, which will become the final component of the ServingConfig's resource name. This value should be 4-63 characters, and valid characters are /a-z-_/.
        """
        return pulumi.get(self, "serving_config_id")

    @serving_config_id.setter
    def serving_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "serving_config_id", value)

    @property
    @pulumi.getter(name="solutionTypes")
    def solution_types(self) -> pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]]:
        """
        Immutable. Specifies the solution types that a serving config can be associated with. Currently we support setting only one type of solution.
        """
        return pulumi.get(self, "solution_types")

    @solution_types.setter
    def solution_types(self, value: pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]]):
        pulumi.set(self, "solution_types", value)

    @property
    @pulumi.getter(name="boostControlIds")
    def boost_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition boost specifications. If a product matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 100. Notice that if both ServingConfig.boost_control_ids and SearchRequest.boost_spec are set, the boost conditions from both places are evaluated. If a search request matches multiple boost conditions, the final boost score is equal to the sum of the boost scores from all matched boost conditions. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "boost_control_ids")

    @boost_control_ids.setter
    def boost_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "boost_control_ids", value)

    @property
    @pulumi.getter(name="diversityLevel")
    def diversity_level(self) -> Optional[pulumi.Input[str]]:
        """
        How much diversity to use in recommendation model results e.g. 'medium-diversity' or 'high-diversity'. Currently supported values: * 'no-diversity' * 'low-diversity' * 'medium-diversity' * 'high-diversity' * 'auto-diversity' If not specified, we choose default based on recommendation model type. Default value: 'no-diversity'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "diversity_level")

    @diversity_level.setter
    def diversity_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "diversity_level", value)

    @property
    @pulumi.getter(name="doNotAssociateControlIds")
    def do_not_associate_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition do not associate specifications. If multiple do not associate conditions match, all matching do not associate controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "do_not_associate_control_ids")

    @do_not_associate_control_ids.setter
    def do_not_associate_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "do_not_associate_control_ids", value)

    @property
    @pulumi.getter(name="dynamicFacetSpec")
    def dynamic_facet_spec(self) -> Optional[pulumi.Input['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs']]:
        """
        The specification for dynamically generated facets. Notice that only textual facets can be dynamically generated. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "dynamic_facet_spec")

    @dynamic_facet_spec.setter
    def dynamic_facet_spec(self, value: Optional[pulumi.Input['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs']]):
        pulumi.set(self, "dynamic_facet_spec", value)

    @property
    @pulumi.getter(name="enableCategoryFilterLevel")
    def enable_category_filter_level(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to add additional category filters on the 'similar-items' model. If not specified, we enable it by default. Allowed values are: * 'no-category-match': No additional filtering of original results from the model and the customer's filters. * 'relaxed-category-match': Only keep results with categories that match at least one item categories in the PredictRequests's context item. * If customer also sends filters in the PredictRequest, then the results will satisfy both conditions (user given and category match). Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "enable_category_filter_level")

    @enable_category_filter_level.setter
    def enable_category_filter_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_category_filter_level", value)

    @property
    @pulumi.getter(name="facetControlIds")
    def facet_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Facet specifications for faceted search. If empty, no facets are returned. The ids refer to the ids of Control resources with only the Facet control set. These controls are assumed to be in the same Catalog as the ServingConfig. A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error is returned. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "facet_control_ids")

    @facet_control_ids.setter
    def facet_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "facet_control_ids", value)

    @property
    @pulumi.getter(name="filterControlIds")
    def filter_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition filter specifications. If a product matches multiple conditions in the specifications, filters from these specifications are all applied and combined via the AND operator. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "filter_control_ids")

    @filter_control_ids.setter
    def filter_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "filter_control_ids", value)

    @property
    @pulumi.getter(name="ignoreControlIds")
    def ignore_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition ignore specifications. If multiple ignore conditions match, all matching ignore controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "ignore_control_ids")

    @ignore_control_ids.setter
    def ignore_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ignore_control_ids", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the model to use at serving time. Currently only RecommendationModels are supported: https://cloud.google.com/retail/recommendations-ai/docs/create-models Can be changed but only to a compatible model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required when solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Fully qualified name `projects/*/locations/global/catalogs/*/servingConfig/*`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onewaySynonymsControlIds")
    def oneway_synonyms_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition oneway synonyms specifications. If multiple oneway synonyms conditions match, all matching oneway synonyms controls in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "oneway_synonyms_control_ids")

    @oneway_synonyms_control_ids.setter
    def oneway_synonyms_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oneway_synonyms_control_ids", value)

    @property
    @pulumi.getter(name="priceRerankingLevel")
    def price_reranking_level(self) -> Optional[pulumi.Input[str]]:
        """
        How much price ranking we want in serving results. Price reranking causes product items with a similar recommendation probability to be ordered by price, with the highest-priced items first. This setting could result in a decrease in click-through and conversion rates. Allowed values are: * 'no-price-reranking' * 'low-price-raranking' * 'medium-price-reranking' * 'high-price-reranking' If not specified, we choose default based on model type. Default value: 'no-price-reranking'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "price_reranking_level")

    @price_reranking_level.setter
    def price_reranking_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "price_reranking_level", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="redirectControlIds")
    def redirect_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition redirect specifications. Only the first triggered redirect action is applied, even if multiple apply. Maximum number of specifications is 1000. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "redirect_control_ids")

    @redirect_control_ids.setter
    def redirect_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "redirect_control_ids", value)

    @property
    @pulumi.getter(name="replacementControlIds")
    def replacement_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition replacement specifications. - Applied according to the order in the list. - A previously replaced term can not be re-replaced. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "replacement_control_ids")

    @replacement_control_ids.setter
    def replacement_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "replacement_control_ids", value)

    @property
    @pulumi.getter(name="twowaySynonymsControlIds")
    def twoway_synonyms_control_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Condition synonyms specifications. If multiple syonyms conditions match, all matching synonyms control in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "twoway_synonyms_control_ids")

    @twoway_synonyms_control_ids.setter
    def twoway_synonyms_control_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "twoway_synonyms_control_ids", value)


class ServingConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boost_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 diversity_level: Optional[pulumi.Input[str]] = None,
                 do_not_associate_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dynamic_facet_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs']]] = None,
                 enable_category_filter_level: Optional[pulumi.Input[str]] = None,
                 facet_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oneway_synonyms_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 price_reranking_level: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 redirect_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 replacement_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serving_config_id: Optional[pulumi.Input[str]] = None,
                 solution_types: Optional[pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]]] = None,
                 twoway_synonyms_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates a ServingConfig. A maximum of 100 ServingConfigs are allowed in a Catalog, otherwise a FAILED_PRECONDITION error is returned.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] boost_control_ids: Condition boost specifications. If a product matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 100. Notice that if both ServingConfig.boost_control_ids and SearchRequest.boost_spec are set, the boost conditions from both places are evaluated. If a search request matches multiple boost conditions, the final boost score is equal to the sum of the boost scores from all matched boost conditions. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] display_name: The human readable serving config display name. Used in Retail UI. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[str] diversity_level: How much diversity to use in recommendation model results e.g. 'medium-diversity' or 'high-diversity'. Currently supported values: * 'no-diversity' * 'low-diversity' * 'medium-diversity' * 'high-diversity' * 'auto-diversity' If not specified, we choose default based on recommendation model type. Default value: 'no-diversity'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] do_not_associate_control_ids: Condition do not associate specifications. If multiple do not associate conditions match, all matching do not associate controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[pulumi.InputType['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs']] dynamic_facet_spec: The specification for dynamically generated facets. Notice that only textual facets can be dynamically generated. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] enable_category_filter_level: Whether to add additional category filters on the 'similar-items' model. If not specified, we enable it by default. Allowed values are: * 'no-category-match': No additional filtering of original results from the model and the customer's filters. * 'relaxed-category-match': Only keep results with categories that match at least one item categories in the PredictRequests's context item. * If customer also sends filters in the PredictRequest, then the results will satisfy both conditions (user given and category match). Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] facet_control_ids: Facet specifications for faceted search. If empty, no facets are returned. The ids refer to the ids of Control resources with only the Facet control set. These controls are assumed to be in the same Catalog as the ServingConfig. A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error is returned. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_control_ids: Condition filter specifications. If a product matches multiple conditions in the specifications, filters from these specifications are all applied and combined via the AND operator. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_control_ids: Condition ignore specifications. If multiple ignore conditions match, all matching ignore controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] model_id: The id of the model to use at serving time. Currently only RecommendationModels are supported: https://cloud.google.com/retail/recommendations-ai/docs/create-models Can be changed but only to a compatible model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required when solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[str] name: Immutable. Fully qualified name `projects/*/locations/global/catalogs/*/servingConfig/*`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oneway_synonyms_control_ids: Condition oneway synonyms specifications. If multiple oneway synonyms conditions match, all matching oneway synonyms controls in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] price_reranking_level: How much price ranking we want in serving results. Price reranking causes product items with a similar recommendation probability to be ordered by price, with the highest-priced items first. This setting could result in a decrease in click-through and conversion rates. Allowed values are: * 'no-price-reranking' * 'low-price-raranking' * 'medium-price-reranking' * 'high-price-reranking' If not specified, we choose default based on model type. Default value: 'no-price-reranking'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_control_ids: Condition redirect specifications. Only the first triggered redirect action is applied, even if multiple apply. Maximum number of specifications is 1000. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replacement_control_ids: Condition replacement specifications. - Applied according to the order in the list. - A previously replaced term can not be re-replaced. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        :param pulumi.Input[str] serving_config_id: Required. The ID to use for the ServingConfig, which will become the final component of the ServingConfig's resource name. This value should be 4-63 characters, and valid characters are /a-z-_/.
        :param pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]] solution_types: Immutable. Specifies the solution types that a serving config can be associated with. Currently we support setting only one type of solution.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] twoway_synonyms_control_ids: Condition synonyms specifications. If multiple syonyms conditions match, all matching synonyms control in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServingConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a ServingConfig. A maximum of 100 ServingConfigs are allowed in a Catalog, otherwise a FAILED_PRECONDITION error is returned.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ServingConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServingConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boost_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 diversity_level: Optional[pulumi.Input[str]] = None,
                 do_not_associate_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dynamic_facet_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecArgs']]] = None,
                 enable_category_filter_level: Optional[pulumi.Input[str]] = None,
                 facet_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oneway_synonyms_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 price_reranking_level: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 redirect_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 replacement_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serving_config_id: Optional[pulumi.Input[str]] = None,
                 solution_types: Optional[pulumi.Input[Sequence[pulumi.Input['ServingConfigSolutionTypesItem']]]] = None,
                 twoway_synonyms_control_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServingConfigArgs.__new__(ServingConfigArgs)

            __props__.__dict__["boost_control_ids"] = boost_control_ids
            if catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_id'")
            __props__.__dict__["catalog_id"] = catalog_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["diversity_level"] = diversity_level
            __props__.__dict__["do_not_associate_control_ids"] = do_not_associate_control_ids
            __props__.__dict__["dynamic_facet_spec"] = dynamic_facet_spec
            __props__.__dict__["enable_category_filter_level"] = enable_category_filter_level
            __props__.__dict__["facet_control_ids"] = facet_control_ids
            __props__.__dict__["filter_control_ids"] = filter_control_ids
            __props__.__dict__["ignore_control_ids"] = ignore_control_ids
            __props__.__dict__["location"] = location
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["name"] = name
            __props__.__dict__["oneway_synonyms_control_ids"] = oneway_synonyms_control_ids
            __props__.__dict__["price_reranking_level"] = price_reranking_level
            __props__.__dict__["project"] = project
            __props__.__dict__["redirect_control_ids"] = redirect_control_ids
            __props__.__dict__["replacement_control_ids"] = replacement_control_ids
            if serving_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'serving_config_id'")
            __props__.__dict__["serving_config_id"] = serving_config_id
            if solution_types is None and not opts.urn:
                raise TypeError("Missing required property 'solution_types'")
            __props__.__dict__["solution_types"] = solution_types
            __props__.__dict__["twoway_synonyms_control_ids"] = twoway_synonyms_control_ids
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["catalog_id", "location", "project", "serving_config_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ServingConfig, __self__).__init__(
            'google-native:retail/v2beta:ServingConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServingConfig':
        """
        Get an existing ServingConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServingConfigArgs.__new__(ServingConfigArgs)

        __props__.__dict__["boost_control_ids"] = None
        __props__.__dict__["catalog_id"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["diversity_level"] = None
        __props__.__dict__["do_not_associate_control_ids"] = None
        __props__.__dict__["dynamic_facet_spec"] = None
        __props__.__dict__["enable_category_filter_level"] = None
        __props__.__dict__["facet_control_ids"] = None
        __props__.__dict__["filter_control_ids"] = None
        __props__.__dict__["ignore_control_ids"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["model_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["oneway_synonyms_control_ids"] = None
        __props__.__dict__["price_reranking_level"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["redirect_control_ids"] = None
        __props__.__dict__["replacement_control_ids"] = None
        __props__.__dict__["serving_config_id"] = None
        __props__.__dict__["solution_types"] = None
        __props__.__dict__["twoway_synonyms_control_ids"] = None
        return ServingConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="boostControlIds")
    def boost_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition boost specifications. If a product matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 100. Notice that if both ServingConfig.boost_control_ids and SearchRequest.boost_spec are set, the boost conditions from both places are evaluated. If a search request matches multiple boost conditions, the final boost score is equal to the sum of the boost scores from all matched boost conditions. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "boost_control_ids")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The human readable serving config display name. Used in Retail UI. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="diversityLevel")
    def diversity_level(self) -> pulumi.Output[str]:
        """
        How much diversity to use in recommendation model results e.g. 'medium-diversity' or 'high-diversity'. Currently supported values: * 'no-diversity' * 'low-diversity' * 'medium-diversity' * 'high-diversity' * 'auto-diversity' If not specified, we choose default based on recommendation model type. Default value: 'no-diversity'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "diversity_level")

    @property
    @pulumi.getter(name="doNotAssociateControlIds")
    def do_not_associate_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition do not associate specifications. If multiple do not associate conditions match, all matching do not associate controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "do_not_associate_control_ids")

    @property
    @pulumi.getter(name="dynamicFacetSpec")
    def dynamic_facet_spec(self) -> pulumi.Output['outputs.GoogleCloudRetailV2betaSearchRequestDynamicFacetSpecResponse']:
        """
        The specification for dynamically generated facets. Notice that only textual facets can be dynamically generated. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "dynamic_facet_spec")

    @property
    @pulumi.getter(name="enableCategoryFilterLevel")
    def enable_category_filter_level(self) -> pulumi.Output[str]:
        """
        Whether to add additional category filters on the 'similar-items' model. If not specified, we enable it by default. Allowed values are: * 'no-category-match': No additional filtering of original results from the model and the customer's filters. * 'relaxed-category-match': Only keep results with categories that match at least one item categories in the PredictRequests's context item. * If customer also sends filters in the PredictRequest, then the results will satisfy both conditions (user given and category match). Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "enable_category_filter_level")

    @property
    @pulumi.getter(name="facetControlIds")
    def facet_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Facet specifications for faceted search. If empty, no facets are returned. The ids refer to the ids of Control resources with only the Facet control set. These controls are assumed to be in the same Catalog as the ServingConfig. A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error is returned. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "facet_control_ids")

    @property
    @pulumi.getter(name="filterControlIds")
    def filter_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition filter specifications. If a product matches multiple conditions in the specifications, filters from these specifications are all applied and combined via the AND operator. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "filter_control_ids")

    @property
    @pulumi.getter(name="ignoreControlIds")
    def ignore_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition ignore specifications. If multiple ignore conditions match, all matching ignore controls in the list will execute. - Order does not matter. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "ignore_control_ids")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[str]:
        """
        The id of the model to use at serving time. Currently only RecommendationModels are supported: https://cloud.google.com/retail/recommendations-ai/docs/create-models Can be changed but only to a compatible model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required when solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. Fully qualified name `projects/*/locations/global/catalogs/*/servingConfig/*`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onewaySynonymsControlIds")
    def oneway_synonyms_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition oneway synonyms specifications. If multiple oneway synonyms conditions match, all matching oneway synonyms controls in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "oneway_synonyms_control_ids")

    @property
    @pulumi.getter(name="priceRerankingLevel")
    def price_reranking_level(self) -> pulumi.Output[str]:
        """
        How much price ranking we want in serving results. Price reranking causes product items with a similar recommendation probability to be ordered by price, with the highest-priced items first. This setting could result in a decrease in click-through and conversion rates. Allowed values are: * 'no-price-reranking' * 'low-price-raranking' * 'medium-price-reranking' * 'high-price-reranking' If not specified, we choose default based on model type. Default value: 'no-price-reranking'. Can only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
        """
        return pulumi.get(self, "price_reranking_level")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="redirectControlIds")
    def redirect_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition redirect specifications. Only the first triggered redirect action is applied, even if multiple apply. Maximum number of specifications is 1000. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "redirect_control_ids")

    @property
    @pulumi.getter(name="replacementControlIds")
    def replacement_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition replacement specifications. - Applied according to the order in the list. - A previously replaced term can not be re-replaced. - Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "replacement_control_ids")

    @property
    @pulumi.getter(name="servingConfigId")
    def serving_config_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the ServingConfig, which will become the final component of the ServingConfig's resource name. This value should be 4-63 characters, and valid characters are /a-z-_/.
        """
        return pulumi.get(self, "serving_config_id")

    @property
    @pulumi.getter(name="solutionTypes")
    def solution_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Immutable. Specifies the solution types that a serving config can be associated with. Currently we support setting only one type of solution.
        """
        return pulumi.get(self, "solution_types")

    @property
    @pulumi.getter(name="twowaySynonymsControlIds")
    def twoway_synonyms_control_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Condition synonyms specifications. If multiple syonyms conditions match, all matching synonyms control in the list will execute. Order of controls in the list will not matter. Maximum number of specifications is 100. Can only be set if solution_types is SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "twoway_synonyms_control_ids")

