# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetReservationResult',
    'AwaitableGetReservationResult',
    'get_reservation',
    'get_reservation_output',
]

@pulumi.output_type
class GetReservationResult:
    def __init__(__self__, name=None, throughput_capacity=None):
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if throughput_capacity and not isinstance(throughput_capacity, str):
            raise TypeError("Expected argument 'throughput_capacity' to be a str")
        pulumi.set(__self__, "throughput_capacity", throughput_capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the reservation. Structured like: projects/{project_number}/locations/{location}/reservations/{reservation_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> str:
        """
        The reserved throughput capacity. Every unit of throughput capacity is equivalent to 1 MiB/s of published messages or 2 MiB/s of subscribed messages. Any topics which are declared as using capacity from a Reservation will consume resources from this reservation instead of being charged individually.
        """
        return pulumi.get(self, "throughput_capacity")


class AwaitableGetReservationResult(GetReservationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReservationResult(
            name=self.name,
            throughput_capacity=self.throughput_capacity)


def get_reservation(location: Optional[str] = None,
                    project: Optional[str] = None,
                    reservation_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReservationResult:
    """
    Returns the reservation configuration.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['reservationId'] = reservation_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:pubsublite/v1:getReservation', __args__, opts=opts, typ=GetReservationResult).value

    return AwaitableGetReservationResult(
        name=__ret__.name,
        throughput_capacity=__ret__.throughput_capacity)


@_utilities.lift_output_func(get_reservation)
def get_reservation_output(location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           reservation_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReservationResult]:
    """
    Returns the reservation configuration.
    """
    ...
