# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    def __init__(__self__, ack_deadline_seconds=None, name=None, push_config=None, topic=None):
        if ack_deadline_seconds and not isinstance(ack_deadline_seconds, int):
            raise TypeError("Expected argument 'ack_deadline_seconds' to be a int")
        pulumi.set(__self__, "ack_deadline_seconds", ack_deadline_seconds)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if push_config and not isinstance(push_config, dict):
            raise TypeError("Expected argument 'push_config' to be a dict")
        pulumi.set(__self__, "push_config", push_config)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> int:
        """
        For either push or pull delivery, the value is the maximum time after a subscriber receives a message before the subscriber should acknowledge or Nack the message. If the Ack deadline for a message passes without an Ack or a Nack, the Pub/Sub system will eventually redeliver the message. If a subscriber acknowledges after the deadline, the Pub/Sub system may accept the Ack, but it is possible that the message has been already delivered again. Multiple Acks to the message are allowed and will succeed. For push delivery, this value is used to set the request timeout for the call to the push endpoint. For pull delivery, this value is used as the initial value for the Ack deadline. It may be overridden for each message using its corresponding ack_id with ModifyAckDeadline. While a message is outstanding (i.e. it has been delivered to a pull subscriber and the subscriber has not yet Acked or Nacked), the Pub/Sub system will not deliver that message to another pull subscriber (on a best-effort basis).
        """
        return pulumi.get(self, "ack_deadline_seconds")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the subscription.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushConfig")
    def push_config(self) -> 'outputs.PushConfigResponse':
        """
        If push delivery is used with this subscription, this field is used to configure it.
        """
        return pulumi.get(self, "push_config")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the topic from which this subscription is receiving messages.
        """
        return pulumi.get(self, "topic")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            ack_deadline_seconds=self.ack_deadline_seconds,
            name=self.name,
            push_config=self.push_config,
            topic=self.topic)


def get_subscription(subscription_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Gets the configuration details of a subscription.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:pubsub/v1beta1a:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        ack_deadline_seconds=__ret__.ack_deadline_seconds,
        name=__ret__.name,
        push_config=__ret__.push_config,
        topic=__ret__.topic)


@_utilities.lift_output_func(get_subscription)
def get_subscription_output(subscription_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Gets the configuration details of a subscription.
    """
    ...
