# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCertificateAuthorityResult',
    'AwaitableGetCertificateAuthorityResult',
    'get_certificate_authority',
    'get_certificate_authority_output',
]

@pulumi.output_type
class GetCertificateAuthorityResult:
    def __init__(__self__, access_urls=None, ca_certificate_descriptions=None, certificate_policy=None, config=None, create_time=None, delete_time=None, gcs_bucket=None, issuing_options=None, key_spec=None, labels=None, lifetime=None, name=None, pem_ca_certificates=None, state=None, subordinate_config=None, tier=None, type=None, update_time=None):
        if access_urls and not isinstance(access_urls, dict):
            raise TypeError("Expected argument 'access_urls' to be a dict")
        pulumi.set(__self__, "access_urls", access_urls)
        if ca_certificate_descriptions and not isinstance(ca_certificate_descriptions, list):
            raise TypeError("Expected argument 'ca_certificate_descriptions' to be a list")
        pulumi.set(__self__, "ca_certificate_descriptions", ca_certificate_descriptions)
        if certificate_policy and not isinstance(certificate_policy, dict):
            raise TypeError("Expected argument 'certificate_policy' to be a dict")
        pulumi.set(__self__, "certificate_policy", certificate_policy)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if gcs_bucket and not isinstance(gcs_bucket, str):
            raise TypeError("Expected argument 'gcs_bucket' to be a str")
        pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if issuing_options and not isinstance(issuing_options, dict):
            raise TypeError("Expected argument 'issuing_options' to be a dict")
        pulumi.set(__self__, "issuing_options", issuing_options)
        if key_spec and not isinstance(key_spec, dict):
            raise TypeError("Expected argument 'key_spec' to be a dict")
        pulumi.set(__self__, "key_spec", key_spec)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if lifetime and not isinstance(lifetime, str):
            raise TypeError("Expected argument 'lifetime' to be a str")
        pulumi.set(__self__, "lifetime", lifetime)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pem_ca_certificates and not isinstance(pem_ca_certificates, list):
            raise TypeError("Expected argument 'pem_ca_certificates' to be a list")
        pulumi.set(__self__, "pem_ca_certificates", pem_ca_certificates)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subordinate_config and not isinstance(subordinate_config, dict):
            raise TypeError("Expected argument 'subordinate_config' to be a dict")
        pulumi.set(__self__, "subordinate_config", subordinate_config)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accessUrls")
    def access_urls(self) -> 'outputs.AccessUrlsResponse':
        """
        URLs for accessing content published by this CA, such as the CA certificate and CRLs.
        """
        return pulumi.get(self, "access_urls")

    @property
    @pulumi.getter(name="caCertificateDescriptions")
    def ca_certificate_descriptions(self) -> Sequence['outputs.CertificateDescriptionResponse']:
        """
        A structured description of this CertificateAuthority's CA certificate and its issuers. Ordered as self-to-root.
        """
        return pulumi.get(self, "ca_certificate_descriptions")

    @property
    @pulumi.getter(name="certificatePolicy")
    def certificate_policy(self) -> 'outputs.CertificateAuthorityPolicyResponse':
        """
        Optional. The CertificateAuthorityPolicy to enforce when issuing Certificates from this CertificateAuthority.
        """
        return pulumi.get(self, "certificate_policy")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.CertificateConfigResponse':
        """
        Immutable. The config used to create a self-signed X.509 certificate or CSR.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which this CertificateAuthority was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        The time at which this CertificateAuthority will be deleted, if scheduled for deletion.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> str:
        """
        Immutable. The name of a Cloud Storage bucket where this CertificateAuthority will publish content, such as the CA certificate and CRLs. This must be a bucket name, without any prefixes (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named `my-bucket`, you would simply specify `my-bucket`. If not specified, a managed bucket will be created.
        """
        return pulumi.get(self, "gcs_bucket")

    @property
    @pulumi.getter(name="issuingOptions")
    def issuing_options(self) -> 'outputs.IssuingOptionsResponse':
        """
        Optional. The IssuingOptions to follow when issuing Certificates from this CertificateAuthority.
        """
        return pulumi.get(self, "issuing_options")

    @property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> 'outputs.KeyVersionSpecResponse':
        """
        Immutable. Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA certificate. Otherwise, it is used to sign a CSR.
        """
        return pulumi.get(self, "key_spec")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Labels with user-defined metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> str:
        """
        The desired lifetime of the CA certificate. Used to create the "not_before_time" and "not_after_time" fields inside an X.509 certificate.
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for this CertificateAuthority in the format `projects/*/locations/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCaCertificates")
    def pem_ca_certificates(self) -> Sequence[str]:
        """
        This CertificateAuthority's certificate chain, including the current CertificateAuthority's certificate. Ordered such that the root issuer is the final element (consistent with RFC 5246). For a self-signed CA, this will only list the current CertificateAuthority's certificate.
        """
        return pulumi.get(self, "pem_ca_certificates")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The State for this CertificateAuthority.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subordinateConfig")
    def subordinate_config(self) -> 'outputs.SubordinateConfigResponse':
        """
        Optional. If this is a subordinate CertificateAuthority, this field will be set with the subordinate configuration, which describes its issuers. This may be updated, but this CertificateAuthority must continue to validate.
        """
        return pulumi.get(self, "subordinate_config")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Immutable. The Tier of this CertificateAuthority.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. The Type of this CertificateAuthority.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time at which this CertificateAuthority was updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetCertificateAuthorityResult(GetCertificateAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthorityResult(
            access_urls=self.access_urls,
            ca_certificate_descriptions=self.ca_certificate_descriptions,
            certificate_policy=self.certificate_policy,
            config=self.config,
            create_time=self.create_time,
            delete_time=self.delete_time,
            gcs_bucket=self.gcs_bucket,
            issuing_options=self.issuing_options,
            key_spec=self.key_spec,
            labels=self.labels,
            lifetime=self.lifetime,
            name=self.name,
            pem_ca_certificates=self.pem_ca_certificates,
            state=self.state,
            subordinate_config=self.subordinate_config,
            tier=self.tier,
            type=self.type,
            update_time=self.update_time)


def get_certificate_authority(certificate_authority_id: Optional[str] = None,
                              location: Optional[str] = None,
                              project: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthorityResult:
    """
    Returns a CertificateAuthority.
    """
    __args__ = dict()
    __args__['certificateAuthorityId'] = certificate_authority_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:privateca/v1beta1:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult).value

    return AwaitableGetCertificateAuthorityResult(
        access_urls=__ret__.access_urls,
        ca_certificate_descriptions=__ret__.ca_certificate_descriptions,
        certificate_policy=__ret__.certificate_policy,
        config=__ret__.config,
        create_time=__ret__.create_time,
        delete_time=__ret__.delete_time,
        gcs_bucket=__ret__.gcs_bucket,
        issuing_options=__ret__.issuing_options,
        key_spec=__ret__.key_spec,
        labels=__ret__.labels,
        lifetime=__ret__.lifetime,
        name=__ret__.name,
        pem_ca_certificates=__ret__.pem_ca_certificates,
        state=__ret__.state,
        subordinate_config=__ret__.subordinate_config,
        tier=__ret__.tier,
        type=__ret__.type,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_certificate_authority)
def get_certificate_authority_output(certificate_authority_id: Optional[pulumi.Input[str]] = None,
                                     location: Optional[pulumi.Input[str]] = None,
                                     project: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateAuthorityResult]:
    """
    Returns a CertificateAuthority.
    """
    ...
