# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['CaPoolArgs', 'CaPool']

@pulumi.input_type
class CaPoolArgs:
    def __init__(__self__, *,
                 ca_pool_id: pulumi.Input[str],
                 tier: pulumi.Input['CaPoolTier'],
                 issuance_policy: Optional[pulumi.Input['IssuancePolicyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publishing_options: Optional[pulumi.Input['PublishingOptionsArgs']] = None,
                 request_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CaPool resource.
        :param pulumi.Input[str] ca_pool_id: Required. It must be unique within a location and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        :param pulumi.Input['CaPoolTier'] tier: Immutable. The Tier of this CaPool.
        :param pulumi.Input['IssuancePolicyArgs'] issuance_policy: Optional. The IssuancePolicy to control how Certificates will be issued from this CaPool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels with user-defined metadata.
        :param pulumi.Input['PublishingOptionsArgs'] publishing_options: Optional. The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        :param pulumi.Input[str] request_id: Optional. An ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        pulumi.set(__self__, "ca_pool_id", ca_pool_id)
        pulumi.set(__self__, "tier", tier)
        if issuance_policy is not None:
            pulumi.set(__self__, "issuance_policy", issuance_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publishing_options is not None:
            pulumi.set(__self__, "publishing_options", publishing_options)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)

    @property
    @pulumi.getter(name="caPoolId")
    def ca_pool_id(self) -> pulumi.Input[str]:
        """
        Required. It must be unique within a location and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        """
        return pulumi.get(self, "ca_pool_id")

    @ca_pool_id.setter
    def ca_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ca_pool_id", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input['CaPoolTier']:
        """
        Immutable. The Tier of this CaPool.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input['CaPoolTier']):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="issuancePolicy")
    def issuance_policy(self) -> Optional[pulumi.Input['IssuancePolicyArgs']]:
        """
        Optional. The IssuancePolicy to control how Certificates will be issued from this CaPool.
        """
        return pulumi.get(self, "issuance_policy")

    @issuance_policy.setter
    def issuance_policy(self, value: Optional[pulumi.Input['IssuancePolicyArgs']]):
        pulumi.set(self, "issuance_policy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Labels with user-defined metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="publishingOptions")
    def publishing_options(self) -> Optional[pulumi.Input['PublishingOptionsArgs']]:
        """
        Optional. The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        """
        return pulumi.get(self, "publishing_options")

    @publishing_options.setter
    def publishing_options(self, value: Optional[pulumi.Input['PublishingOptionsArgs']]):
        pulumi.set(self, "publishing_options", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. An ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)


class CaPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_pool_id: Optional[pulumi.Input[str]] = None,
                 issuance_policy: Optional[pulumi.Input[pulumi.InputType['IssuancePolicyArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publishing_options: Optional[pulumi.Input[pulumi.InputType['PublishingOptionsArgs']]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['CaPoolTier']] = None,
                 __props__=None):
        """
        Create a CaPool.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_pool_id: Required. It must be unique within a location and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        :param pulumi.Input[pulumi.InputType['IssuancePolicyArgs']] issuance_policy: Optional. The IssuancePolicy to control how Certificates will be issued from this CaPool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels with user-defined metadata.
        :param pulumi.Input[pulumi.InputType['PublishingOptionsArgs']] publishing_options: Optional. The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        :param pulumi.Input[str] request_id: Optional. An ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input['CaPoolTier'] tier: Immutable. The Tier of this CaPool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CaPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CaPool.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param CaPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_pool_id: Optional[pulumi.Input[str]] = None,
                 issuance_policy: Optional[pulumi.Input[pulumi.InputType['IssuancePolicyArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publishing_options: Optional[pulumi.Input[pulumi.InputType['PublishingOptionsArgs']]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['CaPoolTier']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaPoolArgs.__new__(CaPoolArgs)

            if ca_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'ca_pool_id'")
            __props__.__dict__["ca_pool_id"] = ca_pool_id
            __props__.__dict__["issuance_policy"] = issuance_policy
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["publishing_options"] = publishing_options
            __props__.__dict__["request_id"] = request_id
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["name"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["ca_pool_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CaPool, __self__).__init__(
            'google-native:privateca/v1:CaPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CaPool':
        """
        Get an existing CaPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CaPoolArgs.__new__(CaPoolArgs)

        __props__.__dict__["ca_pool_id"] = None
        __props__.__dict__["issuance_policy"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["publishing_options"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["tier"] = None
        return CaPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caPoolId")
    def ca_pool_id(self) -> pulumi.Output[str]:
        """
        Required. It must be unique within a location and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        """
        return pulumi.get(self, "ca_pool_id")

    @property
    @pulumi.getter(name="issuancePolicy")
    def issuance_policy(self) -> pulumi.Output['outputs.IssuancePolicyResponse']:
        """
        Optional. The IssuancePolicy to control how Certificates will be issued from this CaPool.
        """
        return pulumi.get(self, "issuance_policy")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. Labels with user-defined metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name for this CaPool in the format `projects/*/locations/*/caPools/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="publishingOptions")
    def publishing_options(self) -> pulumi.Output['outputs.PublishingOptionsResponse']:
        """
        Optional. The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        """
        return pulumi.get(self, "publishing_options")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. An ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        Immutable. The Tier of this CaPool.
        """
        return pulumi.get(self, "tier")

