# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EndpointPolicyArgs', 'EndpointPolicy']

@pulumi.input_type
class EndpointPolicyArgs:
    def __init__(__self__, *,
                 endpoint_matcher: pulumi.Input['EndpointMatcherArgs'],
                 endpoint_policy_id: pulumi.Input[str],
                 type: pulumi.Input['EndpointPolicyType'],
                 authorization_policy: Optional[pulumi.Input[str]] = None,
                 client_tls_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server_tls_policy: Optional[pulumi.Input[str]] = None,
                 traffic_port_selector: Optional[pulumi.Input['TrafficPortSelectorArgs']] = None):
        """
        The set of arguments for constructing a EndpointPolicy resource.
        :param pulumi.Input['EndpointMatcherArgs'] endpoint_matcher: A matcher that selects endpoints to which the policies should be applied.
        :param pulumi.Input[str] endpoint_policy_id: Required. Short name of the EndpointPolicy resource to be created. E.g. "CustomECS".
        :param pulumi.Input['EndpointPolicyType'] type: The type of endpoint policy. This is primarily used to validate the configuration.
        :param pulumi.Input[str] authorization_policy: Optional. This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic at the matched endpoints. Refer to Authorization. If this field is not specified, authorization is disabled(no authz checks) for this endpoint.
        :param pulumi.Input[str] client_tls_policy: Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from the proxy to the actual endpoints. More specifically, it is applied to the outgoing traffic from the proxy to the endpoint. This is typically used for sidecar model where the proxy identifies itself as endpoint to the control plane, with the connection between sidecar and endpoint requiring authentication. If this field is not set, authentication is disabled(open). Applicable only when EndpointPolicyType is SIDECAR_PROXY.
        :param pulumi.Input[str] description: Optional. A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Set of label tags associated with the EndpointPolicy resource.
        :param pulumi.Input[str] name: Name of the EndpointPolicy resource. It matches pattern `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
        :param pulumi.Input[str] server_tls_policy: Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be applied to terminate the inbound traffic at the identified backends. If this field is not set, authentication is disabled(open) for this endpoint.
        :param pulumi.Input['TrafficPortSelectorArgs'] traffic_port_selector: Optional. Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        pulumi.set(__self__, "endpoint_matcher", endpoint_matcher)
        pulumi.set(__self__, "endpoint_policy_id", endpoint_policy_id)
        pulumi.set(__self__, "type", type)
        if authorization_policy is not None:
            pulumi.set(__self__, "authorization_policy", authorization_policy)
        if client_tls_policy is not None:
            pulumi.set(__self__, "client_tls_policy", client_tls_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if traffic_port_selector is not None:
            pulumi.set(__self__, "traffic_port_selector", traffic_port_selector)

    @property
    @pulumi.getter(name="endpointMatcher")
    def endpoint_matcher(self) -> pulumi.Input['EndpointMatcherArgs']:
        """
        A matcher that selects endpoints to which the policies should be applied.
        """
        return pulumi.get(self, "endpoint_matcher")

    @endpoint_matcher.setter
    def endpoint_matcher(self, value: pulumi.Input['EndpointMatcherArgs']):
        pulumi.set(self, "endpoint_matcher", value)

    @property
    @pulumi.getter(name="endpointPolicyId")
    def endpoint_policy_id(self) -> pulumi.Input[str]:
        """
        Required. Short name of the EndpointPolicy resource to be created. E.g. "CustomECS".
        """
        return pulumi.get(self, "endpoint_policy_id")

    @endpoint_policy_id.setter
    def endpoint_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_policy_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['EndpointPolicyType']:
        """
        The type of endpoint policy. This is primarily used to validate the configuration.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['EndpointPolicyType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authorizationPolicy")
    def authorization_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic at the matched endpoints. Refer to Authorization. If this field is not specified, authorization is disabled(no authz checks) for this endpoint.
        """
        return pulumi.get(self, "authorization_policy")

    @authorization_policy.setter
    def authorization_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_policy", value)

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from the proxy to the actual endpoints. More specifically, it is applied to the outgoing traffic from the proxy to the endpoint. This is typically used for sidecar model where the proxy identifies itself as endpoint to the control plane, with the connection between sidecar and endpoint requiring authentication. If this field is not set, authentication is disabled(open). Applicable only when EndpointPolicyType is SIDECAR_PROXY.
        """
        return pulumi.get(self, "client_tls_policy")

    @client_tls_policy.setter
    def client_tls_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_tls_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Set of label tags associated with the EndpointPolicy resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EndpointPolicy resource. It matches pattern `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be applied to terminate the inbound traffic at the identified backends. If this field is not set, authentication is disabled(open) for this endpoint.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter(name="trafficPortSelector")
    def traffic_port_selector(self) -> Optional[pulumi.Input['TrafficPortSelectorArgs']]:
        """
        Optional. Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        return pulumi.get(self, "traffic_port_selector")

    @traffic_port_selector.setter
    def traffic_port_selector(self, value: Optional[pulumi.Input['TrafficPortSelectorArgs']]):
        pulumi.set(self, "traffic_port_selector", value)


class EndpointPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_policy: Optional[pulumi.Input[str]] = None,
                 client_tls_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_matcher: Optional[pulumi.Input[pulumi.InputType['EndpointMatcherArgs']]] = None,
                 endpoint_policy_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server_tls_policy: Optional[pulumi.Input[str]] = None,
                 traffic_port_selector: Optional[pulumi.Input[pulumi.InputType['TrafficPortSelectorArgs']]] = None,
                 type: Optional[pulumi.Input['EndpointPolicyType']] = None,
                 __props__=None):
        """
        Creates a new EndpointPolicy in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_policy: Optional. This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic at the matched endpoints. Refer to Authorization. If this field is not specified, authorization is disabled(no authz checks) for this endpoint.
        :param pulumi.Input[str] client_tls_policy: Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from the proxy to the actual endpoints. More specifically, it is applied to the outgoing traffic from the proxy to the endpoint. This is typically used for sidecar model where the proxy identifies itself as endpoint to the control plane, with the connection between sidecar and endpoint requiring authentication. If this field is not set, authentication is disabled(open). Applicable only when EndpointPolicyType is SIDECAR_PROXY.
        :param pulumi.Input[str] description: Optional. A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[pulumi.InputType['EndpointMatcherArgs']] endpoint_matcher: A matcher that selects endpoints to which the policies should be applied.
        :param pulumi.Input[str] endpoint_policy_id: Required. Short name of the EndpointPolicy resource to be created. E.g. "CustomECS".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Set of label tags associated with the EndpointPolicy resource.
        :param pulumi.Input[str] name: Name of the EndpointPolicy resource. It matches pattern `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
        :param pulumi.Input[str] server_tls_policy: Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be applied to terminate the inbound traffic at the identified backends. If this field is not set, authentication is disabled(open) for this endpoint.
        :param pulumi.Input[pulumi.InputType['TrafficPortSelectorArgs']] traffic_port_selector: Optional. Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        :param pulumi.Input['EndpointPolicyType'] type: The type of endpoint policy. This is primarily used to validate the configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new EndpointPolicy in a given project and location.

        :param str resource_name: The name of the resource.
        :param EndpointPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_policy: Optional[pulumi.Input[str]] = None,
                 client_tls_policy: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_matcher: Optional[pulumi.Input[pulumi.InputType['EndpointMatcherArgs']]] = None,
                 endpoint_policy_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server_tls_policy: Optional[pulumi.Input[str]] = None,
                 traffic_port_selector: Optional[pulumi.Input[pulumi.InputType['TrafficPortSelectorArgs']]] = None,
                 type: Optional[pulumi.Input['EndpointPolicyType']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointPolicyArgs.__new__(EndpointPolicyArgs)

            __props__.__dict__["authorization_policy"] = authorization_policy
            __props__.__dict__["client_tls_policy"] = client_tls_policy
            __props__.__dict__["description"] = description
            if endpoint_matcher is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_matcher'")
            __props__.__dict__["endpoint_matcher"] = endpoint_matcher
            if endpoint_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_policy_id'")
            __props__.__dict__["endpoint_policy_id"] = endpoint_policy_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["server_tls_policy"] = server_tls_policy
            __props__.__dict__["traffic_port_selector"] = traffic_port_selector
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["endpoint_policy_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EndpointPolicy, __self__).__init__(
            'google-native:networkservices/v1beta1:EndpointPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EndpointPolicy':
        """
        Get an existing EndpointPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EndpointPolicyArgs.__new__(EndpointPolicyArgs)

        __props__.__dict__["authorization_policy"] = None
        __props__.__dict__["client_tls_policy"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["endpoint_matcher"] = None
        __props__.__dict__["endpoint_policy_id"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["server_tls_policy"] = None
        __props__.__dict__["traffic_port_selector"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["update_time"] = None
        return EndpointPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizationPolicy")
    def authorization_policy(self) -> pulumi.Output[str]:
        """
        Optional. This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic at the matched endpoints. Refer to Authorization. If this field is not specified, authorization is disabled(no authz checks) for this endpoint.
        """
        return pulumi.get(self, "authorization_policy")

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> pulumi.Output[str]:
        """
        Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from the proxy to the actual endpoints. More specifically, it is applied to the outgoing traffic from the proxy to the endpoint. This is typically used for sidecar model where the proxy identifies itself as endpoint to the control plane, with the connection between sidecar and endpoint requiring authentication. If this field is not set, authentication is disabled(open). Applicable only when EndpointPolicyType is SIDECAR_PROXY.
        """
        return pulumi.get(self, "client_tls_policy")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointMatcher")
    def endpoint_matcher(self) -> pulumi.Output['outputs.EndpointMatcherResponse']:
        """
        A matcher that selects endpoints to which the policies should be applied.
        """
        return pulumi.get(self, "endpoint_matcher")

    @property
    @pulumi.getter(name="endpointPolicyId")
    def endpoint_policy_id(self) -> pulumi.Output[str]:
        """
        Required. Short name of the EndpointPolicy resource to be created. E.g. "CustomECS".
        """
        return pulumi.get(self, "endpoint_policy_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. Set of label tags associated with the EndpointPolicy resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the EndpointPolicy resource. It matches pattern `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> pulumi.Output[str]:
        """
        Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be applied to terminate the inbound traffic at the identified backends. If this field is not set, authentication is disabled(open) for this endpoint.
        """
        return pulumi.get(self, "server_tls_policy")

    @property
    @pulumi.getter(name="trafficPortSelector")
    def traffic_port_selector(self) -> pulumi.Output['outputs.TrafficPortSelectorResponse']:
        """
        Optional. Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        return pulumi.get(self, "traffic_port_selector")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of endpoint policy. This is primarily used to validate the configuration.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

