# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetClientTlsPolicyResult',
    'AwaitableGetClientTlsPolicyResult',
    'get_client_tls_policy',
    'get_client_tls_policy_output',
]

@pulumi.output_type
class GetClientTlsPolicyResult:
    def __init__(__self__, client_certificate=None, create_time=None, description=None, labels=None, name=None, server_validation_ca=None, sni=None, update_time=None):
        if client_certificate and not isinstance(client_certificate, dict):
            raise TypeError("Expected argument 'client_certificate' to be a dict")
        pulumi.set(__self__, "client_certificate", client_certificate)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if server_validation_ca and not isinstance(server_validation_ca, list):
            raise TypeError("Expected argument 'server_validation_ca' to be a list")
        pulumi.set(__self__, "server_validation_ca", server_validation_ca)
        if sni and not isinstance(sni, str):
            raise TypeError("Expected argument 'sni' to be a str")
        pulumi.set(__self__, "sni", sni)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> 'outputs.GoogleCloudNetworksecurityV1CertificateProviderResponse':
        """
        Optional. Defines a mechanism to provision client identity (public and private keys) for peer to peer authentication. The presence of this dictates mTLS.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Set of label tags associated with the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the ClientTlsPolicy resource. It matches the pattern `projects/*/locations/{location}/clientTlsPolicies/{client_tls_policy}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverValidationCa")
    def server_validation_ca(self) -> Sequence['outputs.ValidationCAResponse']:
        """
        Optional. Defines the mechanism to obtain the Certificate Authority certificate to validate the server certificate. If empty, client does not validate the server certificate.
        """
        return pulumi.get(self, "server_validation_ca")

    @property
    @pulumi.getter
    def sni(self) -> str:
        """
        Optional. Server Name Indication string to present to the server during TLS handshake. E.g: "secure.example.com".
        """
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetClientTlsPolicyResult(GetClientTlsPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientTlsPolicyResult(
            client_certificate=self.client_certificate,
            create_time=self.create_time,
            description=self.description,
            labels=self.labels,
            name=self.name,
            server_validation_ca=self.server_validation_ca,
            sni=self.sni,
            update_time=self.update_time)


def get_client_tls_policy(client_tls_policy_id: Optional[str] = None,
                          location: Optional[str] = None,
                          project: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientTlsPolicyResult:
    """
    Gets details of a single ClientTlsPolicy.
    """
    __args__ = dict()
    __args__['clientTlsPolicyId'] = client_tls_policy_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:networksecurity/v1:getClientTlsPolicy', __args__, opts=opts, typ=GetClientTlsPolicyResult).value

    return AwaitableGetClientTlsPolicyResult(
        client_certificate=__ret__.client_certificate,
        create_time=__ret__.create_time,
        description=__ret__.description,
        labels=__ret__.labels,
        name=__ret__.name,
        server_validation_ca=__ret__.server_validation_ca,
        sni=__ret__.sni,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_client_tls_policy)
def get_client_tls_policy_output(client_tls_policy_id: Optional[pulumi.Input[str]] = None,
                                 location: Optional[pulumi.Input[str]] = None,
                                 project: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClientTlsPolicyResult]:
    """
    Gets details of a single ClientTlsPolicy.
    """
    ...
