# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpokeArgs', 'Spoke']

@pulumi.input_type
class SpokeArgs:
    def __init__(__self__, *,
                 spoke_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input['LinkedInterconnectAttachmentsArgs']] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input['LinkedRouterApplianceInstancesArgs']] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input['LinkedVpnTunnelsArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Spoke resource.
        :param pulumi.Input[str] spoke_id: Required. Unique id for the spoke to create.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[str] hub: Immutable. The name of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        :param pulumi.Input['LinkedInterconnectAttachmentsArgs'] linked_interconnect_attachments: VLAN attachments that are associated with the spoke.
        :param pulumi.Input['LinkedRouterApplianceInstancesArgs'] linked_router_appliance_instances: Router appliance instances that are associated with the spoke.
        :param pulumi.Input['LinkedVpnTunnelsArgs'] linked_vpn_tunnels: VPN tunnels that are associated with the spoke.
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique. They use the following form: `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
        :param pulumi.Input[str] request_id: Optional. A unique request ID (optional). If you specify this ID, you can use it in cases when you need to retry your request. When you need to retry, this ID lets the server know that it can ignore the request if it has already been completed. The server guarantees that for at least 60 minutes after the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check to see whether the original operation was received. If it was, the server ignores the second request. This behavior prevents clients from mistakenly creating duplicate commitments. The request ID must be a valid UUID, with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        pulumi.set(__self__, "spoke_id", spoke_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hub is not None:
            pulumi.set(__self__, "hub", hub)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_interconnect_attachments is not None:
            pulumi.set(__self__, "linked_interconnect_attachments", linked_interconnect_attachments)
        if linked_router_appliance_instances is not None:
            pulumi.set(__self__, "linked_router_appliance_instances", linked_router_appliance_instances)
        if linked_vpn_tunnels is not None:
            pulumi.set(__self__, "linked_vpn_tunnels", linked_vpn_tunnels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)

    @property
    @pulumi.getter(name="spokeId")
    def spoke_id(self) -> pulumi.Input[str]:
        """
        Required. Unique id for the spoke to create.
        """
        return pulumi.get(self, "spoke_id")

    @spoke_id.setter
    def spoke_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "spoke_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hub(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> Optional[pulumi.Input['LinkedInterconnectAttachmentsArgs']]:
        """
        VLAN attachments that are associated with the spoke.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @linked_interconnect_attachments.setter
    def linked_interconnect_attachments(self, value: Optional[pulumi.Input['LinkedInterconnectAttachmentsArgs']]):
        pulumi.set(self, "linked_interconnect_attachments", value)

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> Optional[pulumi.Input['LinkedRouterApplianceInstancesArgs']]:
        """
        Router appliance instances that are associated with the spoke.
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @linked_router_appliance_instances.setter
    def linked_router_appliance_instances(self, value: Optional[pulumi.Input['LinkedRouterApplianceInstancesArgs']]):
        pulumi.set(self, "linked_router_appliance_instances", value)

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> Optional[pulumi.Input['LinkedVpnTunnelsArgs']]:
        """
        VPN tunnels that are associated with the spoke.
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @linked_vpn_tunnels.setter
    def linked_vpn_tunnels(self, value: Optional[pulumi.Input['LinkedVpnTunnelsArgs']]):
        pulumi.set(self, "linked_vpn_tunnels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the spoke. Spoke names must be unique. They use the following form: `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A unique request ID (optional). If you specify this ID, you can use it in cases when you need to retry your request. When you need to retry, this ID lets the server know that it can ignore the request if it has already been completed. The server guarantees that for at least 60 minutes after the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check to see whether the original operation was received. If it was, the server ignores the second request. This behavior prevents clients from mistakenly creating duplicate commitments. The request ID must be a valid UUID, with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)


class Spoke(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[pulumi.InputType['LinkedInterconnectAttachmentsArgs']]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[pulumi.InputType['LinkedRouterApplianceInstancesArgs']]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[pulumi.InputType['LinkedVpnTunnelsArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 spoke_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a spoke in the specified project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[str] hub: Immutable. The name of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        :param pulumi.Input[pulumi.InputType['LinkedInterconnectAttachmentsArgs']] linked_interconnect_attachments: VLAN attachments that are associated with the spoke.
        :param pulumi.Input[pulumi.InputType['LinkedRouterApplianceInstancesArgs']] linked_router_appliance_instances: Router appliance instances that are associated with the spoke.
        :param pulumi.Input[pulumi.InputType['LinkedVpnTunnelsArgs']] linked_vpn_tunnels: VPN tunnels that are associated with the spoke.
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique. They use the following form: `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
        :param pulumi.Input[str] request_id: Optional. A unique request ID (optional). If you specify this ID, you can use it in cases when you need to retry your request. When you need to retry, this ID lets the server know that it can ignore the request if it has already been completed. The server guarantees that for at least 60 minutes after the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check to see whether the original operation was received. If it was, the server ignores the second request. This behavior prevents clients from mistakenly creating duplicate commitments. The request ID must be a valid UUID, with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] spoke_id: Required. Unique id for the spoke to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpokeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a spoke in the specified project and location.

        :param str resource_name: The name of the resource.
        :param SpokeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpokeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[pulumi.InputType['LinkedInterconnectAttachmentsArgs']]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[pulumi.InputType['LinkedRouterApplianceInstancesArgs']]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[pulumi.InputType['LinkedVpnTunnelsArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 spoke_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpokeArgs.__new__(SpokeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["hub"] = hub
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linked_interconnect_attachments"] = linked_interconnect_attachments
            __props__.__dict__["linked_router_appliance_instances"] = linked_router_appliance_instances
            __props__.__dict__["linked_vpn_tunnels"] = linked_vpn_tunnels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            if spoke_id is None and not opts.urn:
                raise TypeError("Missing required property 'spoke_id'")
            __props__.__dict__["spoke_id"] = spoke_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["unique_id"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "spoke_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Spoke, __self__).__init__(
            'google-native:networkconnectivity/v1:Spoke',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Spoke':
        """
        Get an existing Spoke resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SpokeArgs.__new__(SpokeArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["hub"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["linked_interconnect_attachments"] = None
        __props__.__dict__["linked_router_appliance_instances"] = None
        __props__.__dict__["linked_vpn_tunnels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["spoke_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["unique_id"] = None
        __props__.__dict__["update_time"] = None
        return Spoke(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time the spoke was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> pulumi.Output['outputs.LinkedInterconnectAttachmentsResponse']:
        """
        VLAN attachments that are associated with the spoke.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> pulumi.Output['outputs.LinkedRouterApplianceInstancesResponse']:
        """
        Router appliance instances that are associated with the spoke.
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> pulumi.Output['outputs.LinkedVpnTunnelsResponse']:
        """
        VPN tunnels that are associated with the spoke.
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the spoke. Spoke names must be unique. They use the following form: `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. A unique request ID (optional). If you specify this ID, you can use it in cases when you need to retry your request. When you need to retry, this ID lets the server know that it can ignore the request if it has already been completed. The server guarantees that for at least 60 minutes after the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check to see whether the original operation was received. If it was, the server ignores the second request. This behavior prevents clients from mistakenly creating duplicate commitments. The request ID must be a valid UUID, with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="spokeId")
    def spoke_id(self) -> pulumi.Output[str]:
        """
        Required. Unique id for the spoke to create.
        """
        return pulumi.get(self, "spoke_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of this spoke.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[str]:
        """
        The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time the spoke was last updated.
        """
        return pulumi.get(self, "update_time")

