# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AggregationArgs',
    'AlertStrategyArgs',
    'AppEngineArgs',
    'AvailabilityCriteriaArgs',
    'BasicAuthenticationArgs',
    'BasicSliArgs',
    'CloudEndpointsArgs',
    'CloudRunArgs',
    'ClusterIstioArgs',
    'ConditionArgs',
    'ContentMatcherArgs',
    'CustomArgs',
    'DistributionCutArgs',
    'DocumentationArgs',
    'GkeNamespaceArgs',
    'GkeServiceArgs',
    'GkeWorkloadArgs',
    'GoogleMonitoringV3RangeArgs',
    'HttpCheckArgs',
    'InternalCheckerArgs',
    'IstioCanonicalServiceArgs',
    'JsonPathMatcherArgs',
    'LabelDescriptorArgs',
    'LatencyCriteriaArgs',
    'LogMatchArgs',
    'MeshIstioArgs',
    'MetricAbsenceArgs',
    'MetricDescriptorMetadataArgs',
    'MetricRangeArgs',
    'MetricThresholdArgs',
    'MonitoredResourceArgs',
    'MonitoringQueryLanguageConditionArgs',
    'MutationRecordArgs',
    'NotificationRateLimitArgs',
    'PerformanceThresholdArgs',
    'RequestBasedSliArgs',
    'ResourceGroupArgs',
    'ServiceLevelIndicatorArgs',
    'StatusArgs',
    'TcpCheckArgs',
    'TelemetryArgs',
    'TimeSeriesRatioArgs',
    'TriggerArgs',
    'WindowsBasedSliArgs',
]

@pulumi.input_type
class AggregationArgs:
    def __init__(__self__, *,
                 alignment_period: Optional[pulumi.Input[str]] = None,
                 cross_series_reducer: Optional[pulumi.Input['AggregationCrossSeriesReducer']] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 per_series_aligner: Optional[pulumi.Input['AggregationPerSeriesAligner']] = None):
        """
        Describes how to combine multiple time series to provide a different view of the data. Aggregation of time series is done in two steps. First, each time series in the set is aligned to the same time interval boundaries, then the set of time series is optionally reduced in number.Alignment consists of applying the per_series_aligner operation to each time series after its data has been divided into regular alignment_period time intervals. This process takes all of the data points in an alignment period, applies a mathematical transformation such as averaging, minimum, maximum, delta, etc., and converts them into a single data point per period.Reduction is when the aligned and transformed time series can optionally be combined, reducing the number of time series through similar mathematical transformations. Reduction involves applying a cross_series_reducer to all the time series, optionally sorting the time series into subsets with group_by_fields, and applying the reducer to each subset.The raw time series data can contain a huge amount of information from multiple sources. Alignment and reduction transforms this mass of data into a more manageable and representative collection of data, for example "the 95% latency across the average of all tasks in a cluster". This representative data can be more easily graphed and comprehended, and the individual time series data is still available for later drilldown. For more details, see Filtering and aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).
        :param pulumi.Input[str] alignment_period: The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 104 weeks (2 years) for charts, and 90,000 seconds (25 hours) for alerting policies.
        :param pulumi.Input['AggregationCrossSeriesReducer'] cross_series_reducer: The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        :param pulumi.Input['AggregationPerSeriesAligner'] per_series_aligner: An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[pulumi.Input[str]]:
        """
        The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 104 weeks (2 years) for charts, and 90,000 seconds (25 hours) for alerting policies.
        """
        return pulumi.get(self, "alignment_period")

    @alignment_period.setter
    def alignment_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alignment_period", value)

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[pulumi.Input['AggregationCrossSeriesReducer']]:
        """
        The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "cross_series_reducer")

    @cross_series_reducer.setter
    def cross_series_reducer(self, value: Optional[pulumi.Input['AggregationCrossSeriesReducer']]):
        pulumi.set(self, "cross_series_reducer", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[pulumi.Input['AggregationPerSeriesAligner']]:
        """
        An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "per_series_aligner")

    @per_series_aligner.setter
    def per_series_aligner(self, value: Optional[pulumi.Input['AggregationPerSeriesAligner']]):
        pulumi.set(self, "per_series_aligner", value)


@pulumi.input_type
class AlertStrategyArgs:
    def __init__(__self__, *,
                 auto_close: Optional[pulumi.Input[str]] = None,
                 notification_rate_limit: Optional[pulumi.Input['NotificationRateLimitArgs']] = None):
        """
        Control over how the notification channels in notification_channels are notified when this alert fires.
        :param pulumi.Input[str] auto_close: If an alert policy that was active has no data for this long, any open incidents will close
        :param pulumi.Input['NotificationRateLimitArgs'] notification_rate_limit: Required for alert policies with a LogMatch condition.This limit is not implemented for alert policies that are not log-based.
        """
        if auto_close is not None:
            pulumi.set(__self__, "auto_close", auto_close)
        if notification_rate_limit is not None:
            pulumi.set(__self__, "notification_rate_limit", notification_rate_limit)

    @property
    @pulumi.getter(name="autoClose")
    def auto_close(self) -> Optional[pulumi.Input[str]]:
        """
        If an alert policy that was active has no data for this long, any open incidents will close
        """
        return pulumi.get(self, "auto_close")

    @auto_close.setter
    def auto_close(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_close", value)

    @property
    @pulumi.getter(name="notificationRateLimit")
    def notification_rate_limit(self) -> Optional[pulumi.Input['NotificationRateLimitArgs']]:
        """
        Required for alert policies with a LogMatch condition.This limit is not implemented for alert policies that are not log-based.
        """
        return pulumi.get(self, "notification_rate_limit")

    @notification_rate_limit.setter
    def notification_rate_limit(self, value: Optional[pulumi.Input['NotificationRateLimitArgs']]):
        pulumi.set(self, "notification_rate_limit", value)


@pulumi.input_type
class AppEngineArgs:
    def __init__(__self__, *,
                 module_id: Optional[pulumi.Input[str]] = None):
        """
        App Engine service. Learn more at https://cloud.google.com/appengine.
        :param pulumi.Input[str] module_id: The ID of the App Engine module underlying this service. Corresponds to the module_id resource label in the gae_app monitored resource (https://cloud.google.com/monitoring/api/resources#tag_gae_app).
        """
        if module_id is not None:
            pulumi.set(__self__, "module_id", module_id)

    @property
    @pulumi.getter(name="moduleId")
    def module_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the App Engine module underlying this service. Corresponds to the module_id resource label in the gae_app monitored resource (https://cloud.google.com/monitoring/api/resources#tag_gae_app).
        """
        return pulumi.get(self, "module_id")

    @module_id.setter
    def module_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "module_id", value)


@pulumi.input_type
class AvailabilityCriteriaArgs:
    def __init__(__self__):
        """
        Future parameters for the availability SLI.
        """
        pass


@pulumi.input_type
class BasicAuthenticationArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The authentication parameters to provide to the specified resource or URL that requires a username and password. Currently, only Basic HTTP authentication (https://tools.ietf.org/html/rfc7617) is supported in Uptime checks.
        :param pulumi.Input[str] password: The password to use when authenticating with the HTTP server.
        :param pulumi.Input[str] username: The username to use when authenticating with the HTTP server.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password to use when authenticating with the HTTP server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use when authenticating with the HTTP server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class BasicSliArgs:
    def __init__(__self__, *,
                 availability: Optional[pulumi.Input['AvailabilityCriteriaArgs']] = None,
                 latency: Optional[pulumi.Input['LatencyCriteriaArgs']] = None,
                 location: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 method: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An SLI measuring performance on a well-known service type. Performance will be computed on the basis of pre-defined metrics. The type of the service_resource determines the metrics to use and the service_resource.labels and metric_labels are used to construct a monitoring filter to filter that metric down to just the data relevant to this service.
        :param pulumi.Input['AvailabilityCriteriaArgs'] availability: Good service is defined to be the count of requests made to this service that return successfully.
        :param pulumi.Input['LatencyCriteriaArgs'] latency: Good service is defined to be the count of requests made to this service that are fast enough with respect to latency.threshold.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] location: OPTIONAL: The set of locations to which this SLI is relevant. Telemetry from other locations will not be used to calculate performance for this SLI. If omitted, this SLI applies to all locations in which the Service has activity. For service types that don't support breaking down by location, setting this field will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] method: OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from other methods will not be used to calculate performance for this SLI. If omitted, this SLI applies to all the Service's methods. For service types that don't support breaking down by method, setting this field will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] version: OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry from other API versions will not be used to calculate performance for this SLI. If omitted, this SLI applies to all API versions. For service types that don't support breaking down by version, setting this field will result in an error.
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if latency is not None:
            pulumi.set(__self__, "latency", latency)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def availability(self) -> Optional[pulumi.Input['AvailabilityCriteriaArgs']]:
        """
        Good service is defined to be the count of requests made to this service that return successfully.
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: Optional[pulumi.Input['AvailabilityCriteriaArgs']]):
        pulumi.set(self, "availability", value)

    @property
    @pulumi.getter
    def latency(self) -> Optional[pulumi.Input['LatencyCriteriaArgs']]:
        """
        Good service is defined to be the count of requests made to this service that are fast enough with respect to latency.threshold.
        """
        return pulumi.get(self, "latency")

    @latency.setter
    def latency(self, value: Optional[pulumi.Input['LatencyCriteriaArgs']]):
        pulumi.set(self, "latency", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        OPTIONAL: The set of locations to which this SLI is relevant. Telemetry from other locations will not be used to calculate performance for this SLI. If omitted, this SLI applies to all locations in which the Service has activity. For service types that don't support breaking down by location, setting this field will result in an error.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from other methods will not be used to calculate performance for this SLI. If omitted, this SLI applies to all the Service's methods. For service types that don't support breaking down by method, setting this field will result in an error.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry from other API versions will not be used to calculate performance for this SLI. If omitted, this SLI applies to all API versions. For service types that don't support breaking down by version, setting this field will result in an error.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class CloudEndpointsArgs:
    def __init__(__self__, *,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
        :param pulumi.Input[str] service: The name of the Cloud Endpoints service underlying this service. Corresponds to the service resource label in the api monitored resource (https://cloud.google.com/monitoring/api/resources#tag_api).
        """
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Endpoints service underlying this service. Corresponds to the service resource label in the api monitored resource (https://cloud.google.com/monitoring/api/resources#tag_api).
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class CloudRunArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Cloud Run service. Learn more at https://cloud.google.com/run.
        :param pulumi.Input[str] location: The location the service is run. Corresponds to the location resource label in the cloud_run_revision monitored resource (https://cloud.google.com/monitoring/api/resources#tag_cloud_run_revision).
        :param pulumi.Input[str] service_name: The name of the Cloud Run service. Corresponds to the service_name resource label in the cloud_run_revision monitored resource (https://cloud.google.com/monitoring/api/resources#tag_cloud_run_revision).
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location the service is run. Corresponds to the location resource label in the cloud_run_revision monitored resource (https://cloud.google.com/monitoring/api/resources#tag_cloud_run_revision).
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Run service. Corresponds to the service_name resource label in the cloud_run_revision monitored resource (https://cloud.google.com/monitoring/api/resources#tag_cloud_run_revision).
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class ClusterIstioArgs:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None):
        """
        Istio service scoped to a single Kubernetes cluster. Learn more at https://istio.io. Clusters running OSS Istio will have their services ingested as this type.
        :param pulumi.Input[str] cluster_name: The name of the Kubernetes cluster in which this Istio service is defined. Corresponds to the cluster_name resource label in k8s_cluster resources.
        :param pulumi.Input[str] location: The location of the Kubernetes cluster in which this Istio service is defined. Corresponds to the location resource label in k8s_cluster resources.
        :param pulumi.Input[str] service_name: The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        :param pulumi.Input[str] service_namespace: The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_namespace is not None:
            pulumi.set(__self__, "service_namespace", service_namespace)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Kubernetes cluster in which this Istio service is defined. Corresponds to the cluster_name resource label in k8s_cluster resources.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the Kubernetes cluster in which this Istio service is defined. Corresponds to the location resource label in k8s_cluster resources.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_namespace", value)


@pulumi.input_type
class ConditionArgs:
    def __init__(__self__, *,
                 condition_absent: Optional[pulumi.Input['MetricAbsenceArgs']] = None,
                 condition_matched_log: Optional[pulumi.Input['LogMatchArgs']] = None,
                 condition_monitoring_query_language: Optional[pulumi.Input['MonitoringQueryLanguageConditionArgs']] = None,
                 condition_threshold: Optional[pulumi.Input['MetricThresholdArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A condition is a true/false test that determines when an alerting policy should open an incident. If a condition evaluates to true, it signifies that something is wrong.
        :param pulumi.Input['MetricAbsenceArgs'] condition_absent: A condition that checks that a time series continues to receive new data points.
        :param pulumi.Input['LogMatchArgs'] condition_matched_log: A condition that checks for log messages matching given constraints. If set, no other conditions can be present.
        :param pulumi.Input['MonitoringQueryLanguageConditionArgs'] condition_monitoring_query_language: A condition that uses the Monitoring Query Language to define alerts.
        :param pulumi.Input['MetricThresholdArgs'] condition_threshold: A condition that compares a time series against a threshold.
        :param pulumi.Input[str] display_name: A short name or phrase used to identify the condition in dashboards, notifications, and incidents. To avoid confusion, don't use the same display name for multiple conditions in the same policy.
        :param pulumi.Input[str] name: Required if the condition exists. The unique resource name for this condition. Its format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID] [CONDITION_ID] is assigned by Cloud Monitoring when the condition is created as part of a new or updated alerting policy.When calling the alertPolicies.create method, do not include the name field in the conditions of the requested alerting policy. Cloud Monitoring creates the condition identifiers and includes them in the new policy.When calling the alertPolicies.update method to update a policy, including a condition name causes the existing condition to be updated. Conditions without names are added to the updated policy. Existing conditions are deleted if they are not updated.Best practice is to preserve [CONDITION_ID] if you make only small changes, such as those to condition thresholds, durations, or trigger values. Otherwise, treat the change as a new condition and let the existing condition be deleted.
        """
        if condition_absent is not None:
            pulumi.set(__self__, "condition_absent", condition_absent)
        if condition_matched_log is not None:
            pulumi.set(__self__, "condition_matched_log", condition_matched_log)
        if condition_monitoring_query_language is not None:
            pulumi.set(__self__, "condition_monitoring_query_language", condition_monitoring_query_language)
        if condition_threshold is not None:
            pulumi.set(__self__, "condition_threshold", condition_threshold)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="conditionAbsent")
    def condition_absent(self) -> Optional[pulumi.Input['MetricAbsenceArgs']]:
        """
        A condition that checks that a time series continues to receive new data points.
        """
        return pulumi.get(self, "condition_absent")

    @condition_absent.setter
    def condition_absent(self, value: Optional[pulumi.Input['MetricAbsenceArgs']]):
        pulumi.set(self, "condition_absent", value)

    @property
    @pulumi.getter(name="conditionMatchedLog")
    def condition_matched_log(self) -> Optional[pulumi.Input['LogMatchArgs']]:
        """
        A condition that checks for log messages matching given constraints. If set, no other conditions can be present.
        """
        return pulumi.get(self, "condition_matched_log")

    @condition_matched_log.setter
    def condition_matched_log(self, value: Optional[pulumi.Input['LogMatchArgs']]):
        pulumi.set(self, "condition_matched_log", value)

    @property
    @pulumi.getter(name="conditionMonitoringQueryLanguage")
    def condition_monitoring_query_language(self) -> Optional[pulumi.Input['MonitoringQueryLanguageConditionArgs']]:
        """
        A condition that uses the Monitoring Query Language to define alerts.
        """
        return pulumi.get(self, "condition_monitoring_query_language")

    @condition_monitoring_query_language.setter
    def condition_monitoring_query_language(self, value: Optional[pulumi.Input['MonitoringQueryLanguageConditionArgs']]):
        pulumi.set(self, "condition_monitoring_query_language", value)

    @property
    @pulumi.getter(name="conditionThreshold")
    def condition_threshold(self) -> Optional[pulumi.Input['MetricThresholdArgs']]:
        """
        A condition that compares a time series against a threshold.
        """
        return pulumi.get(self, "condition_threshold")

    @condition_threshold.setter
    def condition_threshold(self, value: Optional[pulumi.Input['MetricThresholdArgs']]):
        pulumi.set(self, "condition_threshold", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A short name or phrase used to identify the condition in dashboards, notifications, and incidents. To avoid confusion, don't use the same display name for multiple conditions in the same policy.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required if the condition exists. The unique resource name for this condition. Its format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID] [CONDITION_ID] is assigned by Cloud Monitoring when the condition is created as part of a new or updated alerting policy.When calling the alertPolicies.create method, do not include the name field in the conditions of the requested alerting policy. Cloud Monitoring creates the condition identifiers and includes them in the new policy.When calling the alertPolicies.update method to update a policy, including a condition name causes the existing condition to be updated. Conditions without names are added to the updated policy. Existing conditions are deleted if they are not updated.Best practice is to preserve [CONDITION_ID] if you make only small changes, such as those to condition thresholds, durations, or trigger values. Otherwise, treat the change as a new condition and let the existing condition be deleted.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ContentMatcherArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 json_path_matcher: Optional[pulumi.Input['JsonPathMatcherArgs']] = None,
                 matcher: Optional[pulumi.Input['ContentMatcherMatcher']] = None):
        """
        Optional. Used to perform content matching. This allows matching based on substrings and regular expressions, together with their negations. Only the first 4 MB of an HTTP or HTTPS check's response (and the first 1 MB of a TCP check's response) are examined for purposes of content matching.
        :param pulumi.Input[str] content: String, regex or JSON content to match. Maximum 1024 bytes. An empty content string indicates no content matching is to be performed.
        :param pulumi.Input['JsonPathMatcherArgs'] json_path_matcher: Matcher information for MATCHES_JSON_PATH and NOT_MATCHES_JSON_PATH
        :param pulumi.Input['ContentMatcherMatcher'] matcher: The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if json_path_matcher is not None:
            pulumi.set(__self__, "json_path_matcher", json_path_matcher)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        String, regex or JSON content to match. Maximum 1024 bytes. An empty content string indicates no content matching is to be performed.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="jsonPathMatcher")
    def json_path_matcher(self) -> Optional[pulumi.Input['JsonPathMatcherArgs']]:
        """
        Matcher information for MATCHES_JSON_PATH and NOT_MATCHES_JSON_PATH
        """
        return pulumi.get(self, "json_path_matcher")

    @json_path_matcher.setter
    def json_path_matcher(self, value: Optional[pulumi.Input['JsonPathMatcherArgs']]):
        pulumi.set(self, "json_path_matcher", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input['ContentMatcherMatcher']]:
        """
        The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input['ContentMatcherMatcher']]):
        pulumi.set(self, "matcher", value)


@pulumi.input_type
class CustomArgs:
    def __init__(__self__):
        """
        Custom view of service telemetry. Currently a place-holder pending final design.
        """
        pass


@pulumi.input_type
class DistributionCutArgs:
    def __init__(__self__, *,
                 distribution_filter: Optional[pulumi.Input[str]] = None,
                 range: Optional[pulumi.Input['GoogleMonitoringV3RangeArgs']] = None):
        """
        A DistributionCut defines a TimeSeries and thresholds used for measuring good service and total service. The TimeSeries must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE. The computed good_service will be the estimated count of values in the Distribution that fall within the specified min and max.
        :param pulumi.Input[str] distribution_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries aggregating values. Must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param pulumi.Input['GoogleMonitoringV3RangeArgs'] range: Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        """
        if distribution_filter is not None:
            pulumi.set(__self__, "distribution_filter", distribution_filter)
        if range is not None:
            pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter(name="distributionFilter")
    def distribution_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries aggregating values. Must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "distribution_filter")

    @distribution_filter.setter
    def distribution_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distribution_filter", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input['GoogleMonitoringV3RangeArgs']]:
        """
        Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input['GoogleMonitoringV3RangeArgs']]):
        pulumi.set(self, "range", value)


@pulumi.input_type
class DocumentationArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 mime_type: Optional[pulumi.Input[str]] = None):
        """
        A content string and a MIME type that describes the content string's format.
        :param pulumi.Input[str] content: The text of the documentation, interpreted according to mime_type. The content may not exceed 8,192 Unicode characters and may not exceed more than 10,240 bytes when encoded in UTF-8 format, whichever is smaller. This text can be templatized by using variables (https://cloud.google.com/monitoring/alerts/doc-variables).
        :param pulumi.Input[str] mime_type: The format of the content field. Presently, only the value "text/markdown" is supported. See Markdown (https://en.wikipedia.org/wiki/Markdown) for more information.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The text of the documentation, interpreted according to mime_type. The content may not exceed 8,192 Unicode characters and may not exceed more than 10,240 bytes when encoded in UTF-8 format, whichever is smaller. This text can be templatized by using variables (https://cloud.google.com/monitoring/alerts/doc-variables).
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The format of the content field. Presently, only the value "text/markdown" is supported. See Markdown (https://en.wikipedia.org/wiki/Markdown) for more information.
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mime_type", value)


@pulumi.input_type
class GkeNamespaceArgs:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None):
        """
        GKE Namespace. The field names correspond to the resource metadata labels on monitored resources that fall under a namespace (for example, k8s_container or k8s_pod).
        :param pulumi.Input[str] cluster_name: The name of the parent cluster.
        :param pulumi.Input[str] location: The location of the parent cluster. This may be a zone or region.
        :param pulumi.Input[str] namespace_name: The name of this namespace.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parent cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the parent cluster. This may be a zone or region.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this namespace.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name", value)


@pulumi.input_type
class GkeServiceArgs:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        GKE Service. The "service" here represents a Kubernetes service object (https://kubernetes.io/docs/concepts/services-networking/service). The field names correspond to the resource labels on k8s_service monitored resources (https://cloud.google.com/monitoring/api/resources#tag_k8s_service).
        :param pulumi.Input[str] cluster_name: The name of the parent cluster.
        :param pulumi.Input[str] location: The location of the parent cluster. This may be a zone or region.
        :param pulumi.Input[str] namespace_name: The name of the parent namespace.
        :param pulumi.Input[str] service_name: The name of this service.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parent cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the parent cluster. This may be a zone or region.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parent namespace.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class GkeWorkloadArgs:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 top_level_controller_name: Optional[pulumi.Input[str]] = None,
                 top_level_controller_type: Optional[pulumi.Input[str]] = None):
        """
        A GKE Workload (Deployment, StatefulSet, etc). The field names correspond to the metadata labels on monitored resources that fall under a workload (for example, k8s_container or k8s_pod).
        :param pulumi.Input[str] cluster_name: The name of the parent cluster.
        :param pulumi.Input[str] location: The location of the parent cluster. This may be a zone or region.
        :param pulumi.Input[str] namespace_name: The name of the parent namespace.
        :param pulumi.Input[str] top_level_controller_name: The name of this workload.
        :param pulumi.Input[str] top_level_controller_type: The type of this workload (for example, "Deployment" or "DaemonSet")
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if top_level_controller_name is not None:
            pulumi.set(__self__, "top_level_controller_name", top_level_controller_name)
        if top_level_controller_type is not None:
            pulumi.set(__self__, "top_level_controller_type", top_level_controller_type)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parent cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the parent cluster. This may be a zone or region.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parent namespace.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="topLevelControllerName")
    def top_level_controller_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this workload.
        """
        return pulumi.get(self, "top_level_controller_name")

    @top_level_controller_name.setter
    def top_level_controller_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "top_level_controller_name", value)

    @property
    @pulumi.getter(name="topLevelControllerType")
    def top_level_controller_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of this workload (for example, "Deployment" or "DaemonSet")
        """
        return pulumi.get(self, "top_level_controller_type")

    @top_level_controller_type.setter
    def top_level_controller_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "top_level_controller_type", value)


@pulumi.input_type
class GoogleMonitoringV3RangeArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[float]] = None,
                 min: Optional[pulumi.Input[float]] = None):
        """
        Range of numerical values within min and max.
        :param pulumi.Input[float] max: Range maximum.
        :param pulumi.Input[float] min: Range minimum.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[float]]:
        """
        Range maximum.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[float]]:
        """
        Range minimum.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min", value)


@pulumi.input_type
class HttpCheckArgs:
    def __init__(__self__, *,
                 auth_info: Optional[pulumi.Input['BasicAuthenticationArgs']] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input['HttpCheckContentType']] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mask_headers: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 request_method: Optional[pulumi.Input['HttpCheckRequestMethod']] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 validate_ssl: Optional[pulumi.Input[bool]] = None):
        """
        Information involved in an HTTP/HTTPS Uptime check request.
        :param pulumi.Input['BasicAuthenticationArgs'] auth_info: The authentication information. Optional when creating an HTTP check; defaults to empty.
        :param pulumi.Input[str] body: The request body associated with the HTTP POST request. If content_type is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the request_method is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte.Note: If client libraries aren't used (which performs the conversion automatically) base64 encode your body data since the field is of bytes type.
        :param pulumi.Input['HttpCheckContentType'] content_type: The content type header to use for the check. The following configurations result in errors: 1. Content type is specified in both the headers field and the content_type field. 2. Request method is GET and content_type is not TYPE_UNSPECIFIED 3. Request method is POST and content_type is TYPE_UNSPECIFIED. 4. Request method is POST and a "Content-Type" header is provided via headers field. The content_type field should be used instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] headers: The list of headers to send as part of the Uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        :param pulumi.Input[bool] mask_headers: Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to true then the headers will be obscured with ******.
        :param pulumi.Input[str] path: Optional (defaults to "/"). The path to the page against which to run the check. Will be combined with the host (specified within the monitored_resource) and port to construct the full URL. If the provided path does not begin with "/", a "/" will be prepended automatically.
        :param pulumi.Input[int] port: Optional (defaults to 80 when use_ssl is false, and 443 when use_ssl is true). The TCP port on the HTTP server against which to run the check. Will be combined with host (specified within the monitored_resource) and path to construct the full URL.
        :param pulumi.Input['HttpCheckRequestMethod'] request_method: The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then request_method defaults to GET.
        :param pulumi.Input[bool] use_ssl: If true, use HTTPS instead of HTTP to run the check.
        :param pulumi.Input[bool] validate_ssl: Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitored_resource is set to uptime_url. If use_ssl is false, setting validate_ssl to true has no effect.
        """
        if auth_info is not None:
            pulumi.set(__self__, "auth_info", auth_info)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if mask_headers is not None:
            pulumi.set(__self__, "mask_headers", mask_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if validate_ssl is not None:
            pulumi.set(__self__, "validate_ssl", validate_ssl)

    @property
    @pulumi.getter(name="authInfo")
    def auth_info(self) -> Optional[pulumi.Input['BasicAuthenticationArgs']]:
        """
        The authentication information. Optional when creating an HTTP check; defaults to empty.
        """
        return pulumi.get(self, "auth_info")

    @auth_info.setter
    def auth_info(self, value: Optional[pulumi.Input['BasicAuthenticationArgs']]):
        pulumi.set(self, "auth_info", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        The request body associated with the HTTP POST request. If content_type is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the request_method is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte.Note: If client libraries aren't used (which performs the conversion automatically) base64 encode your body data since the field is of bytes type.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input['HttpCheckContentType']]:
        """
        The content type header to use for the check. The following configurations result in errors: 1. Content type is specified in both the headers field and the content_type field. 2. Request method is GET and content_type is not TYPE_UNSPECIFIED 3. Request method is POST and content_type is TYPE_UNSPECIFIED. 4. Request method is POST and a "Content-Type" header is provided via headers field. The content_type field should be used instead.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input['HttpCheckContentType']]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The list of headers to send as part of the Uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="maskHeaders")
    def mask_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to true then the headers will be obscured with ******.
        """
        return pulumi.get(self, "mask_headers")

    @mask_headers.setter
    def mask_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mask_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional (defaults to "/"). The path to the page against which to run the check. Will be combined with the host (specified within the monitored_resource) and port to construct the full URL. If the provided path does not begin with "/", a "/" will be prepended automatically.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Optional (defaults to 80 when use_ssl is false, and 443 when use_ssl is true). The TCP port on the HTTP server against which to run the check. Will be combined with host (specified within the monitored_resource) and path to construct the full URL.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[pulumi.Input['HttpCheckRequestMethod']]:
        """
        The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then request_method defaults to GET.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[pulumi.Input['HttpCheckRequestMethod']]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, use HTTPS instead of HTTP to run the check.
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)

    @property
    @pulumi.getter(name="validateSsl")
    def validate_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitored_resource is set to uptime_url. If use_ssl is false, setting validate_ssl to true has no effect.
        """
        return pulumi.get(self, "validate_ssl")

    @validate_ssl.setter
    def validate_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_ssl", value)


@pulumi.input_type
class InternalCheckerArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 gcp_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 peer_project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['InternalCheckerState']] = None):
        """
        An internal checker allows Uptime checks to run on private/internal GCP resources.
        :param pulumi.Input[str] display_name: The checker's human-readable name. The display name should be unique within a Cloud Monitoring Metrics Scope in order to make it easier to identify; however, uniqueness is not enforced.
        :param pulumi.Input[str] gcp_zone: The GCP zone the Uptime check should egress from. Only respected for internal Uptime checks, where internal_network is specified.
        :param pulumi.Input[str] name: A unique resource name for this InternalChecker. The format is: projects/[PROJECT_ID_OR_NUMBER]/internalCheckers/[INTERNAL_CHECKER_ID] [PROJECT_ID_OR_NUMBER] is the Cloud Monitoring Metrics Scope project for the Uptime check config associated with the internal checker.
        :param pulumi.Input[str] network: The GCP VPC network (https://cloud.google.com/vpc/docs/vpc) where the internal resource lives (ex: "default").
        :param pulumi.Input[str] peer_project_id: The GCP project ID where the internal checker lives. Not necessary the same as the Metrics Scope project.
        :param pulumi.Input['InternalCheckerState'] state: The current operational state of the internal checker.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gcp_zone is not None:
            pulumi.set(__self__, "gcp_zone", gcp_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if peer_project_id is not None:
            pulumi.set(__self__, "peer_project_id", peer_project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The checker's human-readable name. The display name should be unique within a Cloud Monitoring Metrics Scope in order to make it easier to identify; however, uniqueness is not enforced.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gcpZone")
    def gcp_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP zone the Uptime check should egress from. Only respected for internal Uptime checks, where internal_network is specified.
        """
        return pulumi.get(self, "gcp_zone")

    @gcp_zone.setter
    def gcp_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique resource name for this InternalChecker. The format is: projects/[PROJECT_ID_OR_NUMBER]/internalCheckers/[INTERNAL_CHECKER_ID] [PROJECT_ID_OR_NUMBER] is the Cloud Monitoring Metrics Scope project for the Uptime check config associated with the internal checker.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP VPC network (https://cloud.google.com/vpc/docs/vpc) where the internal resource lives (ex: "default").
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="peerProjectId")
    def peer_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP project ID where the internal checker lives. Not necessary the same as the Metrics Scope project.
        """
        return pulumi.get(self, "peer_project_id")

    @peer_project_id.setter
    def peer_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['InternalCheckerState']]:
        """
        The current operational state of the internal checker.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['InternalCheckerState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class IstioCanonicalServiceArgs:
    def __init__(__self__, *,
                 canonical_service: Optional[pulumi.Input[str]] = None,
                 canonical_service_namespace: Optional[pulumi.Input[str]] = None,
                 mesh_uid: Optional[pulumi.Input[str]] = None):
        """
        Canonical service scoped to an Istio mesh. Anthos clusters running ASM >= 1.6.8 will have their services ingested as this type.
        :param pulumi.Input[str] canonical_service: The name of the canonical service underlying this service. Corresponds to the destination_canonical_service_name metric label in label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        :param pulumi.Input[str] canonical_service_namespace: The namespace of the canonical service underlying this service. Corresponds to the destination_canonical_service_namespace metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        :param pulumi.Input[str] mesh_uid: Identifier for the Istio mesh in which this canonical service is defined. Corresponds to the mesh_uid metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        if canonical_service is not None:
            pulumi.set(__self__, "canonical_service", canonical_service)
        if canonical_service_namespace is not None:
            pulumi.set(__self__, "canonical_service_namespace", canonical_service_namespace)
        if mesh_uid is not None:
            pulumi.set(__self__, "mesh_uid", mesh_uid)

    @property
    @pulumi.getter(name="canonicalService")
    def canonical_service(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the canonical service underlying this service. Corresponds to the destination_canonical_service_name metric label in label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        return pulumi.get(self, "canonical_service")

    @canonical_service.setter
    def canonical_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canonical_service", value)

    @property
    @pulumi.getter(name="canonicalServiceNamespace")
    def canonical_service_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the canonical service underlying this service. Corresponds to the destination_canonical_service_namespace metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        return pulumi.get(self, "canonical_service_namespace")

    @canonical_service_namespace.setter
    def canonical_service_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canonical_service_namespace", value)

    @property
    @pulumi.getter(name="meshUid")
    def mesh_uid(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the Istio mesh in which this canonical service is defined. Corresponds to the mesh_uid metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        return pulumi.get(self, "mesh_uid")

    @mesh_uid.setter
    def mesh_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mesh_uid", value)


@pulumi.input_type
class JsonPathMatcherArgs:
    def __init__(__self__, *,
                 json_matcher: Optional[pulumi.Input['JsonPathMatcherJsonMatcher']] = None,
                 json_path: Optional[pulumi.Input[str]] = None):
        """
        Information needed to perform a JSONPath content match. Used for ContentMatcherOption::MATCHES_JSON_PATH and ContentMatcherOption::NOT_MATCHES_JSON_PATH.
        :param pulumi.Input['JsonPathMatcherJsonMatcher'] json_matcher: The type of JSONPath match that will be applied to the JSON output (ContentMatcher.content)
        :param pulumi.Input[str] json_path: JSONPath within the response output pointing to the expected ContentMatcher::content to match against.
        """
        if json_matcher is not None:
            pulumi.set(__self__, "json_matcher", json_matcher)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonMatcher")
    def json_matcher(self) -> Optional[pulumi.Input['JsonPathMatcherJsonMatcher']]:
        """
        The type of JSONPath match that will be applied to the JSON output (ContentMatcher.content)
        """
        return pulumi.get(self, "json_matcher")

    @json_matcher.setter
    def json_matcher(self, value: Optional[pulumi.Input['JsonPathMatcherJsonMatcher']]):
        pulumi.set(self, "json_matcher", value)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[pulumi.Input[str]]:
        """
        JSONPath within the response output pointing to the expected ContentMatcher::content to match against.
        """
        return pulumi.get(self, "json_path")

    @json_path.setter
    def json_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_path", value)


@pulumi.input_type
class LabelDescriptorArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input['LabelDescriptorValueType']] = None):
        """
        A description of a label.
        :param pulumi.Input[str] description: A human-readable description for the label.
        :param pulumi.Input[str] key: The key for this label. The key must meet the following criteria: Does not exceed 100 characters. Matches the following regular expression: [a-zA-Z][a-zA-Z0-9_]* The first character must be an upper- or lower-case letter. The remaining characters must be letters, digits, or underscores.
        :param pulumi.Input['LabelDescriptorValueType'] value_type: The type of data that can be assigned to the label.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key for this label. The key must meet the following criteria: Does not exceed 100 characters. Matches the following regular expression: [a-zA-Z][a-zA-Z0-9_]* The first character must be an upper- or lower-case letter. The remaining characters must be letters, digits, or underscores.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input['LabelDescriptorValueType']]:
        """
        The type of data that can be assigned to the label.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input['LabelDescriptorValueType']]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class LatencyCriteriaArgs:
    def __init__(__self__, *,
                 threshold: Optional[pulumi.Input[str]] = None):
        """
        Parameters for a latency threshold SLI.
        :param pulumi.Input[str] threshold: Good service is defined to be the count of requests made to this service that return in no more than threshold.
        """
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[str]]:
        """
        Good service is defined to be the count of requests made to this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold", value)


@pulumi.input_type
class LogMatchArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 label_extractors: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A condition type that checks whether a log message in the scoping project (https://cloud.google.com/monitoring/api/v3#project_name) satisfies the given filter. Logs from other projects in the metrics scope are not evaluated.
        :param pulumi.Input[str] filter: A logs-based filter. See Advanced Logs Queries (https://cloud.google.com/logging/docs/view/advanced-queries) for how this filter should be constructed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] label_extractors: Optional. A map from a label key to an extractor expression, which is used to extract the value for this label key. Each entry in this map is a specification for how data should be extracted from log entries that match filter. Each combination of extracted values is treated as a separate rule for the purposes of triggering notifications. Label keys and corresponding values can be used in notifications generated by this condition.Please see the documentation on logs-based metric valueExtractors (https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor) for syntax and examples.
        """
        pulumi.set(__self__, "filter", filter)
        if label_extractors is not None:
            pulumi.set(__self__, "label_extractors", label_extractors)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        A logs-based filter. See Advanced Logs Queries (https://cloud.google.com/logging/docs/view/advanced-queries) for how this filter should be constructed.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="labelExtractors")
    def label_extractors(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A map from a label key to an extractor expression, which is used to extract the value for this label key. Each entry in this map is a specification for how data should be extracted from log entries that match filter. Each combination of extracted values is treated as a separate rule for the purposes of triggering notifications. Label keys and corresponding values can be used in notifications generated by this condition.Please see the documentation on logs-based metric valueExtractors (https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor) for syntax and examples.
        """
        return pulumi.get(self, "label_extractors")

    @label_extractors.setter
    def label_extractors(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "label_extractors", value)


@pulumi.input_type
class MeshIstioArgs:
    def __init__(__self__, *,
                 mesh_uid: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None):
        """
        Istio service scoped to an Istio mesh. Anthos clusters running ASM < 1.6.8 will have their services ingested as this type.
        :param pulumi.Input[str] mesh_uid: Identifier for the mesh in which this Istio service is defined. Corresponds to the mesh_uid metric label in Istio metrics.
        :param pulumi.Input[str] service_name: The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        :param pulumi.Input[str] service_namespace: The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        if mesh_uid is not None:
            pulumi.set(__self__, "mesh_uid", mesh_uid)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_namespace is not None:
            pulumi.set(__self__, "service_namespace", service_namespace)

    @property
    @pulumi.getter(name="meshUid")
    def mesh_uid(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the mesh in which this Istio service is defined. Corresponds to the mesh_uid metric label in Istio metrics.
        """
        return pulumi.get(self, "mesh_uid")

    @mesh_uid.setter
    def mesh_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mesh_uid", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_namespace", value)


@pulumi.input_type
class MetricAbsenceArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 aggregations: Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input['TriggerArgs']] = None):
        """
        A condition type that checks that monitored resources are reporting data. The configuration defines a metric and a set of monitored resources. The predicate is considered in violation when a time series for the specified metric of a monitored resource does not include any data in the specified duration.
        :param pulumi.Input[str] filter: A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]] aggregations: Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        :param pulumi.Input[str] duration: The amount of time that a time series must fail to report new data to be considered failing. The minimum value of this field is 120 seconds. Larger values that are a multiple of a minute--for example, 240 or 300 seconds--are supported. If an invalid value is given, an error will be returned. The Duration.nanos field is ignored.
        :param pulumi.Input['TriggerArgs'] trigger: The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations.
        """
        pulumi.set(__self__, "filter", filter)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def aggregations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]]:
        """
        Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        """
        return pulumi.get(self, "aggregations")

    @aggregations.setter
    def aggregations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]]):
        pulumi.set(self, "aggregations", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that a time series must fail to report new data to be considered failing. The minimum value of this field is 120 seconds. Larger values that are a multiple of a minute--for example, 240 or 300 seconds--are supported. If an invalid value is given, an error will be returned. The Duration.nanos field is ignored.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['TriggerArgs']]:
        """
        The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['TriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class MetricDescriptorMetadataArgs:
    def __init__(__self__, *,
                 ingest_delay: Optional[pulumi.Input[str]] = None,
                 launch_stage: Optional[pulumi.Input['MetricDescriptorMetadataLaunchStage']] = None,
                 sample_period: Optional[pulumi.Input[str]] = None):
        """
        Additional annotations that can be used to guide the usage of a metric.
        :param pulumi.Input[str] ingest_delay: The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        :param pulumi.Input['MetricDescriptorMetadataLaunchStage'] launch_stage: Deprecated. Must use the MetricDescriptor.launch_stage instead.
        :param pulumi.Input[str] sample_period: The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        if ingest_delay is not None:
            pulumi.set(__self__, "ingest_delay", ingest_delay)
        if launch_stage is not None:
            warnings.warn("""Deprecated. Must use the MetricDescriptor.launch_stage instead.""", DeprecationWarning)
            pulumi.log.warn("""launch_stage is deprecated: Deprecated. Must use the MetricDescriptor.launch_stage instead.""")
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if sample_period is not None:
            pulumi.set(__self__, "sample_period", sample_period)

    @property
    @pulumi.getter(name="ingestDelay")
    def ingest_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        """
        return pulumi.get(self, "ingest_delay")

    @ingest_delay.setter
    def ingest_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_delay", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input['MetricDescriptorMetadataLaunchStage']]:
        """
        Deprecated. Must use the MetricDescriptor.launch_stage instead.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input['MetricDescriptorMetadataLaunchStage']]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter(name="samplePeriod")
    def sample_period(self) -> Optional[pulumi.Input[str]]:
        """
        The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        return pulumi.get(self, "sample_period")

    @sample_period.setter
    def sample_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_period", value)


@pulumi.input_type
class MetricRangeArgs:
    def __init__(__self__, *,
                 range: Optional[pulumi.Input['GoogleMonitoringV3RangeArgs']] = None,
                 time_series: Optional[pulumi.Input[str]] = None):
        """
        A MetricRange is used when each window is good when the value x of a single TimeSeries satisfies range.min <= x <= range.max. The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE.
        :param pulumi.Input['GoogleMonitoringV3RangeArgs'] range: Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        :param pulumi.Input[str] time_series: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality.
        """
        if range is not None:
            pulumi.set(__self__, "range", range)
        if time_series is not None:
            pulumi.set(__self__, "time_series", time_series)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input['GoogleMonitoringV3RangeArgs']]:
        """
        Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input['GoogleMonitoringV3RangeArgs']]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> Optional[pulumi.Input[str]]:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality.
        """
        return pulumi.get(self, "time_series")

    @time_series.setter
    def time_series(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_series", value)


@pulumi.input_type
class MetricThresholdArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 aggregations: Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]] = None,
                 comparison: Optional[pulumi.Input['MetricThresholdComparison']] = None,
                 denominator_aggregations: Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]] = None,
                 denominator_filter: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 evaluation_missing_data: Optional[pulumi.Input['MetricThresholdEvaluationMissingData']] = None,
                 threshold_value: Optional[pulumi.Input[float]] = None,
                 trigger: Optional[pulumi.Input['TriggerArgs']] = None):
        """
        A condition type that compares a collection of time series against a threshold.
        :param pulumi.Input[str] filter: A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]] aggregations: Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        :param pulumi.Input['MetricThresholdComparison'] comparison: The comparison to apply between the time series (indicated by filter and aggregation) and the threshold (indicated by threshold_value). The comparison is applied on each time series, with the time series on the left-hand side and the threshold on the right-hand side.Only COMPARISON_LT and COMPARISON_GT are supported currently.
        :param pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]] denominator_aggregations: Specifies the alignment of data points in individual time series selected by denominatorFilter as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources).When computing ratios, the aggregations and denominator_aggregations fields must use the same alignment period and produce time series that have the same periodicity and labels.
        :param pulumi.Input[str] denominator_filter: A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies a time series that should be used as the denominator of a ratio that will be compared with the threshold. If a denominator_filter is specified, the time series specified by the filter field will be used as the numerator.The filter must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
        :param pulumi.Input[str] duration: The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        :param pulumi.Input['MetricThresholdEvaluationMissingData'] evaluation_missing_data: A condition control that determines how metric-threshold conditions are evaluated when data stops arriving.
        :param pulumi.Input[float] threshold_value: A value against which to compare the time series.
        :param pulumi.Input['TriggerArgs'] trigger: The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        pulumi.set(__self__, "filter", filter)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if denominator_aggregations is not None:
            pulumi.set(__self__, "denominator_aggregations", denominator_aggregations)
        if denominator_filter is not None:
            pulumi.set(__self__, "denominator_filter", denominator_filter)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if evaluation_missing_data is not None:
            pulumi.set(__self__, "evaluation_missing_data", evaluation_missing_data)
        if threshold_value is not None:
            pulumi.set(__self__, "threshold_value", threshold_value)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def aggregations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]]:
        """
        Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        """
        return pulumi.get(self, "aggregations")

    @aggregations.setter
    def aggregations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]]):
        pulumi.set(self, "aggregations", value)

    @property
    @pulumi.getter
    def comparison(self) -> Optional[pulumi.Input['MetricThresholdComparison']]:
        """
        The comparison to apply between the time series (indicated by filter and aggregation) and the threshold (indicated by threshold_value). The comparison is applied on each time series, with the time series on the left-hand side and the threshold on the right-hand side.Only COMPARISON_LT and COMPARISON_GT are supported currently.
        """
        return pulumi.get(self, "comparison")

    @comparison.setter
    def comparison(self, value: Optional[pulumi.Input['MetricThresholdComparison']]):
        pulumi.set(self, "comparison", value)

    @property
    @pulumi.getter(name="denominatorAggregations")
    def denominator_aggregations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]]:
        """
        Specifies the alignment of data points in individual time series selected by denominatorFilter as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources).When computing ratios, the aggregations and denominator_aggregations fields must use the same alignment period and produce time series that have the same periodicity and labels.
        """
        return pulumi.get(self, "denominator_aggregations")

    @denominator_aggregations.setter
    def denominator_aggregations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AggregationArgs']]]]):
        pulumi.set(self, "denominator_aggregations", value)

    @property
    @pulumi.getter(name="denominatorFilter")
    def denominator_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies a time series that should be used as the denominator of a ratio that will be compared with the threshold. If a denominator_filter is specified, the time series specified by the filter field will be used as the numerator.The filter must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
        """
        return pulumi.get(self, "denominator_filter")

    @denominator_filter.setter
    def denominator_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "denominator_filter", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="evaluationMissingData")
    def evaluation_missing_data(self) -> Optional[pulumi.Input['MetricThresholdEvaluationMissingData']]:
        """
        A condition control that determines how metric-threshold conditions are evaluated when data stops arriving.
        """
        return pulumi.get(self, "evaluation_missing_data")

    @evaluation_missing_data.setter
    def evaluation_missing_data(self, value: Optional[pulumi.Input['MetricThresholdEvaluationMissingData']]):
        pulumi.set(self, "evaluation_missing_data", value)

    @property
    @pulumi.getter(name="thresholdValue")
    def threshold_value(self) -> Optional[pulumi.Input[float]]:
        """
        A value against which to compare the time series.
        """
        return pulumi.get(self, "threshold_value")

    @threshold_value.setter
    def threshold_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_value", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['TriggerArgs']]:
        """
        The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['TriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class MonitoredResourceArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 type: pulumi.Input[str]):
        """
        An object representing a resource that can be used for monitoring, logging, billing, or other purposes. Examples include virtual machine instances, databases, and storage devices such as disks. The type field identifies a MonitoredResourceDescriptor object that describes the resource's schema. Information in the labels field identifies the actual resource and its attributes according to the schema. For example, a particular Compute Engine VM instance could be represented by the following object, because the MonitoredResourceDescriptor for "gce_instance" has labels "project_id", "instance_id" and "zone": { "type": "gce_instance", "labels": { "project_id": "my-project", "instance_id": "12345678901234", "zone": "us-central1-a" }} 
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
        :param pulumi.Input[str] type: The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoringQueryLanguageConditionArgs:
    def __init__(__self__, *,
                 duration: Optional[pulumi.Input[str]] = None,
                 evaluation_missing_data: Optional[pulumi.Input['MonitoringQueryLanguageConditionEvaluationMissingData']] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input['TriggerArgs']] = None):
        """
        A condition type that allows alert policies to be defined using Monitoring Query Language (https://cloud.google.com/monitoring/mql).
        :param pulumi.Input[str] duration: The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        :param pulumi.Input['MonitoringQueryLanguageConditionEvaluationMissingData'] evaluation_missing_data: A condition control that determines how metric-threshold conditions are evaluated when data stops arriving.
        :param pulumi.Input[str] query: Monitoring Query Language (https://cloud.google.com/monitoring/mql) query that outputs a boolean stream.
        :param pulumi.Input['TriggerArgs'] trigger: The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if evaluation_missing_data is not None:
            pulumi.set(__self__, "evaluation_missing_data", evaluation_missing_data)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="evaluationMissingData")
    def evaluation_missing_data(self) -> Optional[pulumi.Input['MonitoringQueryLanguageConditionEvaluationMissingData']]:
        """
        A condition control that determines how metric-threshold conditions are evaluated when data stops arriving.
        """
        return pulumi.get(self, "evaluation_missing_data")

    @evaluation_missing_data.setter
    def evaluation_missing_data(self, value: Optional[pulumi.Input['MonitoringQueryLanguageConditionEvaluationMissingData']]):
        pulumi.set(self, "evaluation_missing_data", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Monitoring Query Language (https://cloud.google.com/monitoring/mql) query that outputs a boolean stream.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['TriggerArgs']]:
        """
        The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['TriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class MutationRecordArgs:
    def __init__(__self__, *,
                 mutate_time: Optional[pulumi.Input[str]] = None,
                 mutated_by: Optional[pulumi.Input[str]] = None):
        """
        Describes a change made to a configuration.
        :param pulumi.Input[str] mutate_time: When the change occurred.
        :param pulumi.Input[str] mutated_by: The email address of the user making the change.
        """
        if mutate_time is not None:
            pulumi.set(__self__, "mutate_time", mutate_time)
        if mutated_by is not None:
            pulumi.set(__self__, "mutated_by", mutated_by)

    @property
    @pulumi.getter(name="mutateTime")
    def mutate_time(self) -> Optional[pulumi.Input[str]]:
        """
        When the change occurred.
        """
        return pulumi.get(self, "mutate_time")

    @mutate_time.setter
    def mutate_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mutate_time", value)

    @property
    @pulumi.getter(name="mutatedBy")
    def mutated_by(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the user making the change.
        """
        return pulumi.get(self, "mutated_by")

    @mutated_by.setter
    def mutated_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mutated_by", value)


@pulumi.input_type
class NotificationRateLimitArgs:
    def __init__(__self__, *,
                 period: Optional[pulumi.Input[str]] = None):
        """
        Control over the rate of notifications sent to this alert policy's notification channels.
        :param pulumi.Input[str] period: Not more than one notification per period.
        """
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        Not more than one notification per period.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)


@pulumi.input_type
class PerformanceThresholdArgs:
    def __init__(__self__, *,
                 basic_sli_performance: Optional[pulumi.Input['BasicSliArgs']] = None,
                 performance: Optional[pulumi.Input['RequestBasedSliArgs']] = None,
                 threshold: Optional[pulumi.Input[float]] = None):
        """
        A PerformanceThreshold is used when each window is good when that window has a sufficiently high performance.
        :param pulumi.Input['BasicSliArgs'] basic_sli_performance: BasicSli to evaluate to judge window quality.
        :param pulumi.Input['RequestBasedSliArgs'] performance: RequestBasedSli to evaluate to judge window quality.
        :param pulumi.Input[float] threshold: If window performance >= threshold, the window is counted as good.
        """
        if basic_sli_performance is not None:
            pulumi.set(__self__, "basic_sli_performance", basic_sli_performance)
        if performance is not None:
            pulumi.set(__self__, "performance", performance)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="basicSliPerformance")
    def basic_sli_performance(self) -> Optional[pulumi.Input['BasicSliArgs']]:
        """
        BasicSli to evaluate to judge window quality.
        """
        return pulumi.get(self, "basic_sli_performance")

    @basic_sli_performance.setter
    def basic_sli_performance(self, value: Optional[pulumi.Input['BasicSliArgs']]):
        pulumi.set(self, "basic_sli_performance", value)

    @property
    @pulumi.getter
    def performance(self) -> Optional[pulumi.Input['RequestBasedSliArgs']]:
        """
        RequestBasedSli to evaluate to judge window quality.
        """
        return pulumi.get(self, "performance")

    @performance.setter
    def performance(self, value: Optional[pulumi.Input['RequestBasedSliArgs']]):
        pulumi.set(self, "performance", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        If window performance >= threshold, the window is counted as good.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)


@pulumi.input_type
class RequestBasedSliArgs:
    def __init__(__self__, *,
                 distribution_cut: Optional[pulumi.Input['DistributionCutArgs']] = None,
                 good_total_ratio: Optional[pulumi.Input['TimeSeriesRatioArgs']] = None):
        """
        Service Level Indicators for which atomic units of service are counted directly.
        :param pulumi.Input['DistributionCutArgs'] distribution_cut: distribution_cut is used when good_service is a count of values aggregated in a Distribution that fall into a good range. The total_service is the total count of all values aggregated in the Distribution.
        :param pulumi.Input['TimeSeriesRatioArgs'] good_total_ratio: good_total_ratio is used when the ratio of good_service to total_service is computed from two TimeSeries.
        """
        if distribution_cut is not None:
            pulumi.set(__self__, "distribution_cut", distribution_cut)
        if good_total_ratio is not None:
            pulumi.set(__self__, "good_total_ratio", good_total_ratio)

    @property
    @pulumi.getter(name="distributionCut")
    def distribution_cut(self) -> Optional[pulumi.Input['DistributionCutArgs']]:
        """
        distribution_cut is used when good_service is a count of values aggregated in a Distribution that fall into a good range. The total_service is the total count of all values aggregated in the Distribution.
        """
        return pulumi.get(self, "distribution_cut")

    @distribution_cut.setter
    def distribution_cut(self, value: Optional[pulumi.Input['DistributionCutArgs']]):
        pulumi.set(self, "distribution_cut", value)

    @property
    @pulumi.getter(name="goodTotalRatio")
    def good_total_ratio(self) -> Optional[pulumi.Input['TimeSeriesRatioArgs']]:
        """
        good_total_ratio is used when the ratio of good_service to total_service is computed from two TimeSeries.
        """
        return pulumi.get(self, "good_total_ratio")

    @good_total_ratio.setter
    def good_total_ratio(self, value: Optional[pulumi.Input['TimeSeriesRatioArgs']]):
        pulumi.set(self, "good_total_ratio", value)


@pulumi.input_type
class ResourceGroupArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input['ResourceGroupResourceType']] = None):
        """
        The resource submessage for group checks. It can be used instead of a monitored resource, when multiple resources are being monitored.
        :param pulumi.Input[str] group_id: The group of resources being monitored. Should be only the [GROUP_ID], and not the full-path projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID].
        :param pulumi.Input['ResourceGroupResourceType'] resource_type: The resource type of the group members.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group of resources being monitored. Should be only the [GROUP_ID], and not the full-path projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID].
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input['ResourceGroupResourceType']]:
        """
        The resource type of the group members.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input['ResourceGroupResourceType']]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class ServiceLevelIndicatorArgs:
    def __init__(__self__, *,
                 basic_sli: Optional[pulumi.Input['BasicSliArgs']] = None,
                 request_based: Optional[pulumi.Input['RequestBasedSliArgs']] = None,
                 windows_based: Optional[pulumi.Input['WindowsBasedSliArgs']] = None):
        """
        A Service-Level Indicator (SLI) describes the "performance" of a service. For some services, the SLI is well-defined. In such cases, the SLI can be described easily by referencing the well-known SLI and providing the needed parameters. Alternatively, a "custom" SLI can be defined with a query to the underlying metric store. An SLI is defined to be good_service / total_service over any queried time interval. The value of performance always falls into the range 0 <= performance <= 1. A custom SLI describes how to compute this ratio, whether this is by dividing values from a pair of time series, cutting a Distribution into good and bad counts, or counting time windows in which the service complies with a criterion. For separation of concerns, a single Service-Level Indicator measures performance for only one aspect of service quality, such as fraction of successful queries or fast-enough queries.
        :param pulumi.Input['BasicSliArgs'] basic_sli: Basic SLI on a well-known service type.
        :param pulumi.Input['RequestBasedSliArgs'] request_based: Request-based SLIs
        :param pulumi.Input['WindowsBasedSliArgs'] windows_based: Windows-based SLIs
        """
        if basic_sli is not None:
            pulumi.set(__self__, "basic_sli", basic_sli)
        if request_based is not None:
            pulumi.set(__self__, "request_based", request_based)
        if windows_based is not None:
            pulumi.set(__self__, "windows_based", windows_based)

    @property
    @pulumi.getter(name="basicSli")
    def basic_sli(self) -> Optional[pulumi.Input['BasicSliArgs']]:
        """
        Basic SLI on a well-known service type.
        """
        return pulumi.get(self, "basic_sli")

    @basic_sli.setter
    def basic_sli(self, value: Optional[pulumi.Input['BasicSliArgs']]):
        pulumi.set(self, "basic_sli", value)

    @property
    @pulumi.getter(name="requestBased")
    def request_based(self) -> Optional[pulumi.Input['RequestBasedSliArgs']]:
        """
        Request-based SLIs
        """
        return pulumi.get(self, "request_based")

    @request_based.setter
    def request_based(self, value: Optional[pulumi.Input['RequestBasedSliArgs']]):
        pulumi.set(self, "request_based", value)

    @property
    @pulumi.getter(name="windowsBased")
    def windows_based(self) -> Optional[pulumi.Input['WindowsBasedSliArgs']]:
        """
        Windows-based SLIs
        """
        return pulumi.get(self, "windows_based")

    @windows_based.setter
    def windows_based(self, value: Optional[pulumi.Input['WindowsBasedSliArgs']]):
        pulumi.set(self, "windows_based", value)


@pulumi.input_type
class StatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The Status type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each Status message contains three pieces of data: error code, error message, and error details.You can find out more about this error model and how to work with it in the API Design Guide (https://cloud.google.com/apis/design/errors).
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class TcpCheckArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        Information required for a TCP Uptime check request.
        :param pulumi.Input[int] port: The TCP port on the server against which to run the check. Will be combined with host (specified within the monitored_resource) to construct the full URL. Required.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port on the server against which to run the check. Will be combined with host (specified within the monitored_resource) to construct the full URL. Required.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class TelemetryArgs:
    def __init__(__self__, *,
                 resource_name: Optional[pulumi.Input[str]] = None):
        """
        Configuration for how to query telemetry on a Service.
        :param pulumi.Input[str] resource_name: The full name of the resource that defines this service. Formatted as described in https://cloud.google.com/apis/design/resource_names.
        """
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the resource that defines this service. Formatted as described in https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)


@pulumi.input_type
class TimeSeriesRatioArgs:
    def __init__(__self__, *,
                 bad_service_filter: Optional[pulumi.Input[str]] = None,
                 good_service_filter: Optional[pulumi.Input[str]] = None,
                 total_service_filter: Optional[pulumi.Input[str]] = None):
        """
        A TimeSeriesRatio specifies two TimeSeries to use for computing the good_service / total_service ratio. The specified TimeSeries must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE. The TimeSeriesRatio must specify exactly two of good, bad, and total, and the relationship good_service + bad_service = total_service will be assumed.
        :param pulumi.Input[str] bad_service_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying bad service, either demanded service that was not provided or demanded service that was of inadequate quality. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param pulumi.Input[str] good_service_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param pulumi.Input[str] total_service_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying total demanded service. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        if bad_service_filter is not None:
            pulumi.set(__self__, "bad_service_filter", bad_service_filter)
        if good_service_filter is not None:
            pulumi.set(__self__, "good_service_filter", good_service_filter)
        if total_service_filter is not None:
            pulumi.set(__self__, "total_service_filter", total_service_filter)

    @property
    @pulumi.getter(name="badServiceFilter")
    def bad_service_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying bad service, either demanded service that was not provided or demanded service that was of inadequate quality. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "bad_service_filter")

    @bad_service_filter.setter
    def bad_service_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bad_service_filter", value)

    @property
    @pulumi.getter(name="goodServiceFilter")
    def good_service_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "good_service_filter")

    @good_service_filter.setter
    def good_service_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "good_service_filter", value)

    @property
    @pulumi.getter(name="totalServiceFilter")
    def total_service_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying total demanded service. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "total_service_filter")

    @total_service_filter.setter
    def total_service_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_service_filter", value)


@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 percent: Optional[pulumi.Input[float]] = None):
        """
        Specifies how many time series must fail a predicate to trigger a condition. If not specified, then a {count: 1} trigger is used.
        :param pulumi.Input[int] count: The absolute number of time series that must fail the predicate for the condition to be triggered.
        :param pulumi.Input[float] percent: The percentage of time series that must fail the predicate for the condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The absolute number of time series that must fail the predicate for the condition to be triggered.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of time series that must fail the predicate for the condition to be triggered.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percent", value)


@pulumi.input_type
class WindowsBasedSliArgs:
    def __init__(__self__, *,
                 good_bad_metric_filter: Optional[pulumi.Input[str]] = None,
                 good_total_ratio_threshold: Optional[pulumi.Input['PerformanceThresholdArgs']] = None,
                 metric_mean_in_range: Optional[pulumi.Input['MetricRangeArgs']] = None,
                 metric_sum_in_range: Optional[pulumi.Input['MetricRangeArgs']] = None,
                 window_period: Optional[pulumi.Input[str]] = None):
        """
        A WindowsBasedSli defines good_service as the count of time windows for which the provided service was of good quality. Criteria for determining if service was good are embedded in the window_criterion.
        :param pulumi.Input[str] good_bad_metric_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries with ValueType = BOOL. The window is good if any true values appear in the window.
        :param pulumi.Input['PerformanceThresholdArgs'] good_total_ratio_threshold: A window is good if its performance is high enough.
        :param pulumi.Input['MetricRangeArgs'] metric_mean_in_range: A window is good if the metric's value is in a good range, averaged across returned streams.
        :param pulumi.Input['MetricRangeArgs'] metric_sum_in_range: A window is good if the metric's value is in a good range, summed across returned streams.
        :param pulumi.Input[str] window_period: Duration over which window quality is evaluated. Must be an integer fraction of a day and at least 60s.
        """
        if good_bad_metric_filter is not None:
            pulumi.set(__self__, "good_bad_metric_filter", good_bad_metric_filter)
        if good_total_ratio_threshold is not None:
            pulumi.set(__self__, "good_total_ratio_threshold", good_total_ratio_threshold)
        if metric_mean_in_range is not None:
            pulumi.set(__self__, "metric_mean_in_range", metric_mean_in_range)
        if metric_sum_in_range is not None:
            pulumi.set(__self__, "metric_sum_in_range", metric_sum_in_range)
        if window_period is not None:
            pulumi.set(__self__, "window_period", window_period)

    @property
    @pulumi.getter(name="goodBadMetricFilter")
    def good_bad_metric_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries with ValueType = BOOL. The window is good if any true values appear in the window.
        """
        return pulumi.get(self, "good_bad_metric_filter")

    @good_bad_metric_filter.setter
    def good_bad_metric_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "good_bad_metric_filter", value)

    @property
    @pulumi.getter(name="goodTotalRatioThreshold")
    def good_total_ratio_threshold(self) -> Optional[pulumi.Input['PerformanceThresholdArgs']]:
        """
        A window is good if its performance is high enough.
        """
        return pulumi.get(self, "good_total_ratio_threshold")

    @good_total_ratio_threshold.setter
    def good_total_ratio_threshold(self, value: Optional[pulumi.Input['PerformanceThresholdArgs']]):
        pulumi.set(self, "good_total_ratio_threshold", value)

    @property
    @pulumi.getter(name="metricMeanInRange")
    def metric_mean_in_range(self) -> Optional[pulumi.Input['MetricRangeArgs']]:
        """
        A window is good if the metric's value is in a good range, averaged across returned streams.
        """
        return pulumi.get(self, "metric_mean_in_range")

    @metric_mean_in_range.setter
    def metric_mean_in_range(self, value: Optional[pulumi.Input['MetricRangeArgs']]):
        pulumi.set(self, "metric_mean_in_range", value)

    @property
    @pulumi.getter(name="metricSumInRange")
    def metric_sum_in_range(self) -> Optional[pulumi.Input['MetricRangeArgs']]:
        """
        A window is good if the metric's value is in a good range, summed across returned streams.
        """
        return pulumi.get(self, "metric_sum_in_range")

    @metric_sum_in_range.setter
    def metric_sum_in_range(self, value: Optional[pulumi.Input['MetricRangeArgs']]):
        pulumi.set(self, "metric_sum_in_range", value)

    @property
    @pulumi.getter(name="windowPeriod")
    def window_period(self) -> Optional[pulumi.Input[str]]:
        """
        Duration over which window quality is evaluated. Must be an integer fraction of a day and at least 60s.
        """
        return pulumi.get(self, "window_period")

    @window_period.setter
    def window_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_period", value)


