# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetOrganizationBucketResult',
    'AwaitableGetOrganizationBucketResult',
    'get_organization_bucket',
    'get_organization_bucket_output',
]

@pulumi.output_type
class GetOrganizationBucketResult:
    def __init__(__self__, cmek_settings=None, create_time=None, description=None, index_configs=None, lifecycle_state=None, locked=None, name=None, restricted_fields=None, retention_days=None, update_time=None):
        if cmek_settings and not isinstance(cmek_settings, dict):
            raise TypeError("Expected argument 'cmek_settings' to be a dict")
        pulumi.set(__self__, "cmek_settings", cmek_settings)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if index_configs and not isinstance(index_configs, list):
            raise TypeError("Expected argument 'index_configs' to be a list")
        pulumi.set(__self__, "index_configs", index_configs)
        if lifecycle_state and not isinstance(lifecycle_state, str):
            raise TypeError("Expected argument 'lifecycle_state' to be a str")
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if locked and not isinstance(locked, bool):
            raise TypeError("Expected argument 'locked' to be a bool")
        pulumi.set(__self__, "locked", locked)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if restricted_fields and not isinstance(restricted_fields, list):
            raise TypeError("Expected argument 'restricted_fields' to be a list")
        pulumi.set(__self__, "restricted_fields", restricted_fields)
        if retention_days and not isinstance(retention_days, int):
            raise TypeError("Expected argument 'retention_days' to be a int")
        pulumi.set(__self__, "retention_days", retention_days)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> 'outputs.CmekSettingsResponse':
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed.
        """
        return pulumi.get(self, "cmek_settings")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation timestamp of the bucket. This is not set for any of the default buckets.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> Sequence['outputs.IndexConfigResponse']:
        """
        A list of indexed fields and related configuration data.
        """
        return pulumi.get(self, "index_configs")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> str:
        """
        The bucket lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Whether the bucket is locked.The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the bucket.For example:projects/my-project/locations/global/buckets/my-bucketFor a list of supported locations, see Supported Regions (https://cloud.google.com/logging/docs/region-support)For the location of global it is unspecified where log entries are actually stored.After a bucket has been created, the location cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restrictedFields")
    def restricted_fields(self) -> Sequence[str]:
        """
        Log entry field paths that are denied access in this bucket.The following fields and their children are eligible: textPayload, jsonPayload, protoPayload, httpRequest, labels, sourceLocation.Restricting a repeated field will restrict all values. Adding a parent will block all child fields. (e.g. foo.bar will block foo.bar.baz)
        """
        return pulumi.get(self, "restricted_fields")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last update timestamp of the bucket.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetOrganizationBucketResult(GetOrganizationBucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationBucketResult(
            cmek_settings=self.cmek_settings,
            create_time=self.create_time,
            description=self.description,
            index_configs=self.index_configs,
            lifecycle_state=self.lifecycle_state,
            locked=self.locked,
            name=self.name,
            restricted_fields=self.restricted_fields,
            retention_days=self.retention_days,
            update_time=self.update_time)


def get_organization_bucket(bucket_id: Optional[str] = None,
                            location: Optional[str] = None,
                            organization_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationBucketResult:
    """
    Gets a log bucket.
    """
    __args__ = dict()
    __args__['bucketId'] = bucket_id
    __args__['location'] = location
    __args__['organizationId'] = organization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:logging/v2:getOrganizationBucket', __args__, opts=opts, typ=GetOrganizationBucketResult).value

    return AwaitableGetOrganizationBucketResult(
        cmek_settings=__ret__.cmek_settings,
        create_time=__ret__.create_time,
        description=__ret__.description,
        index_configs=__ret__.index_configs,
        lifecycle_state=__ret__.lifecycle_state,
        locked=__ret__.locked,
        name=__ret__.name,
        restricted_fields=__ret__.restricted_fields,
        retention_days=__ret__.retention_days,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_organization_bucket)
def get_organization_bucket_output(bucket_id: Optional[pulumi.Input[str]] = None,
                                   location: Optional[pulumi.Input[str]] = None,
                                   organization_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationBucketResult]:
    """
    Gets a log bucket.
    """
    ...
