# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetMetricResult',
    'AwaitableGetMetricResult',
    'get_metric',
    'get_metric_output',
]

@pulumi.output_type
class GetMetricResult:
    def __init__(__self__, bucket_options=None, create_time=None, description=None, disabled=None, filter=None, label_extractors=None, metric_descriptor=None, name=None, update_time=None, value_extractor=None, version=None):
        if bucket_options and not isinstance(bucket_options, dict):
            raise TypeError("Expected argument 'bucket_options' to be a dict")
        pulumi.set(__self__, "bucket_options", bucket_options)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if label_extractors and not isinstance(label_extractors, dict):
            raise TypeError("Expected argument 'label_extractors' to be a dict")
        pulumi.set(__self__, "label_extractors", label_extractors)
        if metric_descriptor and not isinstance(metric_descriptor, dict):
            raise TypeError("Expected argument 'metric_descriptor' to be a dict")
        pulumi.set(__self__, "metric_descriptor", metric_descriptor)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if value_extractor and not isinstance(value_extractor, str):
            raise TypeError("Expected argument 'value_extractor' to be a str")
        pulumi.set(__self__, "value_extractor", value_extractor)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        if version is not None:
            warnings.warn("""Deprecated. The API version that created or updated this metric. The v2 format is used by default and cannot be changed.""", DeprecationWarning)
            pulumi.log.warn("""version is deprecated: Deprecated. The API version that created or updated this metric. The v2 format is used by default and cannot be changed.""")

        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="bucketOptions")
    def bucket_options(self) -> 'outputs.BucketOptionsResponse':
        """
        Optional. The bucket_options are required when the logs-based metric is using a DISTRIBUTION value type and it describes the bucket boundaries used to create a histogram of the extracted values.
        """
        return pulumi.get(self, "bucket_options")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation timestamp of the metric.This field may not be present for older metrics.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. A description of this metric, which is used in documentation. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Optional. If set to True, then this metric is disabled and it does not generate any points.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An advanced logs filter (https://cloud.google.com/logging/docs/view/advanced_filters) which is used to match log entries. Example: "resource.type=gae_app AND severity>=ERROR" The maximum length of the filter is 20000 characters.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="labelExtractors")
    def label_extractors(self) -> Mapping[str, str]:
        """
        Optional. A map from a label key string to an extractor expression which is used to extract data from a log entry field and assign as the label value. Each label key specified in the LabelDescriptor must have an associated extractor expression in this map. The syntax of the extractor expression is the same as for the value_extractor field.The extracted value is converted to the type defined in the label descriptor. If the either the extraction or the type conversion fails, the label will have a default value. The default value for a string label is an empty string, for an integer label its 0, and for a boolean label its false.Note that there are upper bounds on the maximum number of labels and the number of active time series that are allowed in a project.
        """
        return pulumi.get(self, "label_extractors")

    @property
    @pulumi.getter(name="metricDescriptor")
    def metric_descriptor(self) -> 'outputs.MetricDescriptorResponse':
        """
        Optional. The metric descriptor associated with the logs-based metric. If unspecified, it uses a default metric descriptor with a DELTA metric kind, INT64 value type, with no labels and a unit of "1". Such a metric counts the number of log entries matching the filter expression.The name, type, and description fields in the metric_descriptor are output only, and is constructed using the name and description field in the LogMetric.To create a logs-based metric that records a distribution of log values, a DELTA metric kind with a DISTRIBUTION value type must be used along with a value_extractor expression in the LogMetric.Each label in the metric descriptor must have a matching label name as the key and an extractor expression as the value in the label_extractors map.The metric_kind and value_type fields in the metric_descriptor cannot be updated once initially configured. New labels can be added in the metric_descriptor, but existing labels cannot be modified except for their description.
        """
        return pulumi.get(self, "metric_descriptor")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The client-assigned metric identifier. Examples: "error_count", "nginx/requests".Metric identifiers are limited to 100 characters and can include only the following characters: A-Z, a-z, 0-9, and the special characters _-.,+!*',()%/. The forward-slash character (/) denotes a hierarchy of name pieces, and it cannot be the first character of the name.This field is the [METRIC_ID] part of a metric resource name in the format "projects/PROJECT_ID/metrics/METRIC_ID". Example: If the resource name of a metric is "projects/my-project/metrics/nginx%2Frequests", this field's value is "nginx/requests".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last update timestamp of the metric.This field may not be present for older metrics.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="valueExtractor")
    def value_extractor(self) -> str:
        """
        Optional. A value_extractor is required when using a distribution logs-based metric to extract the values to record from a log entry. Two functions are supported for value extraction: EXTRACT(field) or REGEXP_EXTRACT(field, regex). The argument are: 1. field: The name of the log entry field from which the value is to be extracted. 2. regex: A regular expression using the Google RE2 syntax (https://github.com/google/re2/wiki/Syntax) with a single capture group to extract data from the specified log entry field. The value of the field is converted to a string before applying the regex. It is an error to specify a regex that does not include exactly one capture group.The result of the extraction must be convertible to a double type, as the distribution always records double values. If either the extraction or the conversion to double fails, then those values are not recorded in the distribution.Example: REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(\d+).*")
        """
        return pulumi.get(self, "value_extractor")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Deprecated. The API version that created or updated this metric. The v2 format is used by default and cannot be changed.
        """
        return pulumi.get(self, "version")


class AwaitableGetMetricResult(GetMetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetricResult(
            bucket_options=self.bucket_options,
            create_time=self.create_time,
            description=self.description,
            disabled=self.disabled,
            filter=self.filter,
            label_extractors=self.label_extractors,
            metric_descriptor=self.metric_descriptor,
            name=self.name,
            update_time=self.update_time,
            value_extractor=self.value_extractor,
            version=self.version)


def get_metric(metric_id: Optional[str] = None,
               project: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetricResult:
    """
    Gets a logs-based metric.
    """
    __args__ = dict()
    __args__['metricId'] = metric_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:logging/v2:getMetric', __args__, opts=opts, typ=GetMetricResult).value

    return AwaitableGetMetricResult(
        bucket_options=__ret__.bucket_options,
        create_time=__ret__.create_time,
        description=__ret__.description,
        disabled=__ret__.disabled,
        filter=__ret__.filter,
        label_extractors=__ret__.label_extractors,
        metric_descriptor=__ret__.metric_descriptor,
        name=__ret__.name,
        update_time=__ret__.update_time,
        value_extractor=__ret__.value_extractor,
        version=__ret__.version)


@_utilities.lift_output_func(get_metric)
def get_metric_output(metric_id: Optional[pulumi.Input[str]] = None,
                      project: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetricResult]:
    """
    Gets a logs-based metric.
    """
    ...
