# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['BrandArgs', 'Brand']

@pulumi.input_type
class BrandArgs:
    def __init__(__self__, *,
                 application_title: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 support_email: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Brand resource.
        :param pulumi.Input[str] application_title: Application name displayed on OAuth consent screen.
        :param pulumi.Input[str] support_email: Support email displayed on the OAuth consent screen.
        """
        if application_title is not None:
            pulumi.set(__self__, "application_title", application_title)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if support_email is not None:
            pulumi.set(__self__, "support_email", support_email)

    @property
    @pulumi.getter(name="applicationTitle")
    def application_title(self) -> Optional[pulumi.Input[str]]:
        """
        Application name displayed on OAuth consent screen.
        """
        return pulumi.get(self, "application_title")

    @application_title.setter
    def application_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_title", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> Optional[pulumi.Input[str]]:
        """
        Support email displayed on the OAuth consent screen.
        """
        return pulumi.get(self, "support_email")

    @support_email.setter
    def support_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_email", value)


class Brand(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_title: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Constructs a new OAuth brand for the project if one does not exist. The created brand is "internal only", meaning that OAuth clients created under it only accept requests from users who belong to the same Google Workspace organization as the project. The brand is created in an un-reviewed status. NOTE: The "internal only" status can be manually changed in the Google Cloud Console. Requires that a brand does not already exist for the project, and that the specified support email is owned by the caller.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_title: Application name displayed on OAuth consent screen.
        :param pulumi.Input[str] support_email: Support email displayed on the OAuth consent screen.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BrandArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Constructs a new OAuth brand for the project if one does not exist. The created brand is "internal only", meaning that OAuth clients created under it only accept requests from users who belong to the same Google Workspace organization as the project. The brand is created in an un-reviewed status. NOTE: The "internal only" status can be manually changed in the Google Cloud Console. Requires that a brand does not already exist for the project, and that the specified support email is owned by the caller.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param BrandArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BrandArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_title: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BrandArgs.__new__(BrandArgs)

            __props__.__dict__["application_title"] = application_title
            __props__.__dict__["project"] = project
            __props__.__dict__["support_email"] = support_email
            __props__.__dict__["name"] = None
            __props__.__dict__["org_internal_only"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Brand, __self__).__init__(
            'google-native:iap/v1:Brand',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Brand':
        """
        Get an existing Brand resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BrandArgs.__new__(BrandArgs)

        __props__.__dict__["application_title"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["org_internal_only"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["support_email"] = None
        return Brand(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationTitle")
    def application_title(self) -> pulumi.Output[str]:
        """
        Application name displayed on OAuth consent screen.
        """
        return pulumi.get(self, "application_title")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Identifier of the brand. NOTE: GCP project number achieves the same brand identification purpose as only one brand per project can be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgInternalOnly")
    def org_internal_only(self) -> pulumi.Output[bool]:
        """
        Whether the brand is only intended for usage inside the G Suite organization only.
        """
        return pulumi.get(self, "org_internal_only")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> pulumi.Output[str]:
        """
        Support email displayed on the OAuth consent screen.
        """
        return pulumi.get(self, "support_email")

