# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetHl7V2StoreResult',
    'AwaitableGetHl7V2StoreResult',
    'get_hl7_v2_store',
    'get_hl7_v2_store_output',
]

@pulumi.output_type
class GetHl7V2StoreResult:
    def __init__(__self__, labels=None, name=None, notification_config=None, notification_configs=None, parser_config=None, reject_duplicate_message=None):
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_config and not isinstance(notification_config, dict):
            raise TypeError("Expected argument 'notification_config' to be a dict")
        pulumi.set(__self__, "notification_config", notification_config)
        if notification_configs and not isinstance(notification_configs, list):
            raise TypeError("Expected argument 'notification_configs' to be a list")
        pulumi.set(__self__, "notification_configs", notification_configs)
        if parser_config and not isinstance(parser_config, dict):
            raise TypeError("Expected argument 'parser_config' to be a dict")
        pulumi.set(__self__, "parser_config", parser_config)
        if reject_duplicate_message and not isinstance(reject_duplicate_message, bool):
            raise TypeError("Expected argument 'reject_duplicate_message' to be a bool")
        pulumi.set(__self__, "reject_duplicate_message", reject_duplicate_message)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        User-supplied key-value pairs used to organize HL7v2 stores. Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a given store.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the HL7v2 store, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> 'outputs.NotificationConfigResponse':
        """
        The notification destination all messages (both Ingest & Create) are published on. Only the message name is sent as part of the notification. If this is unset, no notifications are sent. Supplied by the client.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> Sequence['outputs.Hl7V2NotificationConfigResponse']:
        """
        A list of notification configs. Each configuration uses a filter to determine whether to publish a message (both Ingest & Create) on the corresponding notification destination. Only the message name is sent as part of the notification. Supplied by the client.
        """
        return pulumi.get(self, "notification_configs")

    @property
    @pulumi.getter(name="parserConfig")
    def parser_config(self) -> 'outputs.ParserConfigResponse':
        """
        The configuration for the parser. It determines how the server parses the messages.
        """
        return pulumi.get(self, "parser_config")

    @property
    @pulumi.getter(name="rejectDuplicateMessage")
    def reject_duplicate_message(self) -> bool:
        """
        Determines whether to reject duplicate messages. A duplicate message is a message with the same raw bytes as a message that has already been ingested/created in this HL7v2 store. The default value is false, meaning that the store accepts the duplicate messages and it also returns the same ACK message in the IngestMessageResponse as has been returned previously. Note that only one resource is created in the store. When this field is set to true, CreateMessage/IngestMessage requests with a duplicate message will be rejected by the store, and IngestMessageErrorDetail returns a NACK message upon rejection.
        """
        return pulumi.get(self, "reject_duplicate_message")


class AwaitableGetHl7V2StoreResult(GetHl7V2StoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHl7V2StoreResult(
            labels=self.labels,
            name=self.name,
            notification_config=self.notification_config,
            notification_configs=self.notification_configs,
            parser_config=self.parser_config,
            reject_duplicate_message=self.reject_duplicate_message)


def get_hl7_v2_store(dataset_id: Optional[str] = None,
                     hl7_v2_store_id: Optional[str] = None,
                     location: Optional[str] = None,
                     project: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHl7V2StoreResult:
    """
    Gets the specified HL7v2 store.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['hl7V2StoreId'] = hl7_v2_store_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:healthcare/v1beta1:getHl7V2Store', __args__, opts=opts, typ=GetHl7V2StoreResult).value

    return AwaitableGetHl7V2StoreResult(
        labels=__ret__.labels,
        name=__ret__.name,
        notification_config=__ret__.notification_config,
        notification_configs=__ret__.notification_configs,
        parser_config=__ret__.parser_config,
        reject_duplicate_message=__ret__.reject_duplicate_message)


@_utilities.lift_output_func(get_hl7_v2_store)
def get_hl7_v2_store_output(dataset_id: Optional[pulumi.Input[str]] = None,
                            hl7_v2_store_id: Optional[pulumi.Input[str]] = None,
                            location: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHl7V2StoreResult]:
    """
    Gets the specified HL7v2 store.
    """
    ...
