# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetConsentStoreResult',
    'AwaitableGetConsentStoreResult',
    'get_consent_store',
    'get_consent_store_output',
]

@pulumi.output_type
class GetConsentStoreResult:
    def __init__(__self__, default_consent_ttl=None, enable_consent_create_on_update=None, labels=None, name=None):
        if default_consent_ttl and not isinstance(default_consent_ttl, str):
            raise TypeError("Expected argument 'default_consent_ttl' to be a str")
        pulumi.set(__self__, "default_consent_ttl", default_consent_ttl)
        if enable_consent_create_on_update and not isinstance(enable_consent_create_on_update, bool):
            raise TypeError("Expected argument 'enable_consent_create_on_update' to be a bool")
        pulumi.set(__self__, "enable_consent_create_on_update", enable_consent_create_on_update)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="defaultConsentTtl")
    def default_consent_ttl(self) -> str:
        """
        Optional. Default time to live for Consents created in this store. Must be at least 24 hours. Updating this field will not affect the expiration time of existing consents.
        """
        return pulumi.get(self, "default_consent_ttl")

    @property
    @pulumi.getter(name="enableConsentCreateOnUpdate")
    def enable_consent_create_on_update(self) -> bool:
        """
        Optional. If `true`, UpdateConsent creates the Consent if it does not already exist. If unspecified, defaults to `false`.
        """
        return pulumi.get(self, "enable_consent_create_on_update")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. User-supplied key-value pairs used to organize consent stores. Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}. Label values must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}. No more than 64 labels can be associated with a given store. For more information: https://cloud.google.com/healthcare/docs/how-tos/labeling-resources
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the consent store, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`. Cannot be changed after creation.
        """
        return pulumi.get(self, "name")


class AwaitableGetConsentStoreResult(GetConsentStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConsentStoreResult(
            default_consent_ttl=self.default_consent_ttl,
            enable_consent_create_on_update=self.enable_consent_create_on_update,
            labels=self.labels,
            name=self.name)


def get_consent_store(consent_store_id: Optional[str] = None,
                      dataset_id: Optional[str] = None,
                      location: Optional[str] = None,
                      project: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConsentStoreResult:
    """
    Gets the specified consent store.
    """
    __args__ = dict()
    __args__['consentStoreId'] = consent_store_id
    __args__['datasetId'] = dataset_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:healthcare/v1beta1:getConsentStore', __args__, opts=opts, typ=GetConsentStoreResult).value

    return AwaitableGetConsentStoreResult(
        default_consent_ttl=__ret__.default_consent_ttl,
        enable_consent_create_on_update=__ret__.enable_consent_create_on_update,
        labels=__ret__.labels,
        name=__ret__.name)


@_utilities.lift_output_func(get_consent_store)
def get_consent_store_output(consent_store_id: Optional[pulumi.Input[str]] = None,
                             dataset_id: Optional[pulumi.Input[str]] = None,
                             location: Optional[pulumi.Input[str]] = None,
                             project: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConsentStoreResult]:
    """
    Gets the specified consent store.
    """
    ...
