# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetAnnotationStoreResult',
    'AwaitableGetAnnotationStoreResult',
    'get_annotation_store',
    'get_annotation_store_output',
]

@pulumi.output_type
class GetAnnotationStoreResult:
    def __init__(__self__, labels=None, name=None):
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. User-supplied key-value pairs used to organize Annotation stores. Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62} Label values must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a given store.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the Annotation store, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}`.
        """
        return pulumi.get(self, "name")


class AwaitableGetAnnotationStoreResult(GetAnnotationStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnnotationStoreResult(
            labels=self.labels,
            name=self.name)


def get_annotation_store(annotation_store_id: Optional[str] = None,
                         dataset_id: Optional[str] = None,
                         location: Optional[str] = None,
                         project: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnnotationStoreResult:
    """
    Gets the specified Annotation store or returns NOT_FOUND if it does not exist.
    """
    __args__ = dict()
    __args__['annotationStoreId'] = annotation_store_id
    __args__['datasetId'] = dataset_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:healthcare/v1beta1:getAnnotationStore', __args__, opts=opts, typ=GetAnnotationStoreResult).value

    return AwaitableGetAnnotationStoreResult(
        labels=__ret__.labels,
        name=__ret__.name)


@_utilities.lift_output_func(get_annotation_store)
def get_annotation_store_output(annotation_store_id: Optional[pulumi.Input[str]] = None,
                                dataset_id: Optional[pulumi.Input[str]] = None,
                                location: Optional[pulumi.Input[str]] = None,
                                project: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnnotationStoreResult]:
    """
    Gets the specified Annotation store or returns NOT_FOUND if it does not exist.
    """
    ...
