# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRestoreResult',
    'AwaitableGetRestoreResult',
    'get_restore',
    'get_restore_output',
]

@pulumi.output_type
class GetRestoreResult:
    def __init__(__self__, backup=None, cluster=None, complete_time=None, create_time=None, description=None, etag=None, labels=None, name=None, resources_excluded_count=None, resources_failed_count=None, resources_restored_count=None, restore_config=None, state=None, state_reason=None, uid=None, update_time=None, volumes_restored_count=None):
        if backup and not isinstance(backup, str):
            raise TypeError("Expected argument 'backup' to be a str")
        pulumi.set(__self__, "backup", backup)
        if cluster and not isinstance(cluster, str):
            raise TypeError("Expected argument 'cluster' to be a str")
        pulumi.set(__self__, "cluster", cluster)
        if complete_time and not isinstance(complete_time, str):
            raise TypeError("Expected argument 'complete_time' to be a str")
        pulumi.set(__self__, "complete_time", complete_time)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resources_excluded_count and not isinstance(resources_excluded_count, int):
            raise TypeError("Expected argument 'resources_excluded_count' to be a int")
        pulumi.set(__self__, "resources_excluded_count", resources_excluded_count)
        if resources_failed_count and not isinstance(resources_failed_count, int):
            raise TypeError("Expected argument 'resources_failed_count' to be a int")
        pulumi.set(__self__, "resources_failed_count", resources_failed_count)
        if resources_restored_count and not isinstance(resources_restored_count, int):
            raise TypeError("Expected argument 'resources_restored_count' to be a int")
        pulumi.set(__self__, "resources_restored_count", resources_restored_count)
        if restore_config and not isinstance(restore_config, dict):
            raise TypeError("Expected argument 'restore_config' to be a dict")
        pulumi.set(__self__, "restore_config", restore_config)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_reason and not isinstance(state_reason, str):
            raise TypeError("Expected argument 'state_reason' to be a str")
        pulumi.set(__self__, "state_reason", state_reason)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if volumes_restored_count and not isinstance(volumes_restored_count, int):
            raise TypeError("Expected argument 'volumes_restored_count' to be a int")
        pulumi.set(__self__, "volumes_restored_count", volumes_restored_count)

    @property
    @pulumi.getter
    def backup(self) -> str:
        """
        Immutable. A reference to the Backup used as the source from which this Restore will restore. Note that this Backup must be a sub-resource of the RestorePlan's backup_plan. Format: projects/*/locations/*/backupPlans/*/backups/*.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        The target cluster into which this Restore will restore data. Valid formats: - projects/*/locations/*/clusters/* - projects/*/zones/*/clusters/* Inherited from parent RestorePlan's cluster value.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> str:
        """
        Timestamp of when the restore operation completed.
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The timestamp when this Restore resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User specified descriptive string for this Restore.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a restore from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform restore updates in order to avoid race conditions: An `etag` is returned in the response to `GetRestore`, and systems are expected to put that etag in the request to `UpdateRestore` or `DeleteRestore` to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of custom labels supplied by user.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The full name of the Restore resource. Format: projects/*/locations/*/restorePlans/*/restores/*
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourcesExcludedCount")
    def resources_excluded_count(self) -> int:
        """
        Number of resources excluded during the restore execution.
        """
        return pulumi.get(self, "resources_excluded_count")

    @property
    @pulumi.getter(name="resourcesFailedCount")
    def resources_failed_count(self) -> int:
        """
        Number of resources that failed to be restored during the restore execution.
        """
        return pulumi.get(self, "resources_failed_count")

    @property
    @pulumi.getter(name="resourcesRestoredCount")
    def resources_restored_count(self) -> int:
        """
        Number of resources restored during the restore execution.
        """
        return pulumi.get(self, "resources_restored_count")

    @property
    @pulumi.getter(name="restoreConfig")
    def restore_config(self) -> 'outputs.RestoreConfigResponse':
        """
        Configuration of the Restore. Inherited from parent RestorePlan's restore_config.
        """
        return pulumi.get(self, "restore_config")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Restore.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> str:
        """
        Human-readable description of why the Restore is in its current state.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Server generated global unique identifier of [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The timestamp when this Restore resource was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="volumesRestoredCount")
    def volumes_restored_count(self) -> int:
        """
        Number of volumes restored during the restore execution.
        """
        return pulumi.get(self, "volumes_restored_count")


class AwaitableGetRestoreResult(GetRestoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRestoreResult(
            backup=self.backup,
            cluster=self.cluster,
            complete_time=self.complete_time,
            create_time=self.create_time,
            description=self.description,
            etag=self.etag,
            labels=self.labels,
            name=self.name,
            resources_excluded_count=self.resources_excluded_count,
            resources_failed_count=self.resources_failed_count,
            resources_restored_count=self.resources_restored_count,
            restore_config=self.restore_config,
            state=self.state,
            state_reason=self.state_reason,
            uid=self.uid,
            update_time=self.update_time,
            volumes_restored_count=self.volumes_restored_count)


def get_restore(location: Optional[str] = None,
                project: Optional[str] = None,
                restore_id: Optional[str] = None,
                restore_plan_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRestoreResult:
    """
    Retrieves the details of a single Restore.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['restoreId'] = restore_id
    __args__['restorePlanId'] = restore_plan_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:gkebackup/v1:getRestore', __args__, opts=opts, typ=GetRestoreResult).value

    return AwaitableGetRestoreResult(
        backup=__ret__.backup,
        cluster=__ret__.cluster,
        complete_time=__ret__.complete_time,
        create_time=__ret__.create_time,
        description=__ret__.description,
        etag=__ret__.etag,
        labels=__ret__.labels,
        name=__ret__.name,
        resources_excluded_count=__ret__.resources_excluded_count,
        resources_failed_count=__ret__.resources_failed_count,
        resources_restored_count=__ret__.resources_restored_count,
        restore_config=__ret__.restore_config,
        state=__ret__.state,
        state_reason=__ret__.state_reason,
        uid=__ret__.uid,
        update_time=__ret__.update_time,
        volumes_restored_count=__ret__.volumes_restored_count)


@_utilities.lift_output_func(get_restore)
def get_restore_output(location: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       restore_id: Optional[pulumi.Input[str]] = None,
                       restore_plan_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRestoreResult]:
    """
    Retrieves the details of a single Restore.
    """
    ...
