# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetIndexResult',
    'AwaitableGetIndexResult',
    'get_index',
    'get_index_output',
]

@pulumi.output_type
class GetIndexResult:
    def __init__(__self__, collection_id=None, fields=None, name=None, state=None):
        if collection_id and not isinstance(collection_id, str):
            raise TypeError("Expected argument 'collection_id' to be a str")
        pulumi.set(__self__, "collection_id", collection_id)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> str:
        """
        The collection ID to which this index applies. Required.
        """
        return pulumi.get(self, "collection_id")

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GoogleFirestoreAdminV1beta1IndexFieldResponse']:
        """
        The fields to index.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the index. Output only.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the index. Output only.
        """
        return pulumi.get(self, "state")


class AwaitableGetIndexResult(GetIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexResult(
            collection_id=self.collection_id,
            fields=self.fields,
            name=self.name,
            state=self.state)


def get_index(database_id: Optional[str] = None,
              index_id: Optional[str] = None,
              project: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexResult:
    """
    Gets an index.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['indexId'] = index_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:firestore/v1beta1:getIndex', __args__, opts=opts, typ=GetIndexResult).value

    return AwaitableGetIndexResult(
        collection_id=__ret__.collection_id,
        fields=__ret__.fields,
        name=__ret__.name,
        state=__ret__.state)


@_utilities.lift_output_func(get_index)
def get_index_output(database_id: Optional[pulumi.Input[str]] = None,
                     index_id: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIndexResult]:
    """
    Gets an index.
    """
    ...
