# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'DatabaseAppEngineIntegrationMode',
    'DatabaseConcurrencyMode',
    'DatabaseType',
    'GoogleFirestoreAdminV1IndexFieldArrayConfig',
    'GoogleFirestoreAdminV1IndexFieldOrder',
    'IndexQueryScope',
]


class DatabaseAppEngineIntegrationMode(str, Enum):
    """
    The App Engine integration mode to use for this database.
    """
    APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED = "APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED"
    """
    Not used.
    """
    ENABLED = "ENABLED"
    """
    If an App Engine application exists in the same region as this database, App Engine configuration will impact this database. This includes disabling of the application & database, as well as disabling writes to the database.
    """
    DISABLED = "DISABLED"
    """
    Appengine has no affect on the ability of this database to serve requests.
    """


class DatabaseConcurrencyMode(str, Enum):
    """
    The concurrency control mode to use for this database.
    """
    CONCURRENCY_MODE_UNSPECIFIED = "CONCURRENCY_MODE_UNSPECIFIED"
    """
    Not used.
    """
    OPTIMISTIC = "OPTIMISTIC"
    """
    Use optimistic concurrency control by default. This mode is available for Cloud Firestore databases.
    """
    PESSIMISTIC = "PESSIMISTIC"
    """
    Use pessimistic concurrency control by default. This mode is available for Cloud Firestore databases. This is the default setting for Cloud Firestore.
    """
    OPTIMISTIC_WITH_ENTITY_GROUPS = "OPTIMISTIC_WITH_ENTITY_GROUPS"
    """
    Use optimistic concurrency control with entity groups by default. This is the only available mode for Cloud Datastore. This mode is also available for Cloud Firestore with Datastore Mode but is not recommended.
    """


class DatabaseType(str, Enum):
    """
    The type of the database. See https://cloud.google.com/datastore/docs/firestore-or-datastore for information about how to choose.
    """
    DATABASE_TYPE_UNSPECIFIED = "DATABASE_TYPE_UNSPECIFIED"
    """
    The default value. This value is used if the database type is omitted.
    """
    FIRESTORE_NATIVE = "FIRESTORE_NATIVE"
    """
    Firestore Native Mode
    """
    DATASTORE_MODE = "DATASTORE_MODE"
    """
    Firestore in Datastore Mode.
    """


class GoogleFirestoreAdminV1IndexFieldArrayConfig(str, Enum):
    """
    Indicates that this field supports operations on `array_value`s.
    """
    ARRAY_CONFIG_UNSPECIFIED = "ARRAY_CONFIG_UNSPECIFIED"
    """
    The index does not support additional array queries.
    """
    CONTAINS = "CONTAINS"
    """
    The index supports array containment queries.
    """


class GoogleFirestoreAdminV1IndexFieldOrder(str, Enum):
    """
    Indicates that this field supports ordering by the specified order or comparing using =, !=, <, <=, >, >=.
    """
    ORDER_UNSPECIFIED = "ORDER_UNSPECIFIED"
    """
    The ordering is unspecified. Not a valid option.
    """
    ASCENDING = "ASCENDING"
    """
    The field is ordered by ascending field value.
    """
    DESCENDING = "DESCENDING"
    """
    The field is ordered by descending field value.
    """


class IndexQueryScope(str, Enum):
    """
    Indexes with a collection query scope specified allow queries against a collection that is the child of a specific document, specified at query time, and that has the same collection id. Indexes with a collection group query scope specified allow queries against all collections descended from a specific document, specified at query time, and that have the same collection id as this index.
    """
    QUERY_SCOPE_UNSPECIFIED = "QUERY_SCOPE_UNSPECIFIED"
    """
    The query scope is unspecified. Not a valid option.
    """
    COLLECTION = "COLLECTION"
    """
    Indexes with a collection query scope specified allow queries against a collection that is the child of a specific document, specified at query time, and that has the collection id specified by the index.
    """
    COLLECTION_GROUP = "COLLECTION_GROUP"
    """
    Indexes with a collection group query scope specified allow queries against all collections that has the collection id specified by the index.
    """
