# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetChannelResult',
    'AwaitableGetChannelResult',
    'get_channel',
    'get_channel_output',
]

@pulumi.output_type
class GetChannelResult:
    def __init__(__self__, create_time=None, expire_time=None, labels=None, name=None, release=None, retained_release_count=None, ttl=None, update_time=None, url=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if release and not isinstance(release, dict):
            raise TypeError("Expected argument 'release' to be a dict")
        pulumi.set(__self__, "release", release)
        if retained_release_count and not isinstance(retained_release_count, int):
            raise TypeError("Expected argument 'retained_release_count' to be a int")
        pulumi.set(__self__, "retained_release_count", retained_release_count)
        if ttl and not isinstance(ttl, str):
            raise TypeError("Expected argument 'ttl' to be a str")
        pulumi.set(__self__, "ttl", ttl)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the channel was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time at which the channel will be automatically deleted. If null, the channel will not be automatically deleted. This field is present in the output whether it's set directly or via the `ttl` field.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Text labels used for extra metadata and/or filtering.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully-qualified resource name for the channel, in the format: sites/ SITE_ID/channels/CHANNEL_ID
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def release(self) -> 'outputs.ReleaseResponse':
        """
        The current release for the channel, if any.
        """
        return pulumi.get(self, "release")

    @property
    @pulumi.getter(name="retainedReleaseCount")
    def retained_release_count(self) -> int:
        """
        The number of previous releases to retain on the channel for rollback or other purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        """
        return pulumi.get(self, "retained_release_count")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Input only. A time-to-live for this channel. Sets `expire_time` to the provided duration past the time of the request.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time at which the channel was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL at which the content of this channel's current release can be viewed. This URL is a Firebase-provided subdomain of `web.app`. The content of this channel's current release can also be viewed at the Firebase-provided subdomain of `firebaseapp.com`. If this channel is the `live` channel for the Hosting site, then the content of this channel's current release can also be viewed at any connected custom domains.
        """
        return pulumi.get(self, "url")


class AwaitableGetChannelResult(GetChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelResult(
            create_time=self.create_time,
            expire_time=self.expire_time,
            labels=self.labels,
            name=self.name,
            release=self.release,
            retained_release_count=self.retained_release_count,
            ttl=self.ttl,
            update_time=self.update_time,
            url=self.url)


def get_channel(channel_id: Optional[str] = None,
                project: Optional[str] = None,
                site_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelResult:
    """
    Retrieves information for the specified channel of the specified site.
    """
    __args__ = dict()
    __args__['channelId'] = channel_id
    __args__['project'] = project
    __args__['siteId'] = site_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:firebasehosting/v1beta1:getChannel', __args__, opts=opts, typ=GetChannelResult).value

    return AwaitableGetChannelResult(
        create_time=__ret__.create_time,
        expire_time=__ret__.expire_time,
        labels=__ret__.labels,
        name=__ret__.name,
        release=__ret__.release,
        retained_release_count=__ret__.retained_release_count,
        ttl=__ret__.ttl,
        update_time=__ret__.update_time,
        url=__ret__.url)


@_utilities.lift_output_func(get_channel)
def get_channel_output(channel_id: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       site_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChannelResult]:
    """
    Retrieves information for the specified channel of the specified site.
    """
    ...
