# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 site: pulumi.Input[str],
                 site_id: pulumi.Input[str],
                 domain_redirect: Optional[pulumi.Input['DomainRedirectArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] domain_name: The domain name of the association.
        :param pulumi.Input[str] site: The site name of the association.
        :param pulumi.Input['DomainRedirectArgs'] domain_redirect: If set, the domain should redirect with the provided parameters.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "site", site)
        pulumi.set(__self__, "site_id", site_id)
        if domain_redirect is not None:
            pulumi.set(__self__, "domain_redirect", domain_redirect)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The domain name of the association.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def site(self) -> pulumi.Input[str]:
        """
        The site name of the association.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: pulumi.Input[str]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="domainRedirect")
    def domain_redirect(self) -> Optional[pulumi.Input['DomainRedirectArgs']]:
        """
        If set, the domain should redirect with the provided parameters.
        """
        return pulumi.get(self, "domain_redirect")

    @domain_redirect.setter
    def domain_redirect(self, value: Optional[pulumi.Input['DomainRedirectArgs']]):
        pulumi.set(self, "domain_redirect", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_redirect: Optional[pulumi.Input[pulumi.InputType['DomainRedirectArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a domain mapping on the specified site.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: The domain name of the association.
        :param pulumi.Input[pulumi.InputType['DomainRedirectArgs']] domain_redirect: If set, the domain should redirect with the provided parameters.
        :param pulumi.Input[str] site: The site name of the association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a domain mapping on the specified site.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_redirect: Optional[pulumi.Input[pulumi.InputType['DomainRedirectArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_redirect"] = domain_redirect
            __props__.__dict__["project"] = project
            if site is None and not opts.urn:
                raise TypeError("Missing required property 'site'")
            __props__.__dict__["site"] = site
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["provisioning"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project", "site_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Domain, __self__).__init__(
            'google-native:firebasehosting/v1beta1:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DomainArgs.__new__(DomainArgs)

        __props__.__dict__["domain_name"] = None
        __props__.__dict__["domain_redirect"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["provisioning"] = None
        __props__.__dict__["site"] = None
        __props__.__dict__["site_id"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["update_time"] = None
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The domain name of the association.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainRedirect")
    def domain_redirect(self) -> pulumi.Output['outputs.DomainRedirectResponse']:
        """
        If set, the domain should redirect with the provided parameters.
        """
        return pulumi.get(self, "domain_redirect")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def provisioning(self) -> pulumi.Output['outputs.DomainProvisioningResponse']:
        """
        Information about the provisioning of certificates and the health of the DNS resolution for the domain.
        """
        return pulumi.get(self, "provisioning")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        The site name of the association.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Additional status of the domain association.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time at which the domain was last updated.
        """
        return pulumi.get(self, "update_time")

