# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetChannelConnectionResult',
    'AwaitableGetChannelConnectionResult',
    'get_channel_connection',
    'get_channel_connection_output',
]

@pulumi.output_type
class GetChannelConnectionResult:
    def __init__(__self__, activation_token=None, channel=None, create_time=None, name=None, uid=None, update_time=None):
        if activation_token and not isinstance(activation_token, str):
            raise TypeError("Expected argument 'activation_token' to be a str")
        pulumi.set(__self__, "activation_token", activation_token)
        if channel and not isinstance(channel, str):
            raise TypeError("Expected argument 'channel' to be a str")
        pulumi.set(__self__, "channel", channel)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> str:
        """
        Input only. Activation token for the channel. The token will be used during the creation of ChannelConnection to bind the channel with the provider project. This field will not be stored in the provider resource.
        """
        return pulumi.get(self, "activation_token")

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The name of the connected subscriber Channel. This is a weak reference to avoid cross project and cross accounts references. This must be in `projects/{project}/location/{location}/channels/{channel_id}` format.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Server assigned ID of the resource. The server guarantees uniqueness and immutability until deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetChannelConnectionResult(GetChannelConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelConnectionResult(
            activation_token=self.activation_token,
            channel=self.channel,
            create_time=self.create_time,
            name=self.name,
            uid=self.uid,
            update_time=self.update_time)


def get_channel_connection(channel_connection_id: Optional[str] = None,
                           location: Optional[str] = None,
                           project: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelConnectionResult:
    """
    Get a single ChannelConnection.
    """
    __args__ = dict()
    __args__['channelConnectionId'] = channel_connection_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:eventarc/v1:getChannelConnection', __args__, opts=opts, typ=GetChannelConnectionResult).value

    return AwaitableGetChannelConnectionResult(
        activation_token=__ret__.activation_token,
        channel=__ret__.channel,
        create_time=__ret__.create_time,
        name=__ret__.name,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_channel_connection)
def get_channel_connection_output(channel_connection_id: Optional[pulumi.Input[str]] = None,
                                  location: Optional[pulumi.Input[str]] = None,
                                  project: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChannelConnectionResult]:
    """
    Get a single ChannelConnection.
    """
    ...
