# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'ContactSettingsArgs',
    'ContactArgs',
    'CustomDnsArgs',
    'DnsSettingsArgs',
    'DsRecordArgs',
    'ExprArgs',
    'GlueRecordArgs',
    'GoogleDomainsDnsArgs',
    'ManagementSettingsArgs',
    'MoneyArgs',
    'PostalAddressArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ContactSettingsArgs:
    def __init__(__self__, *,
                 admin_contact: pulumi.Input['ContactArgs'],
                 privacy: pulumi.Input['ContactSettingsPrivacy'],
                 registrant_contact: pulumi.Input['ContactArgs'],
                 technical_contact: pulumi.Input['ContactArgs']):
        """
        Defines the contact information associated with a `Registration`. [ICANN](https://icann.org/) requires all domain names to have associated contact information. The `registrant_contact` is considered the domain's legal owner, and often the other contacts are identical.
        :param pulumi.Input['ContactArgs'] admin_contact: The administrative contact for the `Registration`.
        :param pulumi.Input['ContactSettingsPrivacy'] privacy: Privacy setting for the contacts associated with the `Registration`.
        :param pulumi.Input['ContactArgs'] registrant_contact: The registrant contact for the `Registration`. *Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.* *Warning: For new `Registration`s, the registrant receives an email confirmation that they must complete within 15 days to avoid domain suspension.*
        :param pulumi.Input['ContactArgs'] technical_contact: The technical contact for the `Registration`.
        """
        pulumi.set(__self__, "admin_contact", admin_contact)
        pulumi.set(__self__, "privacy", privacy)
        pulumi.set(__self__, "registrant_contact", registrant_contact)
        pulumi.set(__self__, "technical_contact", technical_contact)

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> pulumi.Input['ContactArgs']:
        """
        The administrative contact for the `Registration`.
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: pulumi.Input['ContactArgs']):
        pulumi.set(self, "admin_contact", value)

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Input['ContactSettingsPrivacy']:
        """
        Privacy setting for the contacts associated with the `Registration`.
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: pulumi.Input['ContactSettingsPrivacy']):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter(name="registrantContact")
    def registrant_contact(self) -> pulumi.Input['ContactArgs']:
        """
        The registrant contact for the `Registration`. *Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.* *Warning: For new `Registration`s, the registrant receives an email confirmation that they must complete within 15 days to avoid domain suspension.*
        """
        return pulumi.get(self, "registrant_contact")

    @registrant_contact.setter
    def registrant_contact(self, value: pulumi.Input['ContactArgs']):
        pulumi.set(self, "registrant_contact", value)

    @property
    @pulumi.getter(name="technicalContact")
    def technical_contact(self) -> pulumi.Input['ContactArgs']:
        """
        The technical contact for the `Registration`.
        """
        return pulumi.get(self, "technical_contact")

    @technical_contact.setter
    def technical_contact(self, value: pulumi.Input['ContactArgs']):
        pulumi.set(self, "technical_contact", value)


@pulumi.input_type
class ContactArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 phone_number: pulumi.Input[str],
                 postal_address: pulumi.Input['PostalAddressArgs'],
                 fax_number: Optional[pulumi.Input[str]] = None):
        """
        Details required for a contact associated with a `Registration`.
        :param pulumi.Input[str] email: Email address of the contact.
        :param pulumi.Input[str] phone_number: Phone number of the contact in international format. For example, `"+1-800-555-0123"`.
        :param pulumi.Input['PostalAddressArgs'] postal_address: Postal address of the contact.
        :param pulumi.Input[str] fax_number: Fax number of the contact in international format. For example, `"+1-800-555-0123"`.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_address", postal_address)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        Phone number of the contact in international format. For example, `"+1-800-555-0123"`.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> pulumi.Input['PostalAddressArgs']:
        """
        Postal address of the contact.
        """
        return pulumi.get(self, "postal_address")

    @postal_address.setter
    def postal_address(self, value: pulumi.Input['PostalAddressArgs']):
        pulumi.set(self, "postal_address", value)

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[pulumi.Input[str]]:
        """
        Fax number of the contact in international format. For example, `"+1-800-555-0123"`.
        """
        return pulumi.get(self, "fax_number")

    @fax_number.setter
    def fax_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fax_number", value)


@pulumi.input_type
class CustomDnsArgs:
    def __init__(__self__, *,
                 name_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 ds_records: Optional[pulumi.Input[Sequence[pulumi.Input['DsRecordArgs']]]] = None):
        """
        Configuration for an arbitrary DNS provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] name_servers: A list of name servers that store the DNS zone for this domain. Each name server is a domain name, with Unicode domain names expressed in Punycode format.
        :param pulumi.Input[Sequence[pulumi.Input['DsRecordArgs']]] ds_records: The list of DS records for this domain, which are used to enable DNSSEC. The domain's DNS provider can provide the values to set here. If this field is empty, DNSSEC is disabled.
        """
        pulumi.set(__self__, "name_servers", name_servers)
        if ds_records is not None:
            pulumi.set(__self__, "ds_records", ds_records)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of name servers that store the DNS zone for this domain. Each name server is a domain name, with Unicode domain names expressed in Punycode format.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter(name="dsRecords")
    def ds_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DsRecordArgs']]]]:
        """
        The list of DS records for this domain, which are used to enable DNSSEC. The domain's DNS provider can provide the values to set here. If this field is empty, DNSSEC is disabled.
        """
        return pulumi.get(self, "ds_records")

    @ds_records.setter
    def ds_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DsRecordArgs']]]]):
        pulumi.set(self, "ds_records", value)


@pulumi.input_type
class DnsSettingsArgs:
    def __init__(__self__, *,
                 custom_dns: Optional[pulumi.Input['CustomDnsArgs']] = None,
                 glue_records: Optional[pulumi.Input[Sequence[pulumi.Input['GlueRecordArgs']]]] = None,
                 google_domains_dns: Optional[pulumi.Input['GoogleDomainsDnsArgs']] = None):
        """
        Defines the DNS configuration of a `Registration`, including name servers, DNSSEC, and glue records.
        :param pulumi.Input['CustomDnsArgs'] custom_dns: An arbitrary DNS provider identified by its name servers.
        :param pulumi.Input[Sequence[pulumi.Input['GlueRecordArgs']]] glue_records: The list of glue records for this `Registration`. Commonly empty.
        :param pulumi.Input['GoogleDomainsDnsArgs'] google_domains_dns: The free DNS zone provided by [Google Domains](https://domains.google/).
        """
        if custom_dns is not None:
            pulumi.set(__self__, "custom_dns", custom_dns)
        if glue_records is not None:
            pulumi.set(__self__, "glue_records", glue_records)
        if google_domains_dns is not None:
            pulumi.set(__self__, "google_domains_dns", google_domains_dns)

    @property
    @pulumi.getter(name="customDns")
    def custom_dns(self) -> Optional[pulumi.Input['CustomDnsArgs']]:
        """
        An arbitrary DNS provider identified by its name servers.
        """
        return pulumi.get(self, "custom_dns")

    @custom_dns.setter
    def custom_dns(self, value: Optional[pulumi.Input['CustomDnsArgs']]):
        pulumi.set(self, "custom_dns", value)

    @property
    @pulumi.getter(name="glueRecords")
    def glue_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlueRecordArgs']]]]:
        """
        The list of glue records for this `Registration`. Commonly empty.
        """
        return pulumi.get(self, "glue_records")

    @glue_records.setter
    def glue_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlueRecordArgs']]]]):
        pulumi.set(self, "glue_records", value)

    @property
    @pulumi.getter(name="googleDomainsDns")
    def google_domains_dns(self) -> Optional[pulumi.Input['GoogleDomainsDnsArgs']]:
        """
        The free DNS zone provided by [Google Domains](https://domains.google/).
        """
        return pulumi.get(self, "google_domains_dns")

    @google_domains_dns.setter
    def google_domains_dns(self, value: Optional[pulumi.Input['GoogleDomainsDnsArgs']]):
        pulumi.set(self, "google_domains_dns", value)


@pulumi.input_type
class DsRecordArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input['DsRecordAlgorithm']] = None,
                 digest: Optional[pulumi.Input[str]] = None,
                 digest_type: Optional[pulumi.Input['DsRecordDigestType']] = None,
                 key_tag: Optional[pulumi.Input[int]] = None):
        """
        Defines a Delegation Signer (DS) record, which is needed to enable DNSSEC for a domain. It contains a digest (hash) of a DNSKEY record that must be present in the domain's DNS zone.
        :param pulumi.Input['DsRecordAlgorithm'] algorithm: The algorithm used to generate the referenced DNSKEY.
        :param pulumi.Input[str] digest: The digest generated from the referenced DNSKEY.
        :param pulumi.Input['DsRecordDigestType'] digest_type: The hash function used to generate the digest of the referenced DNSKEY.
        :param pulumi.Input[int] key_tag: The key tag of the record. Must be set in range 0 -- 65535.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if digest_type is not None:
            pulumi.set(__self__, "digest_type", digest_type)
        if key_tag is not None:
            pulumi.set(__self__, "key_tag", key_tag)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['DsRecordAlgorithm']]:
        """
        The algorithm used to generate the referenced DNSKEY.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['DsRecordAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[str]]:
        """
        The digest generated from the referenced DNSKEY.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter(name="digestType")
    def digest_type(self) -> Optional[pulumi.Input['DsRecordDigestType']]:
        """
        The hash function used to generate the digest of the referenced DNSKEY.
        """
        return pulumi.get(self, "digest_type")

    @digest_type.setter
    def digest_type(self, value: Optional[pulumi.Input['DsRecordDigestType']]):
        pulumi.set(self, "digest_type", value)

    @property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> Optional[pulumi.Input[int]]:
        """
        The key tag of the record. Must be set in range 0 -- 65535.
        """
        return pulumi.get(self, "key_tag")

    @key_tag.setter
    def key_tag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_tag", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GlueRecordArgs:
    def __init__(__self__, *,
                 host_name: pulumi.Input[str],
                 ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines a host on your domain that is a DNS name server for your domain and/or other domains. Glue records are a way of making the IP address of a name server known, even when it serves DNS queries for its parent domain. For example, when `ns.example.com` is a name server for `example.com`, the host `ns.example.com` must have a glue record to break the circular DNS reference.
        :param pulumi.Input[str] host_name: Domain name of the host in Punycode format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_addresses: List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. `198.51.100.1`). At least one of `ipv4_address` and `ipv6_address` must be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: List of IPv6 addresses corresponding to this host in the standard hexadecimal format (e.g. `2001:db8::`). At least one of `ipv4_address` and `ipv6_address` must be set.
        """
        pulumi.set(__self__, "host_name", host_name)
        if ipv4_addresses is not None:
            pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        Domain name of the host in Punycode format.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. `198.51.100.1`). At least one of `ipv4_address` and `ipv6_address` must be set.
        """
        return pulumi.get(self, "ipv4_addresses")

    @ipv4_addresses.setter
    def ipv4_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv4_addresses", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IPv6 addresses corresponding to this host in the standard hexadecimal format (e.g. `2001:db8::`). At least one of `ipv4_address` and `ipv6_address` must be set.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_addresses", value)


@pulumi.input_type
class GoogleDomainsDnsArgs:
    def __init__(__self__, *,
                 ds_state: pulumi.Input['GoogleDomainsDnsDsState']):
        """
        Configuration for using the free DNS zone provided by Google Domains as a `Registration`'s `dns_provider`. You cannot configure the DNS zone itself using the API. To configure the DNS zone, go to [Google Domains](https://domains.google/).
        :param pulumi.Input['GoogleDomainsDnsDsState'] ds_state: The state of DS records for this domain. Used to enable or disable automatic DNSSEC.
        """
        pulumi.set(__self__, "ds_state", ds_state)

    @property
    @pulumi.getter(name="dsState")
    def ds_state(self) -> pulumi.Input['GoogleDomainsDnsDsState']:
        """
        The state of DS records for this domain. Used to enable or disable automatic DNSSEC.
        """
        return pulumi.get(self, "ds_state")

    @ds_state.setter
    def ds_state(self, value: pulumi.Input['GoogleDomainsDnsDsState']):
        pulumi.set(self, "ds_state", value)


@pulumi.input_type
class ManagementSettingsArgs:
    def __init__(__self__, *,
                 transfer_lock_state: Optional[pulumi.Input['ManagementSettingsTransferLockState']] = None):
        """
        Defines renewal, billing, and transfer settings for a `Registration`.
        :param pulumi.Input['ManagementSettingsTransferLockState'] transfer_lock_state: Controls whether the domain can be transferred to another registrar.
        """
        if transfer_lock_state is not None:
            pulumi.set(__self__, "transfer_lock_state", transfer_lock_state)

    @property
    @pulumi.getter(name="transferLockState")
    def transfer_lock_state(self) -> Optional[pulumi.Input['ManagementSettingsTransferLockState']]:
        """
        Controls whether the domain can be transferred to another registrar.
        """
        return pulumi.get(self, "transfer_lock_state")

    @transfer_lock_state.setter
    def transfer_lock_state(self, value: Optional[pulumi.Input['ManagementSettingsTransferLockState']]):
        pulumi.set(self, "transfer_lock_state", value)


@pulumi.input_type
class MoneyArgs:
    def __init__(__self__, *,
                 currency_code: Optional[pulumi.Input[str]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 units: Optional[pulumi.Input[str]] = None):
        """
        Represents an amount of money with its currency type.
        :param pulumi.Input[str] currency_code: The three-letter currency code defined in ISO 4217.
        :param pulumi.Input[int] nanos: Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        :param pulumi.Input[str] units: The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[pulumi.Input[str]]:
        """
        The three-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @currency_code.setter
    def currency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency_code", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        """
        The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)


@pulumi.input_type
class PostalAddressArgs:
    def __init__(__self__, *,
                 region_code: pulumi.Input[str],
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 administrative_area: Optional[pulumi.Input[str]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revision: Optional[pulumi.Input[int]] = None,
                 sorting_code: Optional[pulumi.Input[str]] = None,
                 sublocality: Optional[pulumi.Input[str]] = None):
        """
        Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an i18n-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
        :param pulumi.Input[str] region_code: CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_lines: Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        :param pulumi.Input[str] administrative_area: Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        :param pulumi.Input[str] language_code: Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        :param pulumi.Input[str] locality: Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        :param pulumi.Input[str] organization: Optional. The name of the organization at the address.
        :param pulumi.Input[str] postal_code: Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recipients: Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        :param pulumi.Input[int] revision: The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        :param pulumi.Input[str] sorting_code: Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        :param pulumi.Input[str] sublocality: Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        pulumi.set(__self__, "region_code", region_code)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if administrative_area is not None:
            pulumi.set(__self__, "administrative_area", administrative_area)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if sorting_code is not None:
            pulumi.set(__self__, "sorting_code", sorting_code)
        if sublocality is not None:
            pulumi.set(__self__, "sublocality", sublocality)

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> pulumi.Input[str]:
        """
        CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @region_code.setter
    def region_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_code", value)

    @property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        """
        return pulumi.get(self, "address_lines")

    @address_lines.setter
    def address_lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_lines", value)

    @property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @administrative_area.setter
    def administrative_area(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrative_area", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[int]]:
        """
        The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="sortingCode")
    def sorting_code(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        """
        return pulumi.get(self, "sorting_code")

    @sorting_code.setter
    def sorting_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sorting_code", value)

    @property
    @pulumi.getter
    def sublocality(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        return pulumi.get(self, "sublocality")

    @sublocality.setter
    def sublocality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sublocality", value)


