# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    def __init__(__self__, alternative_name_server_config=None, description=None, enable_inbound_forwarding=None, enable_logging=None, kind=None, name=None, networks=None):
        if alternative_name_server_config and not isinstance(alternative_name_server_config, dict):
            raise TypeError("Expected argument 'alternative_name_server_config' to be a dict")
        pulumi.set(__self__, "alternative_name_server_config", alternative_name_server_config)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enable_inbound_forwarding and not isinstance(enable_inbound_forwarding, bool):
            raise TypeError("Expected argument 'enable_inbound_forwarding' to be a bool")
        pulumi.set(__self__, "enable_inbound_forwarding", enable_inbound_forwarding)
        if enable_logging and not isinstance(enable_logging, bool):
            raise TypeError("Expected argument 'enable_logging' to be a bool")
        pulumi.set(__self__, "enable_logging", enable_logging)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="alternativeNameServerConfig")
    def alternative_name_server_config(self) -> 'outputs.PolicyAlternativeNameServerConfigResponse':
        """
        Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        return pulumi.get(self, "alternative_name_server_config")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A mutable string of at most 1024 characters associated with this resource for the user's convenience. Has no effect on the policy's function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableInboundForwarding")
    def enable_inbound_forwarding(self) -> bool:
        """
        Allows networks bound to this policy to receive DNS queries sent by VMs or applications over VPN connections. When enabled, a virtual IP address is allocated from each of the subnetworks that are bound to this policy.
        """
        return pulumi.get(self, "enable_inbound_forwarding")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> bool:
        """
        Controls whether logging is enabled for the networks bound to this policy. Defaults to no logging if not set.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        User-assigned name for this policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.PolicyNetworkResponse']:
        """
        List of network names specifying networks to which this policy is applied.
        """
        return pulumi.get(self, "networks")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            alternative_name_server_config=self.alternative_name_server_config,
            description=self.description,
            enable_inbound_forwarding=self.enable_inbound_forwarding,
            enable_logging=self.enable_logging,
            kind=self.kind,
            name=self.name,
            networks=self.networks)


def get_policy(client_operation_id: Optional[str] = None,
               policy: Optional[str] = None,
               project: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    Fetches the representation of an existing Policy.
    """
    __args__ = dict()
    __args__['clientOperationId'] = client_operation_id
    __args__['policy'] = policy
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dns/v1beta2:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        alternative_name_server_config=__ret__.alternative_name_server_config,
        description=__ret__.description,
        enable_inbound_forwarding=__ret__.enable_inbound_forwarding,
        enable_logging=__ret__.enable_logging,
        kind=__ret__.kind,
        name=__ret__.name,
        networks=__ret__.networks)


@_utilities.lift_output_func(get_policy)
def get_policy_output(client_operation_id: Optional[pulumi.Input[Optional[str]]] = None,
                      policy: Optional[pulumi.Input[str]] = None,
                      project: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPolicyResult]:
    """
    Fetches the representation of an existing Policy.
    """
    ...
