# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetBatchResult',
    'AwaitableGetBatchResult',
    'get_batch',
    'get_batch_output',
]

@pulumi.output_type
class GetBatchResult:
    def __init__(__self__, create_time=None, creator=None, environment_config=None, labels=None, name=None, operation=None, pyspark_batch=None, runtime_config=None, runtime_info=None, spark_batch=None, spark_r_batch=None, spark_sql_batch=None, state=None, state_history=None, state_message=None, state_time=None, uuid=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if environment_config and not isinstance(environment_config, dict):
            raise TypeError("Expected argument 'environment_config' to be a dict")
        pulumi.set(__self__, "environment_config", environment_config)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if pyspark_batch and not isinstance(pyspark_batch, dict):
            raise TypeError("Expected argument 'pyspark_batch' to be a dict")
        pulumi.set(__self__, "pyspark_batch", pyspark_batch)
        if runtime_config and not isinstance(runtime_config, dict):
            raise TypeError("Expected argument 'runtime_config' to be a dict")
        pulumi.set(__self__, "runtime_config", runtime_config)
        if runtime_info and not isinstance(runtime_info, dict):
            raise TypeError("Expected argument 'runtime_info' to be a dict")
        pulumi.set(__self__, "runtime_info", runtime_info)
        if spark_batch and not isinstance(spark_batch, dict):
            raise TypeError("Expected argument 'spark_batch' to be a dict")
        pulumi.set(__self__, "spark_batch", spark_batch)
        if spark_r_batch and not isinstance(spark_r_batch, dict):
            raise TypeError("Expected argument 'spark_r_batch' to be a dict")
        pulumi.set(__self__, "spark_r_batch", spark_r_batch)
        if spark_sql_batch and not isinstance(spark_sql_batch, dict):
            raise TypeError("Expected argument 'spark_sql_batch' to be a dict")
        pulumi.set(__self__, "spark_sql_batch", spark_sql_batch)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_history and not isinstance(state_history, list):
            raise TypeError("Expected argument 'state_history' to be a list")
        pulumi.set(__self__, "state_history", state_history)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if state_time and not isinstance(state_time, str):
            raise TypeError("Expected argument 'state_time' to be a str")
        pulumi.set(__self__, "state_time", state_time)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the batch was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        The email address of the user who created the batch.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> 'outputs.EnvironmentConfigResponse':
        """
        Optional. Environment configuration for the batch execution.
        """
        return pulumi.get(self, "environment_config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. The labels to associate with this batch. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a batch.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the batch.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        The resource name of the operation associated with this batch.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="pysparkBatch")
    def pyspark_batch(self) -> 'outputs.PySparkBatchResponse':
        """
        Optional. PySpark batch config.
        """
        return pulumi.get(self, "pyspark_batch")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> 'outputs.RuntimeConfigResponse':
        """
        Optional. Runtime configuration for the batch execution.
        """
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter(name="runtimeInfo")
    def runtime_info(self) -> 'outputs.RuntimeInfoResponse':
        """
        Runtime information about batch execution.
        """
        return pulumi.get(self, "runtime_info")

    @property
    @pulumi.getter(name="sparkBatch")
    def spark_batch(self) -> 'outputs.SparkBatchResponse':
        """
        Optional. Spark batch config.
        """
        return pulumi.get(self, "spark_batch")

    @property
    @pulumi.getter(name="sparkRBatch")
    def spark_r_batch(self) -> 'outputs.SparkRBatchResponse':
        """
        Optional. SparkR batch config.
        """
        return pulumi.get(self, "spark_r_batch")

    @property
    @pulumi.getter(name="sparkSqlBatch")
    def spark_sql_batch(self) -> 'outputs.SparkSqlBatchResponse':
        """
        Optional. SparkSql batch config.
        """
        return pulumi.get(self, "spark_sql_batch")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the batch.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateHistory")
    def state_history(self) -> Sequence['outputs.StateHistoryResponse']:
        """
        Historical state information for the batch.
        """
        return pulumi.get(self, "state_history")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        Batch state details, such as a failure description if the state is FAILED.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> str:
        """
        The time when the batch entered a current state.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        A batch UUID (Unique Universal Identifier). The service generates this value when it creates the batch.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetBatchResult(GetBatchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBatchResult(
            create_time=self.create_time,
            creator=self.creator,
            environment_config=self.environment_config,
            labels=self.labels,
            name=self.name,
            operation=self.operation,
            pyspark_batch=self.pyspark_batch,
            runtime_config=self.runtime_config,
            runtime_info=self.runtime_info,
            spark_batch=self.spark_batch,
            spark_r_batch=self.spark_r_batch,
            spark_sql_batch=self.spark_sql_batch,
            state=self.state,
            state_history=self.state_history,
            state_message=self.state_message,
            state_time=self.state_time,
            uuid=self.uuid)


def get_batch(batch_id: Optional[str] = None,
              location: Optional[str] = None,
              project: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBatchResult:
    """
    Gets the batch workload resource representation.
    """
    __args__ = dict()
    __args__['batchId'] = batch_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dataproc/v1:getBatch', __args__, opts=opts, typ=GetBatchResult).value

    return AwaitableGetBatchResult(
        create_time=__ret__.create_time,
        creator=__ret__.creator,
        environment_config=__ret__.environment_config,
        labels=__ret__.labels,
        name=__ret__.name,
        operation=__ret__.operation,
        pyspark_batch=__ret__.pyspark_batch,
        runtime_config=__ret__.runtime_config,
        runtime_info=__ret__.runtime_info,
        spark_batch=__ret__.spark_batch,
        spark_r_batch=__ret__.spark_r_batch,
        spark_sql_batch=__ret__.spark_sql_batch,
        state=__ret__.state,
        state_history=__ret__.state_history,
        state_message=__ret__.state_message,
        state_time=__ret__.state_time,
        uuid=__ret__.uuid)


@_utilities.lift_output_func(get_batch)
def get_batch_output(batch_id: Optional[pulumi.Input[str]] = None,
                     location: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBatchResult]:
    """
    Gets the batch workload resource representation.
    """
    ...
