# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetEntityResult',
    'AwaitableGetEntityResult',
    'get_entity',
    'get_entity_output',
]

@pulumi.output_type
class GetEntityResult:
    def __init__(__self__, asset=None, catalog_entry=None, compatibility=None, create_time=None, data_path=None, data_path_pattern=None, description=None, display_name=None, etag=None, format=None, name=None, schema=None, system=None, type=None, update_time=None):
        if asset and not isinstance(asset, str):
            raise TypeError("Expected argument 'asset' to be a str")
        pulumi.set(__self__, "asset", asset)
        if catalog_entry and not isinstance(catalog_entry, str):
            raise TypeError("Expected argument 'catalog_entry' to be a str")
        pulumi.set(__self__, "catalog_entry", catalog_entry)
        if compatibility and not isinstance(compatibility, dict):
            raise TypeError("Expected argument 'compatibility' to be a dict")
        pulumi.set(__self__, "compatibility", compatibility)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_path and not isinstance(data_path, str):
            raise TypeError("Expected argument 'data_path' to be a str")
        pulumi.set(__self__, "data_path", data_path)
        if data_path_pattern and not isinstance(data_path_pattern, str):
            raise TypeError("Expected argument 'data_path_pattern' to be a str")
        pulumi.set(__self__, "data_path_pattern", data_path_pattern)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if format and not isinstance(format, dict):
            raise TypeError("Expected argument 'format' to be a dict")
        pulumi.set(__self__, "format", format)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schema and not isinstance(schema, dict):
            raise TypeError("Expected argument 'schema' to be a dict")
        pulumi.set(__self__, "schema", schema)
        if system and not isinstance(system, str):
            raise TypeError("Expected argument 'system' to be a str")
        pulumi.set(__self__, "system", system)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def asset(self) -> str:
        """
        Immutable. The ID of the asset associated with the storage location containing the entity data. The entity must be with in the same zone with the asset.
        """
        return pulumi.get(self, "asset")

    @property
    @pulumi.getter(name="catalogEntry")
    def catalog_entry(self) -> str:
        """
        The name of the associated Data Catalog entry.
        """
        return pulumi.get(self, "catalog_entry")

    @property
    @pulumi.getter
    def compatibility(self) -> 'outputs.GoogleCloudDataplexV1EntityCompatibilityStatusResponse':
        """
        Metadata stores that the entity is compatible with.
        """
        return pulumi.get(self, "compatibility")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the entity was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataPath")
    def data_path(self) -> str:
        """
        Immutable. The storage path of the entity data. For Cloud Storage data, this is the fully-qualified path to the entity, such as gs://bucket/path/to/data. For BigQuery data, this is the name of the table resource, such as projects/project_id/datasets/dataset_id/tables/table_id.
        """
        return pulumi.get(self, "data_path")

    @property
    @pulumi.getter(name="dataPathPattern")
    def data_path_pattern(self) -> str:
        """
        Optional. The set of items within the data path constituting the data in the entity, represented as a glob path. Example: gs://bucket/path/to/data/**/*.csv.
        """
        return pulumi.get(self, "data_path_pattern")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User friendly longer description text. Must be shorter than or equal to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. Display name must be shorter than or equal to 256 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Optional. The etag associated with the entity, which can be retrieved with a GetEntity request. Required for update and delete requests.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def format(self) -> 'outputs.GoogleCloudDataplexV1StorageFormatResponse':
        """
        Identifies the storage format of the entity data. It does not apply to entities with data stored in BigQuery.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the entity, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> 'outputs.GoogleCloudDataplexV1SchemaResponse':
        """
        The description of the data structure and layout. The schema is not included in list responses. It is only included in SCHEMA and FULL entity views of a GetEntity response.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def system(self) -> str:
        """
        Immutable. Identifies the storage system of the entity data.
        """
        return pulumi.get(self, "system")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. The type of entity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the entity was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetEntityResult(GetEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntityResult(
            asset=self.asset,
            catalog_entry=self.catalog_entry,
            compatibility=self.compatibility,
            create_time=self.create_time,
            data_path=self.data_path,
            data_path_pattern=self.data_path_pattern,
            description=self.description,
            display_name=self.display_name,
            etag=self.etag,
            format=self.format,
            name=self.name,
            schema=self.schema,
            system=self.system,
            type=self.type,
            update_time=self.update_time)


def get_entity(entity_id: Optional[str] = None,
               lake_id: Optional[str] = None,
               location: Optional[str] = None,
               project: Optional[str] = None,
               view: Optional[str] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntityResult:
    """
    Get a metadata entity.
    """
    __args__ = dict()
    __args__['entityId'] = entity_id
    __args__['lakeId'] = lake_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['view'] = view
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dataplex/v1:getEntity', __args__, opts=opts, typ=GetEntityResult).value

    return AwaitableGetEntityResult(
        asset=__ret__.asset,
        catalog_entry=__ret__.catalog_entry,
        compatibility=__ret__.compatibility,
        create_time=__ret__.create_time,
        data_path=__ret__.data_path,
        data_path_pattern=__ret__.data_path_pattern,
        description=__ret__.description,
        display_name=__ret__.display_name,
        etag=__ret__.etag,
        format=__ret__.format,
        name=__ret__.name,
        schema=__ret__.schema,
        system=__ret__.system,
        type=__ret__.type,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_entity)
def get_entity_output(entity_id: Optional[pulumi.Input[str]] = None,
                      lake_id: Optional[pulumi.Input[str]] = None,
                      location: Optional[pulumi.Input[str]] = None,
                      project: Optional[pulumi.Input[Optional[str]]] = None,
                      view: Optional[pulumi.Input[Optional[str]]] = None,
                      zone: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEntityResult]:
    """
    Get a metadata entity.
    """
    ...
