# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ContentitemArgs', 'Contentitem']

@pulumi.input_type
class ContentitemArgs:
    def __init__(__self__, *,
                 data_text: pulumi.Input[str],
                 lake_id: pulumi.Input[str],
                 path: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 notebook: Optional[pulumi.Input['GoogleCloudDataplexV1ContentNotebookArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sql_script: Optional[pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptArgs']] = None,
                 validate_only: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Contentitem resource.
        :param pulumi.Input[str] data_text: Content data in string format.
        :param pulumi.Input[str] path: The path for the Content file, represented as directory structure. Unique within a lake. Limited to alphanumerics, hyphens, underscores, dots and slashes.
        :param pulumi.Input[str] description: Optional. Description of the content.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. User defined labels for the content.
        :param pulumi.Input['GoogleCloudDataplexV1ContentNotebookArgs'] notebook: Notebook related configurations.
        :param pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptArgs'] sql_script: Sql Script related configurations.
        :param pulumi.Input[str] validate_only: Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        pulumi.set(__self__, "data_text", data_text)
        pulumi.set(__self__, "lake_id", lake_id)
        pulumi.set(__self__, "path", path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if notebook is not None:
            pulumi.set(__self__, "notebook", notebook)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sql_script is not None:
            pulumi.set(__self__, "sql_script", sql_script)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="dataText")
    def data_text(self) -> pulumi.Input[str]:
        """
        Content data in string format.
        """
        return pulumi.get(self, "data_text")

    @data_text.setter
    def data_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_text", value)

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "lake_id")

    @lake_id.setter
    def lake_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "lake_id", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path for the Content file, represented as directory structure. Unique within a lake. Limited to alphanumerics, hyphens, underscores, dots and slashes.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the content.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. User defined labels for the content.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def notebook(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1ContentNotebookArgs']]:
        """
        Notebook related configurations.
        """
        return pulumi.get(self, "notebook")

    @notebook.setter
    def notebook(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1ContentNotebookArgs']]):
        pulumi.set(self, "notebook", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptArgs']]:
        """
        Sql Script related configurations.
        """
        return pulumi.get(self, "sql_script")

    @sql_script.setter
    def sql_script(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptArgs']]):
        pulumi.set(self, "sql_script", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validate_only", value)


class Contentitem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_text: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lake_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 notebook: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1ContentNotebookArgs']]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sql_script: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1ContentSqlScriptArgs']]] = None,
                 validate_only: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a content.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_text: Content data in string format.
        :param pulumi.Input[str] description: Optional. Description of the content.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. User defined labels for the content.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1ContentNotebookArgs']] notebook: Notebook related configurations.
        :param pulumi.Input[str] path: The path for the Content file, represented as directory structure. Unique within a lake. Limited to alphanumerics, hyphens, underscores, dots and slashes.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1ContentSqlScriptArgs']] sql_script: Sql Script related configurations.
        :param pulumi.Input[str] validate_only: Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentitemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a content.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ContentitemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentitemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_text: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lake_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 notebook: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1ContentNotebookArgs']]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sql_script: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1ContentSqlScriptArgs']]] = None,
                 validate_only: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentitemArgs.__new__(ContentitemArgs)

            if data_text is None and not opts.urn:
                raise TypeError("Missing required property 'data_text'")
            __props__.__dict__["data_text"] = data_text
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if lake_id is None and not opts.urn:
                raise TypeError("Missing required property 'lake_id'")
            __props__.__dict__["lake_id"] = lake_id
            __props__.__dict__["location"] = location
            __props__.__dict__["notebook"] = notebook
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["project"] = project
            __props__.__dict__["sql_script"] = sql_script
            __props__.__dict__["validate_only"] = validate_only
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["lake_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Contentitem, __self__).__init__(
            'google-native:dataplex/v1:Contentitem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Contentitem':
        """
        Get an existing Contentitem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ContentitemArgs.__new__(ContentitemArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["data_text"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["lake_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["notebook"] = None
        __props__.__dict__["path"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["sql_script"] = None
        __props__.__dict__["uid"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["validate_only"] = None
        return Contentitem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Content creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataText")
    def data_text(self) -> pulumi.Output[str]:
        """
        Content data in string format.
        """
        return pulumi.get(self, "data_text")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. Description of the content.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. User defined labels for the content.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The relative resource name of the content, of the form: projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notebook(self) -> pulumi.Output['outputs.GoogleCloudDataplexV1ContentNotebookResponse']:
        """
        Notebook related configurations.
        """
        return pulumi.get(self, "notebook")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The path for the Content file, represented as directory structure. Unique within a lake. Limited to alphanumerics, hyphens, underscores, dots and slashes.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> pulumi.Output['outputs.GoogleCloudDataplexV1ContentSqlScriptResponse']:
        """
        Sql Script related configurations.
        """
        return pulumi.get(self, "sql_script")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        System generated globally unique ID for the content. This ID will be different if the content is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time when the content was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        return pulumi.get(self, "validate_only")

