# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDatasetResult',
    'AwaitableGetDatasetResult',
    'get_dataset',
    'get_dataset_output',
]

@pulumi.output_type
class GetDatasetResult:
    def __init__(__self__, blocking_resources=None, create_time=None, data_item_count=None, description=None, display_name=None, input_configs=None, last_migrate_time=None, name=None):
        if blocking_resources and not isinstance(blocking_resources, list):
            raise TypeError("Expected argument 'blocking_resources' to be a list")
        pulumi.set(__self__, "blocking_resources", blocking_resources)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_item_count and not isinstance(data_item_count, str):
            raise TypeError("Expected argument 'data_item_count' to be a str")
        pulumi.set(__self__, "data_item_count", data_item_count)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if input_configs and not isinstance(input_configs, list):
            raise TypeError("Expected argument 'input_configs' to be a list")
        pulumi.set(__self__, "input_configs", input_configs)
        if last_migrate_time and not isinstance(last_migrate_time, str):
            raise TypeError("Expected argument 'last_migrate_time' to be a str")
        pulumi.set(__self__, "last_migrate_time", last_migrate_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="blockingResources")
    def blocking_resources(self) -> Sequence[str]:
        """
        The names of any related resources that are blocking changes to the dataset.
        """
        return pulumi.get(self, "blocking_resources")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time the dataset is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataItemCount")
    def data_item_count(self) -> str:
        """
        The number of data items in the dataset.
        """
        return pulumi.get(self, "data_item_count")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User-provided description of the annotation specification set. The description can be up to 10000 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the dataset. Maximum of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inputConfigs")
    def input_configs(self) -> Sequence['outputs.GoogleCloudDatalabelingV1beta1InputConfigResponse']:
        """
        This is populated with the original input configs where ImportData is called. It is available only after the clients import data to this dataset.
        """
        return pulumi.get(self, "input_configs")

    @property
    @pulumi.getter(name="lastMigrateTime")
    def last_migrate_time(self) -> str:
        """
        Last time that the Dataset is migrated to AI Platform V2. If any of the AnnotatedDataset is migrated, the last_migration_time in Dataset is also updated.
        """
        return pulumi.get(self, "last_migrate_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dataset resource name, format is: projects/{project_id}/datasets/{dataset_id}
        """
        return pulumi.get(self, "name")


class AwaitableGetDatasetResult(GetDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetResult(
            blocking_resources=self.blocking_resources,
            create_time=self.create_time,
            data_item_count=self.data_item_count,
            description=self.description,
            display_name=self.display_name,
            input_configs=self.input_configs,
            last_migrate_time=self.last_migrate_time,
            name=self.name)


def get_dataset(dataset_id: Optional[str] = None,
                project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetResult:
    """
    Gets dataset by resource name.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:datalabeling/v1beta1:getDataset', __args__, opts=opts, typ=GetDatasetResult).value

    return AwaitableGetDatasetResult(
        blocking_resources=__ret__.blocking_resources,
        create_time=__ret__.create_time,
        data_item_count=__ret__.data_item_count,
        description=__ret__.description,
        display_name=__ret__.display_name,
        input_configs=__ret__.input_configs,
        last_migrate_time=__ret__.last_migrate_time,
        name=__ret__.name)


@_utilities.lift_output_func(get_dataset)
def get_dataset_output(dataset_id: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatasetResult]:
    """
    Gets dataset by resource name.
    """
    ...
