# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EntryArgs', 'Entry']

@pulumi.input_type
class EntryArgs:
    def __init__(__self__, *,
                 entry_group_id: pulumi.Input[str],
                 entry_id: pulumi.Input[str],
                 business_context: Optional[pulumi.Input['GoogleCloudDatacatalogV1BusinessContextArgs']] = None,
                 data_source_connection_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs']] = None,
                 database_table_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fileset_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1FilesetSpecArgs']] = None,
                 fully_qualified_name: Optional[pulumi.Input[str]] = None,
                 gcs_fileset_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1GcsFilesetSpecArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_resource: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routine_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgs']] = None,
                 schema: Optional[pulumi.Input['GoogleCloudDatacatalogV1SchemaArgs']] = None,
                 source_system_timestamps: Optional[pulumi.Input['GoogleCloudDatacatalogV1SystemTimestampsArgs']] = None,
                 type: Optional[pulumi.Input['EntryType']] = None,
                 user_specified_system: Optional[pulumi.Input[str]] = None,
                 user_specified_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Entry resource.
        :param pulumi.Input[str] entry_id: Required. The ID of the entry to create. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores (_). The maximum size is 64 bytes when encoded in UTF-8.
        :param pulumi.Input['GoogleCloudDatacatalogV1BusinessContextArgs'] business_context: Business Context of the entry. Not supported for BigQuery datasets
        :param pulumi.Input['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs'] data_source_connection_spec: Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
        :param pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecArgs'] database_table_spec: Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
        :param pulumi.Input[str] description: Entry description that can consist of several sentences or paragraphs that describe entry contents. The description must not contain Unicode non-characters as well as C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). The maximum size is 2000 bytes when encoded in UTF-8. Default value is an empty string.
        :param pulumi.Input[str] display_name: Display name of an entry. The name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and can't start or end with spaces. The maximum size is 200 bytes when encoded in UTF-8. Default value is an empty string.
        :param pulumi.Input['GoogleCloudDatacatalogV1FilesetSpecArgs'] fileset_spec: Specification that applies to a fileset resource. Valid only for entries with the `FILESET` type.
        :param pulumi.Input[str] fully_qualified_name: Fully qualified name (FQN) of the resource. Set automatically for entries representing resources from synced systems. Settable only during creation and read-only afterwards. Can be used for search and lookup of the entries. FQNs take two forms: * For non-regionalized resources: `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
        :param pulumi.Input['GoogleCloudDatacatalogV1GcsFilesetSpecArgs'] gcs_fileset_spec: Specification that applies to a Cloud Storage fileset. Valid only for entries with the `FILESET` type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Cloud labels attached to the entry. In Data Catalog, you can create and modify labels attached only to custom entries. Synced entries have unmodifiable labels that come from the source system.
        :param pulumi.Input[str] linked_resource: The resource this metadata entry refers to. For Google Cloud Platform resources, `linked_resource` is the [Full Resource Name] (https://cloud.google.com/apis/design/resource_names#full_resource_name). For example, the `linked_resource` for a table resource from BigQuery is: `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}` Output only when the entry is one of the types in the `EntryType` enum. For entries with a `user_specified_type`, this field is optional and defaults to an empty string. The resource string must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), periods (.), colons (:), slashes (/), dashes (-), and hashes (#). The maximum size is 200 bytes when encoded in UTF-8.
        :param pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgs'] routine_spec: Specification that applies to a user-defined function or procedure. Valid only for entries with the `ROUTINE` type.
        :param pulumi.Input['GoogleCloudDatacatalogV1SchemaArgs'] schema: Schema of the entry. An entry might not have any schema attached to it.
        :param pulumi.Input['GoogleCloudDatacatalogV1SystemTimestampsArgs'] source_system_timestamps: Timestamps from the underlying resource, not from the Data Catalog entry. Output only when the entry has a type listed in the `EntryType` enum. For entries with `user_specified_type`, this field is optional and defaults to an empty timestamp.
        :param pulumi.Input['EntryType'] type: The type of the entry. Only used for entries with types listed in the `EntryType` enum. Currently, only `FILESET` enum value is allowed. All other entries created in Data Catalog must use the `user_specified_type`.
        :param pulumi.Input[str] user_specified_system: Indicates the entry's source system that Data Catalog doesn't automatically integrate with. The `user_specified_system` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        :param pulumi.Input[str] user_specified_type: Custom entry type that doesn't match any of the values allowed for input and listed in the `EntryType` enum. When creating an entry, first check the type values in the enum. If there are no appropriate types for the new entry, provide a custom value, for example, `my_special_type`. The `user_specified_type` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        """
        pulumi.set(__self__, "entry_group_id", entry_group_id)
        pulumi.set(__self__, "entry_id", entry_id)
        if business_context is not None:
            pulumi.set(__self__, "business_context", business_context)
        if data_source_connection_spec is not None:
            pulumi.set(__self__, "data_source_connection_spec", data_source_connection_spec)
        if database_table_spec is not None:
            pulumi.set(__self__, "database_table_spec", database_table_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fileset_spec is not None:
            pulumi.set(__self__, "fileset_spec", fileset_spec)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if gcs_fileset_spec is not None:
            pulumi.set(__self__, "gcs_fileset_spec", gcs_fileset_spec)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_resource is not None:
            pulumi.set(__self__, "linked_resource", linked_resource)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routine_spec is not None:
            pulumi.set(__self__, "routine_spec", routine_spec)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if source_system_timestamps is not None:
            pulumi.set(__self__, "source_system_timestamps", source_system_timestamps)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_specified_system is not None:
            pulumi.set(__self__, "user_specified_system", user_specified_system)
        if user_specified_type is not None:
            pulumi.set(__self__, "user_specified_type", user_specified_type)

    @property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "entry_group_id")

    @entry_group_id.setter
    def entry_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry_group_id", value)

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> pulumi.Input[str]:
        """
        Required. The ID of the entry to create. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores (_). The maximum size is 64 bytes when encoded in UTF-8.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry_id", value)

    @property
    @pulumi.getter(name="businessContext")
    def business_context(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1BusinessContextArgs']]:
        """
        Business Context of the entry. Not supported for BigQuery datasets
        """
        return pulumi.get(self, "business_context")

    @business_context.setter
    def business_context(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1BusinessContextArgs']]):
        pulumi.set(self, "business_context", value)

    @property
    @pulumi.getter(name="dataSourceConnectionSpec")
    def data_source_connection_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs']]:
        """
        Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
        """
        return pulumi.get(self, "data_source_connection_spec")

    @data_source_connection_spec.setter
    def data_source_connection_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs']]):
        pulumi.set(self, "data_source_connection_spec", value)

    @property
    @pulumi.getter(name="databaseTableSpec")
    def database_table_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecArgs']]:
        """
        Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
        """
        return pulumi.get(self, "database_table_spec")

    @database_table_spec.setter
    def database_table_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecArgs']]):
        pulumi.set(self, "database_table_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Entry description that can consist of several sentences or paragraphs that describe entry contents. The description must not contain Unicode non-characters as well as C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). The maximum size is 2000 bytes when encoded in UTF-8. Default value is an empty string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of an entry. The name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and can't start or end with spaces. The maximum size is 200 bytes when encoded in UTF-8. Default value is an empty string.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="filesetSpec")
    def fileset_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1FilesetSpecArgs']]:
        """
        Specification that applies to a fileset resource. Valid only for entries with the `FILESET` type.
        """
        return pulumi.get(self, "fileset_spec")

    @fileset_spec.setter
    def fileset_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1FilesetSpecArgs']]):
        pulumi.set(self, "fileset_spec", value)

    @property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified name (FQN) of the resource. Set automatically for entries representing resources from synced systems. Settable only during creation and read-only afterwards. Can be used for search and lookup of the entries. FQNs take two forms: * For non-regionalized resources: `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @property
    @pulumi.getter(name="gcsFilesetSpec")
    def gcs_fileset_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1GcsFilesetSpecArgs']]:
        """
        Specification that applies to a Cloud Storage fileset. Valid only for entries with the `FILESET` type.
        """
        return pulumi.get(self, "gcs_fileset_spec")

    @gcs_fileset_spec.setter
    def gcs_fileset_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1GcsFilesetSpecArgs']]):
        pulumi.set(self, "gcs_fileset_spec", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Cloud labels attached to the entry. In Data Catalog, you can create and modify labels attached only to custom entries. Synced entries have unmodifiable labels that come from the source system.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedResource")
    def linked_resource(self) -> Optional[pulumi.Input[str]]:
        """
        The resource this metadata entry refers to. For Google Cloud Platform resources, `linked_resource` is the [Full Resource Name] (https://cloud.google.com/apis/design/resource_names#full_resource_name). For example, the `linked_resource` for a table resource from BigQuery is: `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}` Output only when the entry is one of the types in the `EntryType` enum. For entries with a `user_specified_type`, this field is optional and defaults to an empty string. The resource string must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), periods (.), colons (:), slashes (/), dashes (-), and hashes (#). The maximum size is 200 bytes when encoded in UTF-8.
        """
        return pulumi.get(self, "linked_resource")

    @linked_resource.setter
    def linked_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_resource", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="routineSpec")
    def routine_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgs']]:
        """
        Specification that applies to a user-defined function or procedure. Valid only for entries with the `ROUTINE` type.
        """
        return pulumi.get(self, "routine_spec")

    @routine_spec.setter
    def routine_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgs']]):
        pulumi.set(self, "routine_spec", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1SchemaArgs']]:
        """
        Schema of the entry. An entry might not have any schema attached to it.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1SchemaArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="sourceSystemTimestamps")
    def source_system_timestamps(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1SystemTimestampsArgs']]:
        """
        Timestamps from the underlying resource, not from the Data Catalog entry. Output only when the entry has a type listed in the `EntryType` enum. For entries with `user_specified_type`, this field is optional and defaults to an empty timestamp.
        """
        return pulumi.get(self, "source_system_timestamps")

    @source_system_timestamps.setter
    def source_system_timestamps(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1SystemTimestampsArgs']]):
        pulumi.set(self, "source_system_timestamps", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['EntryType']]:
        """
        The type of the entry. Only used for entries with types listed in the `EntryType` enum. Currently, only `FILESET` enum value is allowed. All other entries created in Data Catalog must use the `user_specified_type`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['EntryType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userSpecifiedSystem")
    def user_specified_system(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the entry's source system that Data Catalog doesn't automatically integrate with. The `user_specified_system` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        """
        return pulumi.get(self, "user_specified_system")

    @user_specified_system.setter
    def user_specified_system(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_specified_system", value)

    @property
    @pulumi.getter(name="userSpecifiedType")
    def user_specified_type(self) -> Optional[pulumi.Input[str]]:
        """
        Custom entry type that doesn't match any of the values allowed for input and listed in the `EntryType` enum. When creating an entry, first check the type values in the enum. If there are no appropriate types for the new entry, provide a custom value, for example, `my_special_type`. The `user_specified_type` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        """
        return pulumi.get(self, "user_specified_type")

    @user_specified_type.setter
    def user_specified_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_specified_type", value)


class Entry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_context: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1BusinessContextArgs']]] = None,
                 data_source_connection_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs']]] = None,
                 database_table_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1DatabaseTableSpecArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entry_group_id: Optional[pulumi.Input[str]] = None,
                 entry_id: Optional[pulumi.Input[str]] = None,
                 fileset_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1FilesetSpecArgs']]] = None,
                 fully_qualified_name: Optional[pulumi.Input[str]] = None,
                 gcs_fileset_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1GcsFilesetSpecArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_resource: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routine_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1RoutineSpecArgs']]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1SchemaArgs']]] = None,
                 source_system_timestamps: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1SystemTimestampsArgs']]] = None,
                 type: Optional[pulumi.Input['EntryType']] = None,
                 user_specified_system: Optional[pulumi.Input[str]] = None,
                 user_specified_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an entry. You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM', or custom types. Data Catalog automatically creates entries with other types during metadata ingestion from integrated systems. You must enable the Data Catalog API in the project identified by the `parent` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project). An entry group can have a maximum of 100,000 entries.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1BusinessContextArgs']] business_context: Business Context of the entry. Not supported for BigQuery datasets
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs']] data_source_connection_spec: Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1DatabaseTableSpecArgs']] database_table_spec: Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
        :param pulumi.Input[str] description: Entry description that can consist of several sentences or paragraphs that describe entry contents. The description must not contain Unicode non-characters as well as C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). The maximum size is 2000 bytes when encoded in UTF-8. Default value is an empty string.
        :param pulumi.Input[str] display_name: Display name of an entry. The name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and can't start or end with spaces. The maximum size is 200 bytes when encoded in UTF-8. Default value is an empty string.
        :param pulumi.Input[str] entry_id: Required. The ID of the entry to create. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores (_). The maximum size is 64 bytes when encoded in UTF-8.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1FilesetSpecArgs']] fileset_spec: Specification that applies to a fileset resource. Valid only for entries with the `FILESET` type.
        :param pulumi.Input[str] fully_qualified_name: Fully qualified name (FQN) of the resource. Set automatically for entries representing resources from synced systems. Settable only during creation and read-only afterwards. Can be used for search and lookup of the entries. FQNs take two forms: * For non-regionalized resources: `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1GcsFilesetSpecArgs']] gcs_fileset_spec: Specification that applies to a Cloud Storage fileset. Valid only for entries with the `FILESET` type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Cloud labels attached to the entry. In Data Catalog, you can create and modify labels attached only to custom entries. Synced entries have unmodifiable labels that come from the source system.
        :param pulumi.Input[str] linked_resource: The resource this metadata entry refers to. For Google Cloud Platform resources, `linked_resource` is the [Full Resource Name] (https://cloud.google.com/apis/design/resource_names#full_resource_name). For example, the `linked_resource` for a table resource from BigQuery is: `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}` Output only when the entry is one of the types in the `EntryType` enum. For entries with a `user_specified_type`, this field is optional and defaults to an empty string. The resource string must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), periods (.), colons (:), slashes (/), dashes (-), and hashes (#). The maximum size is 200 bytes when encoded in UTF-8.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1RoutineSpecArgs']] routine_spec: Specification that applies to a user-defined function or procedure. Valid only for entries with the `ROUTINE` type.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1SchemaArgs']] schema: Schema of the entry. An entry might not have any schema attached to it.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1SystemTimestampsArgs']] source_system_timestamps: Timestamps from the underlying resource, not from the Data Catalog entry. Output only when the entry has a type listed in the `EntryType` enum. For entries with `user_specified_type`, this field is optional and defaults to an empty timestamp.
        :param pulumi.Input['EntryType'] type: The type of the entry. Only used for entries with types listed in the `EntryType` enum. Currently, only `FILESET` enum value is allowed. All other entries created in Data Catalog must use the `user_specified_type`.
        :param pulumi.Input[str] user_specified_system: Indicates the entry's source system that Data Catalog doesn't automatically integrate with. The `user_specified_system` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        :param pulumi.Input[str] user_specified_type: Custom entry type that doesn't match any of the values allowed for input and listed in the `EntryType` enum. When creating an entry, first check the type values in the enum. If there are no appropriate types for the new entry, provide a custom value, for example, `my_special_type`. The `user_specified_type` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an entry. You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM', or custom types. Data Catalog automatically creates entries with other types during metadata ingestion from integrated systems. You must enable the Data Catalog API in the project identified by the `parent` parameter. For more information, see [Data Catalog resource project](https://cloud.google.com/data-catalog/docs/concepts/resource-project). An entry group can have a maximum of 100,000 entries.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param EntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_context: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1BusinessContextArgs']]] = None,
                 data_source_connection_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs']]] = None,
                 database_table_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1DatabaseTableSpecArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entry_group_id: Optional[pulumi.Input[str]] = None,
                 entry_id: Optional[pulumi.Input[str]] = None,
                 fileset_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1FilesetSpecArgs']]] = None,
                 fully_qualified_name: Optional[pulumi.Input[str]] = None,
                 gcs_fileset_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1GcsFilesetSpecArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_resource: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routine_spec: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1RoutineSpecArgs']]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1SchemaArgs']]] = None,
                 source_system_timestamps: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatacatalogV1SystemTimestampsArgs']]] = None,
                 type: Optional[pulumi.Input['EntryType']] = None,
                 user_specified_system: Optional[pulumi.Input[str]] = None,
                 user_specified_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntryArgs.__new__(EntryArgs)

            __props__.__dict__["business_context"] = business_context
            __props__.__dict__["data_source_connection_spec"] = data_source_connection_spec
            __props__.__dict__["database_table_spec"] = database_table_spec
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if entry_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'entry_group_id'")
            __props__.__dict__["entry_group_id"] = entry_group_id
            if entry_id is None and not opts.urn:
                raise TypeError("Missing required property 'entry_id'")
            __props__.__dict__["entry_id"] = entry_id
            __props__.__dict__["fileset_spec"] = fileset_spec
            __props__.__dict__["fully_qualified_name"] = fully_qualified_name
            __props__.__dict__["gcs_fileset_spec"] = gcs_fileset_spec
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linked_resource"] = linked_resource
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["routine_spec"] = routine_spec
            __props__.__dict__["schema"] = schema
            __props__.__dict__["source_system_timestamps"] = source_system_timestamps
            __props__.__dict__["type"] = type
            __props__.__dict__["user_specified_system"] = user_specified_system
            __props__.__dict__["user_specified_type"] = user_specified_type
            __props__.__dict__["bigquery_date_sharded_spec"] = None
            __props__.__dict__["bigquery_table_spec"] = None
            __props__.__dict__["data_source"] = None
            __props__.__dict__["integrated_system"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["personal_details"] = None
            __props__.__dict__["usage_signal"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["entry_group_id", "entry_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Entry, __self__).__init__(
            'google-native:datacatalog/v1:Entry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Entry':
        """
        Get an existing Entry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EntryArgs.__new__(EntryArgs)

        __props__.__dict__["bigquery_date_sharded_spec"] = None
        __props__.__dict__["bigquery_table_spec"] = None
        __props__.__dict__["business_context"] = None
        __props__.__dict__["data_source"] = None
        __props__.__dict__["data_source_connection_spec"] = None
        __props__.__dict__["database_table_spec"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["entry_group_id"] = None
        __props__.__dict__["entry_id"] = None
        __props__.__dict__["fileset_spec"] = None
        __props__.__dict__["fully_qualified_name"] = None
        __props__.__dict__["gcs_fileset_spec"] = None
        __props__.__dict__["integrated_system"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["linked_resource"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["personal_details"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["routine_spec"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["source_system_timestamps"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["usage_signal"] = None
        __props__.__dict__["user_specified_system"] = None
        __props__.__dict__["user_specified_type"] = None
        return Entry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigqueryDateShardedSpec")
    def bigquery_date_sharded_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1BigQueryDateShardedSpecResponse']:
        """
        Specification for a group of BigQuery tables with the `[prefix]YYYYMMDD` name pattern. For more information, see [Introduction to partitioned tables] (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
        """
        return pulumi.get(self, "bigquery_date_sharded_spec")

    @property
    @pulumi.getter(name="bigqueryTableSpec")
    def bigquery_table_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1BigQueryTableSpecResponse']:
        """
        Specification that applies to a BigQuery table. Valid only for entries with the `TABLE` type.
        """
        return pulumi.get(self, "bigquery_table_spec")

    @property
    @pulumi.getter(name="businessContext")
    def business_context(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1BusinessContextResponse']:
        """
        Business Context of the entry. Not supported for BigQuery datasets
        """
        return pulumi.get(self, "business_context")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1DataSourceResponse']:
        """
        Physical location of the entry.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="dataSourceConnectionSpec")
    def data_source_connection_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1DataSourceConnectionSpecResponse']:
        """
        Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
        """
        return pulumi.get(self, "data_source_connection_spec")

    @property
    @pulumi.getter(name="databaseTableSpec")
    def database_table_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1DatabaseTableSpecResponse']:
        """
        Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
        """
        return pulumi.get(self, "database_table_spec")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Entry description that can consist of several sentences or paragraphs that describe entry contents. The description must not contain Unicode non-characters as well as C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). The maximum size is 2000 bytes when encoded in UTF-8. Default value is an empty string.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name of an entry. The name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and can't start or end with spaces. The maximum size is 200 bytes when encoded in UTF-8. Default value is an empty string.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "entry_group_id")

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> pulumi.Output[str]:
        """
        Required. The ID of the entry to create. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores (_). The maximum size is 64 bytes when encoded in UTF-8.
        """
        return pulumi.get(self, "entry_id")

    @property
    @pulumi.getter(name="filesetSpec")
    def fileset_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1FilesetSpecResponse']:
        """
        Specification that applies to a fileset resource. Valid only for entries with the `FILESET` type.
        """
        return pulumi.get(self, "fileset_spec")

    @property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[str]:
        """
        Fully qualified name (FQN) of the resource. Set automatically for entries representing resources from synced systems. Settable only during creation and read-only afterwards. Can be used for search and lookup of the entries. FQNs take two forms: * For non-regionalized resources: `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` * For regionalized resources: `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}` Example for a DPMS table: `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
        """
        return pulumi.get(self, "fully_qualified_name")

    @property
    @pulumi.getter(name="gcsFilesetSpec")
    def gcs_fileset_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1GcsFilesetSpecResponse']:
        """
        Specification that applies to a Cloud Storage fileset. Valid only for entries with the `FILESET` type.
        """
        return pulumi.get(self, "gcs_fileset_spec")

    @property
    @pulumi.getter(name="integratedSystem")
    def integrated_system(self) -> pulumi.Output[str]:
        """
        Indicates the entry's source system that Data Catalog integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
        """
        return pulumi.get(self, "integrated_system")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Cloud labels attached to the entry. In Data Catalog, you can create and modify labels attached only to custom entries. Synced entries have unmodifiable labels that come from the source system.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linkedResource")
    def linked_resource(self) -> pulumi.Output[str]:
        """
        The resource this metadata entry refers to. For Google Cloud Platform resources, `linked_resource` is the [Full Resource Name] (https://cloud.google.com/apis/design/resource_names#full_resource_name). For example, the `linked_resource` for a table resource from BigQuery is: `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}` Output only when the entry is one of the types in the `EntryType` enum. For entries with a `user_specified_type`, this field is optional and defaults to an empty string. The resource string must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), periods (.), colons (:), slashes (/), dashes (-), and hashes (#). The maximum size is 200 bytes when encoded in UTF-8.
        """
        return pulumi.get(self, "linked_resource")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of an entry in URL format. Note: The entry itself and its child resources might not be stored in the location specified in its name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="personalDetails")
    def personal_details(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1PersonalDetailsResponse']:
        """
        Additional information related to the entry. Private to the current user.
        """
        return pulumi.get(self, "personal_details")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="routineSpec")
    def routine_spec(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1RoutineSpecResponse']:
        """
        Specification that applies to a user-defined function or procedure. Valid only for entries with the `ROUTINE` type.
        """
        return pulumi.get(self, "routine_spec")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1SchemaResponse']:
        """
        Schema of the entry. An entry might not have any schema attached to it.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="sourceSystemTimestamps")
    def source_system_timestamps(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1SystemTimestampsResponse']:
        """
        Timestamps from the underlying resource, not from the Data Catalog entry. Output only when the entry has a type listed in the `EntryType` enum. For entries with `user_specified_type`, this field is optional and defaults to an empty timestamp.
        """
        return pulumi.get(self, "source_system_timestamps")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the entry. Only used for entries with types listed in the `EntryType` enum. Currently, only `FILESET` enum value is allowed. All other entries created in Data Catalog must use the `user_specified_type`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usageSignal")
    def usage_signal(self) -> pulumi.Output['outputs.GoogleCloudDatacatalogV1UsageSignalResponse']:
        """
        Resource usage statistics.
        """
        return pulumi.get(self, "usage_signal")

    @property
    @pulumi.getter(name="userSpecifiedSystem")
    def user_specified_system(self) -> pulumi.Output[str]:
        """
        Indicates the entry's source system that Data Catalog doesn't automatically integrate with. The `user_specified_system` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        """
        return pulumi.get(self, "user_specified_system")

    @property
    @pulumi.getter(name="userSpecifiedType")
    def user_specified_type(self) -> pulumi.Output[str]:
        """
        Custom entry type that doesn't match any of the values allowed for input and listed in the `EntryType` enum. When creating an entry, first check the type values in the enum. If there are no appropriate types for the new entry, provide a custom value, for example, `my_special_type`. The `user_specified_type` string has the following limitations: * Is case insensitive. * Must begin with a letter or underscore. * Can only contain letters, numbers, and underscores. * Must be at least 1 character and at most 64 characters long.
        """
        return pulumi.get(self, "user_specified_type")

