# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'BindingArgs',
    'ExprArgs',
    'GoogleCloudDatacatalogV1BigQueryConnectionSpecArgs',
    'GoogleCloudDatacatalogV1BigQueryRoutineSpecArgs',
    'GoogleCloudDatacatalogV1BusinessContextArgs',
    'GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecArgs',
    'GoogleCloudDatacatalogV1ColumnSchemaArgs',
    'GoogleCloudDatacatalogV1ContactsPersonArgs',
    'GoogleCloudDatacatalogV1ContactsArgs',
    'GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs',
    'GoogleCloudDatacatalogV1DatabaseTableSpecArgs',
    'GoogleCloudDatacatalogV1DataplexFilesetSpecArgs',
    'GoogleCloudDatacatalogV1DataplexSpecArgs',
    'GoogleCloudDatacatalogV1EntryOverviewArgs',
    'GoogleCloudDatacatalogV1FilesetSpecArgs',
    'GoogleCloudDatacatalogV1GcsFilesetSpecArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaAvroSchemaArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaCsvSchemaArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaOrcSchemaArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaParquetSchemaArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchemaArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaThriftSchemaArgs',
    'GoogleCloudDatacatalogV1PhysicalSchemaArgs',
    'GoogleCloudDatacatalogV1RoutineSpecArgumentArgs',
    'GoogleCloudDatacatalogV1RoutineSpecArgs',
    'GoogleCloudDatacatalogV1SchemaArgs',
    'GoogleCloudDatacatalogV1SystemTimestampsArgs',
]

@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1BigQueryConnectionSpecArgs:
    def __init__(__self__, *,
                 cloud_sql: Optional[pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecArgs']] = None,
                 connection_type: Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecConnectionType']] = None,
                 has_credential: Optional[pulumi.Input[bool]] = None):
        """
        Specification for the BigQuery connection.
        :param pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecArgs'] cloud_sql: Specification for the BigQuery connection to a Cloud SQL instance.
        :param pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecConnectionType'] connection_type: The type of the BigQuery connection.
        :param pulumi.Input[bool] has_credential: True if there are credentials attached to the BigQuery connection; false otherwise.
        """
        if cloud_sql is not None:
            pulumi.set(__self__, "cloud_sql", cloud_sql)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if has_credential is not None:
            pulumi.set(__self__, "has_credential", has_credential)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecArgs']]:
        """
        Specification for the BigQuery connection to a Cloud SQL instance.
        """
        return pulumi.get(self, "cloud_sql")

    @cloud_sql.setter
    def cloud_sql(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecArgs']]):
        pulumi.set(self, "cloud_sql", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecConnectionType']]:
        """
        The type of the BigQuery connection.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecConnectionType']]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> Optional[pulumi.Input[bool]]:
        """
        True if there are credentials attached to the BigQuery connection; false otherwise.
        """
        return pulumi.get(self, "has_credential")

    @has_credential.setter
    def has_credential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_credential", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1BigQueryRoutineSpecArgs:
    def __init__(__self__, *,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Fields specific for BigQuery routines.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_libraries: Paths of the imported libraries.
        """
        if imported_libraries is not None:
            pulumi.set(__self__, "imported_libraries", imported_libraries)

    @property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Paths of the imported libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @imported_libraries.setter
    def imported_libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "imported_libraries", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1BusinessContextArgs:
    def __init__(__self__, *,
                 contacts: Optional[pulumi.Input['GoogleCloudDatacatalogV1ContactsArgs']] = None,
                 entry_overview: Optional[pulumi.Input['GoogleCloudDatacatalogV1EntryOverviewArgs']] = None):
        """
        Business Context of the entry.
        :param pulumi.Input['GoogleCloudDatacatalogV1ContactsArgs'] contacts: Contact people for the entry.
        :param pulumi.Input['GoogleCloudDatacatalogV1EntryOverviewArgs'] entry_overview: Entry overview fields for rich text descriptions of entries.
        """
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if entry_overview is not None:
            pulumi.set(__self__, "entry_overview", entry_overview)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1ContactsArgs']]:
        """
        Contact people for the entry.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1ContactsArgs']]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="entryOverview")
    def entry_overview(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1EntryOverviewArgs']]:
        """
        Entry overview fields for rich text descriptions of entries.
        """
        return pulumi.get(self, "entry_overview")

    @entry_overview.setter
    def entry_overview(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1EntryOverviewArgs']]):
        pulumi.set(self, "entry_overview", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecArgs:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecType']] = None):
        """
        Specification for the BigQuery connection to a Cloud SQL instance.
        :param pulumi.Input[str] database: Database name.
        :param pulumi.Input[str] instance_id: Cloud SQL instance ID in the format of `project:location:instance`.
        :param pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecType'] type: Type of the Cloud SQL database.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud SQL instance ID in the format of `project:location:instance`.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecType']]:
        """
        Type of the Cloud SQL database.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1ColumnSchemaArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 subcolumns: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]]] = None):
        """
        A column within a schema. Columns can be nested inside other columns.
        :param pulumi.Input[str] column: Name of the column. Must be a UTF-8 string without dots (.). The maximum size is 64 bytes.
        :param pulumi.Input[str] type: Type of the column. Must be a UTF-8 string with the maximum size of 128 bytes.
        :param pulumi.Input[str] description: Optional. Description of the column. Default value is an empty string. The description must be a UTF-8 string with the maximum size of 2000 bytes.
        :param pulumi.Input[str] mode: Optional. A column's mode indicates whether values in this column are required, nullable, or repeated. Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported. Default mode is `NULLABLE`.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]] subcolumns: Optional. Schema of sub-columns. A column can have zero or more sub-columns.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if subcolumns is not None:
            pulumi.set(__self__, "subcolumns", subcolumns)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[str]:
        """
        Name of the column. Must be a UTF-8 string without dots (.). The maximum size is 64 bytes.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[str]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the column. Must be a UTF-8 string with the maximum size of 128 bytes.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the column. Default value is an empty string. The description must be a UTF-8 string with the maximum size of 2000 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A column's mode indicates whether values in this column are required, nullable, or repeated. Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported. Default mode is `NULLABLE`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def subcolumns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]]]:
        """
        Optional. Schema of sub-columns. A column can have zero or more sub-columns.
        """
        return pulumi.get(self, "subcolumns")

    @subcolumns.setter
    def subcolumns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]]]):
        pulumi.set(self, "subcolumns", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1ContactsPersonArgs:
    def __init__(__self__, *,
                 designation: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None):
        """
        A contact person for the entry.
        :param pulumi.Input[str] designation: Designation of the person, for example, Data Steward.
        :param pulumi.Input[str] email: Email of the person in the format of `john.doe@xyz`, ``, or `John Doe`.
        """
        if designation is not None:
            pulumi.set(__self__, "designation", designation)
        if email is not None:
            pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def designation(self) -> Optional[pulumi.Input[str]]:
        """
        Designation of the person, for example, Data Steward.
        """
        return pulumi.get(self, "designation")

    @designation.setter
    def designation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "designation", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email of the person in the format of `john.doe@xyz`, ``, or `John Doe`.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1ContactsArgs:
    def __init__(__self__, *,
                 people: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ContactsPersonArgs']]]] = None):
        """
        Contact people for the entry.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ContactsPersonArgs']]] people: The list of contact people for the entry.
        """
        if people is not None:
            pulumi.set(__self__, "people", people)

    @property
    @pulumi.getter
    def people(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ContactsPersonArgs']]]]:
        """
        The list of contact people for the entry.
        """
        return pulumi.get(self, "people")

    @people.setter
    def people(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ContactsPersonArgs']]]]):
        pulumi.set(self, "people", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1DataSourceConnectionSpecArgs:
    def __init__(__self__, *,
                 bigquery_connection_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecArgs']] = None):
        """
        Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
        :param pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecArgs'] bigquery_connection_spec: Fields specific to BigQuery connections.
        """
        if bigquery_connection_spec is not None:
            pulumi.set(__self__, "bigquery_connection_spec", bigquery_connection_spec)

    @property
    @pulumi.getter(name="bigqueryConnectionSpec")
    def bigquery_connection_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecArgs']]:
        """
        Fields specific to BigQuery connections.
        """
        return pulumi.get(self, "bigquery_connection_spec")

    @bigquery_connection_spec.setter
    def bigquery_connection_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryConnectionSpecArgs']]):
        pulumi.set(self, "bigquery_connection_spec", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1DatabaseTableSpecArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecType']] = None):
        """
        Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
        :param pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecType'] type: Type of this table.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecType']]:
        """
        Type of this table.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1DatabaseTableSpecType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1DataplexFilesetSpecArgs:
    def __init__(__self__, *,
                 dataplex_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1DataplexSpecArgs']] = None):
        """
        Entry specyfication for a Dataplex fileset.
        :param pulumi.Input['GoogleCloudDatacatalogV1DataplexSpecArgs'] dataplex_spec: Common Dataplex fields.
        """
        if dataplex_spec is not None:
            pulumi.set(__self__, "dataplex_spec", dataplex_spec)

    @property
    @pulumi.getter(name="dataplexSpec")
    def dataplex_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1DataplexSpecArgs']]:
        """
        Common Dataplex fields.
        """
        return pulumi.get(self, "dataplex_spec")

    @dataplex_spec.setter
    def dataplex_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1DataplexSpecArgs']]):
        pulumi.set(self, "dataplex_spec", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1DataplexSpecArgs:
    def __init__(__self__, *,
                 asset: Optional[pulumi.Input[str]] = None,
                 compression_format: Optional[pulumi.Input[str]] = None,
                 data_format: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Common Dataplex fields.
        :param pulumi.Input[str] asset: Fully qualified resource name of an asset in Dataplex, to which the underlying data source (Cloud Storage bucket or BigQuery dataset) of the entity is attached.
        :param pulumi.Input[str] compression_format: Compression format of the data, e.g., zip, gzip etc.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaArgs'] data_format: Format of the data.
        :param pulumi.Input[str] project: Project ID of the underlying Cloud Storage or BigQuery data. Note that this may not be the same project as the correspondingly Dataplex lake / zone / asset.
        """
        if asset is not None:
            pulumi.set(__self__, "asset", asset)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def asset(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource name of an asset in Dataplex, to which the underlying data source (Cloud Storage bucket or BigQuery dataset) of the entity is attached.
        """
        return pulumi.get(self, "asset")

    @asset.setter
    def asset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset", value)

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional[pulumi.Input[str]]:
        """
        Compression format of the data, e.g., zip, gzip etc.
        """
        return pulumi.get(self, "compression_format")

    @compression_format.setter
    def compression_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_format", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaArgs']]:
        """
        Format of the data.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaArgs']]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project ID of the underlying Cloud Storage or BigQuery data. Note that this may not be the same project as the correspondingly Dataplex lake / zone / asset.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1EntryOverviewArgs:
    def __init__(__self__, *,
                 overview: Optional[pulumi.Input[str]] = None):
        """
        Entry overview fields for rich text descriptions of entries.
        :param pulumi.Input[str] overview: Entry overview with support for rich text. The overview must only contain Unicode characters, and should be formatted using HTML. The maximum length is 10 MiB as this value holds HTML descriptions including encoded images. The maximum length of the text without images is 100 KiB.
        """
        if overview is not None:
            pulumi.set(__self__, "overview", overview)

    @property
    @pulumi.getter
    def overview(self) -> Optional[pulumi.Input[str]]:
        """
        Entry overview with support for rich text. The overview must only contain Unicode characters, and should be formatted using HTML. The maximum length is 10 MiB as this value holds HTML descriptions including encoded images. The maximum length of the text without images is 100 KiB.
        """
        return pulumi.get(self, "overview")

    @overview.setter
    def overview(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overview", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1FilesetSpecArgs:
    def __init__(__self__, *,
                 dataplex_fileset: Optional[pulumi.Input['GoogleCloudDatacatalogV1DataplexFilesetSpecArgs']] = None):
        """
        Specification that applies to a fileset. Valid only for entries with the 'FILESET' type.
        :param pulumi.Input['GoogleCloudDatacatalogV1DataplexFilesetSpecArgs'] dataplex_fileset: Fields specific to a Dataplex fileset and present only in the Dataplex fileset entries.
        """
        if dataplex_fileset is not None:
            pulumi.set(__self__, "dataplex_fileset", dataplex_fileset)

    @property
    @pulumi.getter(name="dataplexFileset")
    def dataplex_fileset(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1DataplexFilesetSpecArgs']]:
        """
        Fields specific to a Dataplex fileset and present only in the Dataplex fileset entries.
        """
        return pulumi.get(self, "dataplex_fileset")

    @dataplex_fileset.setter
    def dataplex_fileset(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1DataplexFilesetSpecArgs']]):
        pulumi.set(self, "dataplex_fileset", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1GcsFilesetSpecArgs:
    def __init__(__self__, *,
                 file_patterns: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Describes a Cloud Storage fileset entry.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_patterns: Patterns to identify a set of files in Google Cloud Storage. For more information, see [Wildcard Names] (https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames). Note: Currently, bucket wildcards are not supported. Examples of valid `file_patterns`: * `gs://bucket_name/dir/*`: matches all files in `bucket_name/dir` directory * `gs://bucket_name/dir/**`: matches all files in `bucket_name/dir` and all subdirectories * `gs://bucket_name/file*`: matches files prefixed by `file` in `bucket_name` * `gs://bucket_name/??.txt`: matches files with two characters followed by `.txt` in `bucket_name` * `gs://bucket_name/[aeiou].txt`: matches files that contain a single vowel character followed by `.txt` in `bucket_name` * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ... or `m` followed by `.txt` in `bucket_name` * `gs://bucket_name/a/*/b`: matches all files in `bucket_name` that match the `a/*/b` pattern, such as `a/c/b`, `a/d/b` * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt` You can combine wildcards to match complex sets of files, for example: `gs://bucket_name/[a-m]??.j*g`
        """
        pulumi.set(__self__, "file_patterns", file_patterns)

    @property
    @pulumi.getter(name="filePatterns")
    def file_patterns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Patterns to identify a set of files in Google Cloud Storage. For more information, see [Wildcard Names] (https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames). Note: Currently, bucket wildcards are not supported. Examples of valid `file_patterns`: * `gs://bucket_name/dir/*`: matches all files in `bucket_name/dir` directory * `gs://bucket_name/dir/**`: matches all files in `bucket_name/dir` and all subdirectories * `gs://bucket_name/file*`: matches files prefixed by `file` in `bucket_name` * `gs://bucket_name/??.txt`: matches files with two characters followed by `.txt` in `bucket_name` * `gs://bucket_name/[aeiou].txt`: matches files that contain a single vowel character followed by `.txt` in `bucket_name` * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ... or `m` followed by `.txt` in `bucket_name` * `gs://bucket_name/a/*/b`: matches all files in `bucket_name` that match the `a/*/b` pattern, such as `a/c/b`, `a/d/b` * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt` You can combine wildcards to match complex sets of files, for example: `gs://bucket_name/[a-m]??.j*g`
        """
        return pulumi.get(self, "file_patterns")

    @file_patterns.setter
    def file_patterns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "file_patterns", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaAvroSchemaArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Schema in Avro JSON format.
        :param pulumi.Input[str] text: JSON source of the Avro schema.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        JSON source of the Avro schema.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaCsvSchemaArgs:
    def __init__(__self__):
        """
        Marks a CSV-encoded data source.
        """
        pass


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaOrcSchemaArgs:
    def __init__(__self__):
        """
        Marks an ORC-encoded data source.
        """
        pass


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaParquetSchemaArgs:
    def __init__(__self__):
        """
        Marks a Parquet-encoded data source.
        """
        pass


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchemaArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Schema in protocol buffer format.
        :param pulumi.Input[str] text: Protocol buffer source of the schema.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol buffer source of the schema.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaThriftSchemaArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Schema in Thrift format.
        :param pulumi.Input[str] text: Thrift IDL source of the schema.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Thrift IDL source of the schema.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1PhysicalSchemaArgs:
    def __init__(__self__, *,
                 avro: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaAvroSchemaArgs']] = None,
                 csv: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaCsvSchemaArgs']] = None,
                 orc: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaOrcSchemaArgs']] = None,
                 parquet: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaParquetSchemaArgs']] = None,
                 protobuf: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchemaArgs']] = None,
                 thrift: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaThriftSchemaArgs']] = None):
        """
        Native schema used by a resource represented as an entry. Used by query engines for deserializing and parsing source data.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaAvroSchemaArgs'] avro: Schema in Avro JSON format.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaCsvSchemaArgs'] csv: Marks a CSV-encoded data source.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaOrcSchemaArgs'] orc: Marks an ORC-encoded data source.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaParquetSchemaArgs'] parquet: Marks a Parquet-encoded data source.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchemaArgs'] protobuf: Schema in protocol buffer format.
        :param pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaThriftSchemaArgs'] thrift: Schema in Thrift format.
        """
        if avro is not None:
            pulumi.set(__self__, "avro", avro)
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if orc is not None:
            pulumi.set(__self__, "orc", orc)
        if parquet is not None:
            pulumi.set(__self__, "parquet", parquet)
        if protobuf is not None:
            pulumi.set(__self__, "protobuf", protobuf)
        if thrift is not None:
            pulumi.set(__self__, "thrift", thrift)

    @property
    @pulumi.getter
    def avro(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaAvroSchemaArgs']]:
        """
        Schema in Avro JSON format.
        """
        return pulumi.get(self, "avro")

    @avro.setter
    def avro(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaAvroSchemaArgs']]):
        pulumi.set(self, "avro", value)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaCsvSchemaArgs']]:
        """
        Marks a CSV-encoded data source.
        """
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaCsvSchemaArgs']]):
        pulumi.set(self, "csv", value)

    @property
    @pulumi.getter
    def orc(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaOrcSchemaArgs']]:
        """
        Marks an ORC-encoded data source.
        """
        return pulumi.get(self, "orc")

    @orc.setter
    def orc(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaOrcSchemaArgs']]):
        pulumi.set(self, "orc", value)

    @property
    @pulumi.getter
    def parquet(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaParquetSchemaArgs']]:
        """
        Marks a Parquet-encoded data source.
        """
        return pulumi.get(self, "parquet")

    @parquet.setter
    def parquet(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaParquetSchemaArgs']]):
        pulumi.set(self, "parquet", value)

    @property
    @pulumi.getter
    def protobuf(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchemaArgs']]:
        """
        Schema in protocol buffer format.
        """
        return pulumi.get(self, "protobuf")

    @protobuf.setter
    def protobuf(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaProtobufSchemaArgs']]):
        pulumi.set(self, "protobuf", value)

    @property
    @pulumi.getter
    def thrift(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaThriftSchemaArgs']]:
        """
        Schema in Thrift format.
        """
        return pulumi.get(self, "thrift")

    @thrift.setter
    def thrift(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1PhysicalSchemaThriftSchemaArgs']]):
        pulumi.set(self, "thrift", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1RoutineSpecArgumentArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentMode']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input or output argument of a function or stored procedure.
        :param pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentMode'] mode: Specifies whether the argument is input or output.
        :param pulumi.Input[str] name: The name of the argument. A return argument of a function might not have a name.
        :param pulumi.Input[str] type: Type of the argument. The exact value depends on the source system and the language.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentMode']]:
        """
        Specifies whether the argument is input or output.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the argument. A return argument of a function might not have a name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the argument. The exact value depends on the source system and the language.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1RoutineSpecArgs:
    def __init__(__self__, *,
                 bigquery_routine_spec: Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryRoutineSpecArgs']] = None,
                 definition_body: Optional[pulumi.Input[str]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 return_type: Optional[pulumi.Input[str]] = None,
                 routine_arguments: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentArgs']]]] = None,
                 routine_type: Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecRoutineType']] = None):
        """
        Specification that applies to a routine. Valid only for entries with the `ROUTINE` type.
        :param pulumi.Input['GoogleCloudDatacatalogV1BigQueryRoutineSpecArgs'] bigquery_routine_spec: Fields specific for BigQuery routines.
        :param pulumi.Input[str] definition_body: The body of the routine.
        :param pulumi.Input[str] language: The language the routine is written in. The exact value depends on the source system. For BigQuery routines, possible values are: * `SQL` * `JAVASCRIPT`
        :param pulumi.Input[str] return_type: Return type of the argument. The exact value depends on the source system and the language.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentArgs']]] routine_arguments: Arguments of the routine.
        :param pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecRoutineType'] routine_type: The type of the routine.
        """
        if bigquery_routine_spec is not None:
            pulumi.set(__self__, "bigquery_routine_spec", bigquery_routine_spec)
        if definition_body is not None:
            pulumi.set(__self__, "definition_body", definition_body)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if routine_arguments is not None:
            pulumi.set(__self__, "routine_arguments", routine_arguments)
        if routine_type is not None:
            pulumi.set(__self__, "routine_type", routine_type)

    @property
    @pulumi.getter(name="bigqueryRoutineSpec")
    def bigquery_routine_spec(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryRoutineSpecArgs']]:
        """
        Fields specific for BigQuery routines.
        """
        return pulumi.get(self, "bigquery_routine_spec")

    @bigquery_routine_spec.setter
    def bigquery_routine_spec(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1BigQueryRoutineSpecArgs']]):
        pulumi.set(self, "bigquery_routine_spec", value)

    @property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> Optional[pulumi.Input[str]]:
        """
        The body of the routine.
        """
        return pulumi.get(self, "definition_body")

    @definition_body.setter
    def definition_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "definition_body", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The language the routine is written in. The exact value depends on the source system. For BigQuery routines, possible values are: * `SQL` * `JAVASCRIPT`
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input[str]]:
        """
        Return type of the argument. The exact value depends on the source system and the language.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "return_type", value)

    @property
    @pulumi.getter(name="routineArguments")
    def routine_arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentArgs']]]]:
        """
        Arguments of the routine.
        """
        return pulumi.get(self, "routine_arguments")

    @routine_arguments.setter
    def routine_arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecArgumentArgs']]]]):
        pulumi.set(self, "routine_arguments", value)

    @property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecRoutineType']]:
        """
        The type of the routine.
        """
        return pulumi.get(self, "routine_type")

    @routine_type.setter
    def routine_type(self, value: Optional[pulumi.Input['GoogleCloudDatacatalogV1RoutineSpecRoutineType']]):
        pulumi.set(self, "routine_type", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1SchemaArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]]] = None):
        """
        Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]] columns: The unified GoogleSQL-like schema of columns. The overall maximum number of columns and nested columns is 10,000. The maximum nested depth is 15 levels.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]]]:
        """
        The unified GoogleSQL-like schema of columns. The overall maximum number of columns and nested columns is 10,000. The maximum nested depth is 15 levels.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDatacatalogV1ColumnSchemaArgs']]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class GoogleCloudDatacatalogV1SystemTimestampsArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Timestamps associated with this resource in a particular system.
        :param pulumi.Input[str] create_time: Creation timestamp of the resource within the given system.
        :param pulumi.Input[str] update_time: Timestamp of the last modification of the resource or its metadata within a given system. Note: Depending on the source system, not every modification updates this timestamp. For example, BigQuery timestamps every metadata modification but not data or permission changes.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the resource within the given system.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last modification of the resource or its metadata within a given system. Note: Depending on the source system, not every modification updates this timestamp. For example, BigQuery timestamps every metadata modification but not data or permission changes.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


