# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetOccurrenceResult',
    'AwaitableGetOccurrenceResult',
    'get_occurrence',
    'get_occurrence_output',
]

@pulumi.output_type
class GetOccurrenceResult:
    def __init__(__self__, attestation=None, build_details=None, compliance=None, create_time=None, deployment=None, derived_image=None, discovered=None, dsse_attestation=None, envelope=None, installation=None, kind=None, name=None, note_name=None, remediation=None, resource=None, resource_url=None, sbom=None, spdx_file=None, spdx_package=None, spdx_relationship=None, update_time=None, upgrade=None, vulnerability_details=None):
        if attestation and not isinstance(attestation, dict):
            raise TypeError("Expected argument 'attestation' to be a dict")
        pulumi.set(__self__, "attestation", attestation)
        if build_details and not isinstance(build_details, dict):
            raise TypeError("Expected argument 'build_details' to be a dict")
        pulumi.set(__self__, "build_details", build_details)
        if compliance and not isinstance(compliance, dict):
            raise TypeError("Expected argument 'compliance' to be a dict")
        pulumi.set(__self__, "compliance", compliance)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if deployment and not isinstance(deployment, dict):
            raise TypeError("Expected argument 'deployment' to be a dict")
        pulumi.set(__self__, "deployment", deployment)
        if derived_image and not isinstance(derived_image, dict):
            raise TypeError("Expected argument 'derived_image' to be a dict")
        pulumi.set(__self__, "derived_image", derived_image)
        if discovered and not isinstance(discovered, dict):
            raise TypeError("Expected argument 'discovered' to be a dict")
        pulumi.set(__self__, "discovered", discovered)
        if dsse_attestation and not isinstance(dsse_attestation, dict):
            raise TypeError("Expected argument 'dsse_attestation' to be a dict")
        pulumi.set(__self__, "dsse_attestation", dsse_attestation)
        if envelope and not isinstance(envelope, dict):
            raise TypeError("Expected argument 'envelope' to be a dict")
        pulumi.set(__self__, "envelope", envelope)
        if installation and not isinstance(installation, dict):
            raise TypeError("Expected argument 'installation' to be a dict")
        pulumi.set(__self__, "installation", installation)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if note_name and not isinstance(note_name, str):
            raise TypeError("Expected argument 'note_name' to be a str")
        pulumi.set(__self__, "note_name", note_name)
        if remediation and not isinstance(remediation, str):
            raise TypeError("Expected argument 'remediation' to be a str")
        pulumi.set(__self__, "remediation", remediation)
        if resource and not isinstance(resource, dict):
            raise TypeError("Expected argument 'resource' to be a dict")
        pulumi.set(__self__, "resource", resource)
        if resource_url and not isinstance(resource_url, str):
            raise TypeError("Expected argument 'resource_url' to be a str")
        pulumi.set(__self__, "resource_url", resource_url)
        if sbom and not isinstance(sbom, dict):
            raise TypeError("Expected argument 'sbom' to be a dict")
        pulumi.set(__self__, "sbom", sbom)
        if spdx_file and not isinstance(spdx_file, dict):
            raise TypeError("Expected argument 'spdx_file' to be a dict")
        pulumi.set(__self__, "spdx_file", spdx_file)
        if spdx_package and not isinstance(spdx_package, dict):
            raise TypeError("Expected argument 'spdx_package' to be a dict")
        pulumi.set(__self__, "spdx_package", spdx_package)
        if spdx_relationship and not isinstance(spdx_relationship, dict):
            raise TypeError("Expected argument 'spdx_relationship' to be a dict")
        pulumi.set(__self__, "spdx_relationship", spdx_relationship)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if upgrade and not isinstance(upgrade, dict):
            raise TypeError("Expected argument 'upgrade' to be a dict")
        pulumi.set(__self__, "upgrade", upgrade)
        if vulnerability_details and not isinstance(vulnerability_details, dict):
            raise TypeError("Expected argument 'vulnerability_details' to be a dict")
        pulumi.set(__self__, "vulnerability_details", vulnerability_details)

    @property
    @pulumi.getter
    def attestation(self) -> 'outputs.AttestationResponse':
        """
        Describes an attestation of an artifact.
        """
        return pulumi.get(self, "attestation")

    @property
    @pulumi.getter(name="buildDetails")
    def build_details(self) -> 'outputs.BuildDetailsResponse':
        """
        Build details for a verifiable build.
        """
        return pulumi.get(self, "build_details")

    @property
    @pulumi.getter
    def compliance(self) -> 'outputs.ComplianceOccurrenceResponse':
        """
        Describes whether or not a resource passes compliance checks.
        """
        return pulumi.get(self, "compliance")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time this `Occurrence` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def deployment(self) -> 'outputs.DeploymentResponse':
        """
        Describes the deployment of an artifact on a runtime.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter(name="derivedImage")
    def derived_image(self) -> 'outputs.DerivedResponse':
        """
        Describes how this resource derives from the basis in the associated note.
        """
        return pulumi.get(self, "derived_image")

    @property
    @pulumi.getter
    def discovered(self) -> 'outputs.DiscoveredResponse':
        """
        Describes the initial scan status for this resource.
        """
        return pulumi.get(self, "discovered")

    @property
    @pulumi.getter(name="dsseAttestation")
    def dsse_attestation(self) -> 'outputs.DSSEAttestationOccurrenceResponse':
        """
        This represents a DSSE attestation occurrence
        """
        return pulumi.get(self, "dsse_attestation")

    @property
    @pulumi.getter
    def envelope(self) -> 'outputs.EnvelopeResponse':
        """
        https://github.com/secure-systems-lab/dsse
        """
        return pulumi.get(self, "envelope")

    @property
    @pulumi.getter
    def installation(self) -> 'outputs.InstallationResponse':
        """
        Describes the installation of a package on the linked resource.
        """
        return pulumi.get(self, "installation")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This explicitly denotes which of the `Occurrence` details are specified. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the `Occurrence` in the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noteName")
    def note_name(self) -> str:
        """
        An analysis note associated with this image, in the form "providers/{provider_id}/notes/{NOTE_ID}" This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "note_name")

    @property
    @pulumi.getter
    def remediation(self) -> str:
        """
        A description of actions that can be taken to remedy the `Note`
        """
        return pulumi.get(self, "remediation")

    @property
    @pulumi.getter
    def resource(self) -> 'outputs.ResourceResponse':
        """
         The resource for which the `Occurrence` applies.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> str:
        """
        The unique URL of the image or the container for which the `Occurrence` applies. For example, https://gcr.io/project/image@sha256:foo This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "resource_url")

    @property
    @pulumi.getter
    def sbom(self) -> 'outputs.DocumentOccurrenceResponse':
        """
        Describes a specific software bill of materials document.
        """
        return pulumi.get(self, "sbom")

    @property
    @pulumi.getter(name="spdxFile")
    def spdx_file(self) -> 'outputs.FileOccurrenceResponse':
        """
        Describes a specific SPDX File.
        """
        return pulumi.get(self, "spdx_file")

    @property
    @pulumi.getter(name="spdxPackage")
    def spdx_package(self) -> 'outputs.PackageInfoOccurrenceResponse':
        """
        Describes a specific SPDX Package.
        """
        return pulumi.get(self, "spdx_package")

    @property
    @pulumi.getter(name="spdxRelationship")
    def spdx_relationship(self) -> 'outputs.RelationshipOccurrenceResponse':
        """
        Describes a specific relationship between SPDX elements.
        """
        return pulumi.get(self, "spdx_relationship")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time this `Occurrence` was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def upgrade(self) -> 'outputs.UpgradeOccurrenceResponse':
        """
        Describes an upgrade.
        """
        return pulumi.get(self, "upgrade")

    @property
    @pulumi.getter(name="vulnerabilityDetails")
    def vulnerability_details(self) -> 'outputs.VulnerabilityDetailsResponse':
        """
        Details of a security vulnerability note.
        """
        return pulumi.get(self, "vulnerability_details")


class AwaitableGetOccurrenceResult(GetOccurrenceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccurrenceResult(
            attestation=self.attestation,
            build_details=self.build_details,
            compliance=self.compliance,
            create_time=self.create_time,
            deployment=self.deployment,
            derived_image=self.derived_image,
            discovered=self.discovered,
            dsse_attestation=self.dsse_attestation,
            envelope=self.envelope,
            installation=self.installation,
            kind=self.kind,
            name=self.name,
            note_name=self.note_name,
            remediation=self.remediation,
            resource=self.resource,
            resource_url=self.resource_url,
            sbom=self.sbom,
            spdx_file=self.spdx_file,
            spdx_package=self.spdx_package,
            spdx_relationship=self.spdx_relationship,
            update_time=self.update_time,
            upgrade=self.upgrade,
            vulnerability_details=self.vulnerability_details)


def get_occurrence(occurrence_id: Optional[str] = None,
                   project: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccurrenceResult:
    """
    Returns the requested `Occurrence`.
    """
    __args__ = dict()
    __args__['occurrenceId'] = occurrence_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:containeranalysis/v1alpha1:getOccurrence', __args__, opts=opts, typ=GetOccurrenceResult).value

    return AwaitableGetOccurrenceResult(
        attestation=__ret__.attestation,
        build_details=__ret__.build_details,
        compliance=__ret__.compliance,
        create_time=__ret__.create_time,
        deployment=__ret__.deployment,
        derived_image=__ret__.derived_image,
        discovered=__ret__.discovered,
        dsse_attestation=__ret__.dsse_attestation,
        envelope=__ret__.envelope,
        installation=__ret__.installation,
        kind=__ret__.kind,
        name=__ret__.name,
        note_name=__ret__.note_name,
        remediation=__ret__.remediation,
        resource=__ret__.resource,
        resource_url=__ret__.resource_url,
        sbom=__ret__.sbom,
        spdx_file=__ret__.spdx_file,
        spdx_package=__ret__.spdx_package,
        spdx_relationship=__ret__.spdx_relationship,
        update_time=__ret__.update_time,
        upgrade=__ret__.upgrade,
        vulnerability_details=__ret__.vulnerability_details)


@_utilities.lift_output_func(get_occurrence)
def get_occurrence_output(occurrence_id: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOccurrenceResult]:
    """
    Returns the requested `Occurrence`.
    """
    ...
