# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['PhraseMatcherArgs', 'PhraseMatcher']

@pulumi.input_type
class PhraseMatcherArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['PhraseMatcherType'],
                 active: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phrase_match_rule_groups: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 role_match: Optional[pulumi.Input['PhraseMatcherRoleMatch']] = None,
                 version_tag: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PhraseMatcher resource.
        :param pulumi.Input['PhraseMatcherType'] type: The type of this phrase matcher.
        :param pulumi.Input[bool] active: Applies the phrase matcher only when it is active.
        :param pulumi.Input[str] display_name: The human-readable name of the phrase matcher.
        :param pulumi.Input[str] name: The resource name of the phrase matcher. Format: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]] phrase_match_rule_groups: A list of phase match rule groups that are included in this matcher.
        :param pulumi.Input['PhraseMatcherRoleMatch'] role_match: The role whose utterances the phrase matcher should be matched against. If the role is ROLE_UNSPECIFIED it will be matched against any utterances in the transcript.
        :param pulumi.Input[str] version_tag: The customized version tag to use for the phrase matcher. If not specified, it will default to `revision_id`.
        """
        pulumi.set(__self__, "type", type)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phrase_match_rule_groups is not None:
            pulumi.set(__self__, "phrase_match_rule_groups", phrase_match_rule_groups)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if role_match is not None:
            pulumi.set(__self__, "role_match", role_match)
        if version_tag is not None:
            pulumi.set(__self__, "version_tag", version_tag)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['PhraseMatcherType']:
        """
        The type of this phrase matcher.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['PhraseMatcherType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Applies the phrase matcher only when it is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the phrase matcher.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the phrase matcher. Format: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phraseMatchRuleGroups")
    def phrase_match_rule_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]]]:
        """
        A list of phase match rule groups that are included in this matcher.
        """
        return pulumi.get(self, "phrase_match_rule_groups")

    @phrase_match_rule_groups.setter
    def phrase_match_rule_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]]]):
        pulumi.set(self, "phrase_match_rule_groups", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="roleMatch")
    def role_match(self) -> Optional[pulumi.Input['PhraseMatcherRoleMatch']]:
        """
        The role whose utterances the phrase matcher should be matched against. If the role is ROLE_UNSPECIFIED it will be matched against any utterances in the transcript.
        """
        return pulumi.get(self, "role_match")

    @role_match.setter
    def role_match(self, value: Optional[pulumi.Input['PhraseMatcherRoleMatch']]):
        pulumi.set(self, "role_match", value)

    @property
    @pulumi.getter(name="versionTag")
    def version_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The customized version tag to use for the phrase matcher. If not specified, it will default to `revision_id`.
        """
        return pulumi.get(self, "version_tag")

    @version_tag.setter
    def version_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_tag", value)


class PhraseMatcher(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phrase_match_rule_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 role_match: Optional[pulumi.Input['PhraseMatcherRoleMatch']] = None,
                 type: Optional[pulumi.Input['PhraseMatcherType']] = None,
                 version_tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a phrase matcher.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Applies the phrase matcher only when it is active.
        :param pulumi.Input[str] display_name: The human-readable name of the phrase matcher.
        :param pulumi.Input[str] name: The resource name of the phrase matcher. Format: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]]] phrase_match_rule_groups: A list of phase match rule groups that are included in this matcher.
        :param pulumi.Input['PhraseMatcherRoleMatch'] role_match: The role whose utterances the phrase matcher should be matched against. If the role is ROLE_UNSPECIFIED it will be matched against any utterances in the transcript.
        :param pulumi.Input['PhraseMatcherType'] type: The type of this phrase matcher.
        :param pulumi.Input[str] version_tag: The customized version tag to use for the phrase matcher. If not specified, it will default to `revision_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PhraseMatcherArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a phrase matcher.

        :param str resource_name: The name of the resource.
        :param PhraseMatcherArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PhraseMatcherArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phrase_match_rule_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 role_match: Optional[pulumi.Input['PhraseMatcherRoleMatch']] = None,
                 type: Optional[pulumi.Input['PhraseMatcherType']] = None,
                 version_tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PhraseMatcherArgs.__new__(PhraseMatcherArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["phrase_match_rule_groups"] = phrase_match_rule_groups
            __props__.__dict__["project"] = project
            __props__.__dict__["role_match"] = role_match
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["version_tag"] = version_tag
            __props__.__dict__["activation_update_time"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PhraseMatcher, __self__).__init__(
            'google-native:contactcenterinsights/v1:PhraseMatcher',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PhraseMatcher':
        """
        Get an existing PhraseMatcher resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PhraseMatcherArgs.__new__(PhraseMatcherArgs)

        __props__.__dict__["activation_update_time"] = None
        __props__.__dict__["active"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["phrase_match_rule_groups"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["revision_create_time"] = None
        __props__.__dict__["revision_id"] = None
        __props__.__dict__["role_match"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["version_tag"] = None
        return PhraseMatcher(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationUpdateTime")
    def activation_update_time(self) -> pulumi.Output[str]:
        """
        The most recent time at which the activation status was updated.
        """
        return pulumi.get(self, "activation_update_time")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        Applies the phrase matcher only when it is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The human-readable name of the phrase matcher.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the phrase matcher. Format: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phraseMatchRuleGroups")
    def phrase_match_rule_groups(self) -> pulumi.Output[Sequence['outputs.GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse']]:
        """
        A list of phase match rule groups that are included in this matcher.
        """
        return pulumi.get(self, "phrase_match_rule_groups")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[str]:
        """
        The timestamp of when the revision was created. It is also the create time when a new matcher is added.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[str]:
        """
        Immutable. The revision ID of the phrase matcher. A new revision is committed whenever the matcher is changed, except when it is activated or deactivated. A server generated random ID will be used. Example: locations/global/phraseMatchers/my-first-matcher@1234567
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter(name="roleMatch")
    def role_match(self) -> pulumi.Output[str]:
        """
        The role whose utterances the phrase matcher should be matched against. If the role is ROLE_UNSPECIFIED it will be matched against any utterances in the transcript.
        """
        return pulumi.get(self, "role_match")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of this phrase matcher.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The most recent time at which the phrase matcher was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="versionTag")
    def version_tag(self) -> pulumi.Output[str]:
        """
        The customized version tag to use for the phrase matcher. If not specified, it will default to `revision_id`.
        """
        return pulumi.get(self, "version_tag")

