# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetConversationResult',
    'AwaitableGetConversationResult',
    'get_conversation',
    'get_conversation_output',
]

@pulumi.output_type
class GetConversationResult:
    def __init__(__self__, agent_id=None, call_metadata=None, create_time=None, data_source=None, dialogflow_intents=None, duration=None, expire_time=None, labels=None, language_code=None, latest_analysis=None, medium=None, name=None, obfuscated_user_id=None, runtime_annotations=None, start_time=None, transcript=None, ttl=None, turn_count=None, update_time=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if call_metadata and not isinstance(call_metadata, dict):
            raise TypeError("Expected argument 'call_metadata' to be a dict")
        pulumi.set(__self__, "call_metadata", call_metadata)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_source and not isinstance(data_source, dict):
            raise TypeError("Expected argument 'data_source' to be a dict")
        pulumi.set(__self__, "data_source", data_source)
        if dialogflow_intents and not isinstance(dialogflow_intents, dict):
            raise TypeError("Expected argument 'dialogflow_intents' to be a dict")
        pulumi.set(__self__, "dialogflow_intents", dialogflow_intents)
        if duration and not isinstance(duration, str):
            raise TypeError("Expected argument 'duration' to be a str")
        pulumi.set(__self__, "duration", duration)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if language_code and not isinstance(language_code, str):
            raise TypeError("Expected argument 'language_code' to be a str")
        pulumi.set(__self__, "language_code", language_code)
        if latest_analysis and not isinstance(latest_analysis, dict):
            raise TypeError("Expected argument 'latest_analysis' to be a dict")
        pulumi.set(__self__, "latest_analysis", latest_analysis)
        if medium and not isinstance(medium, str):
            raise TypeError("Expected argument 'medium' to be a str")
        pulumi.set(__self__, "medium", medium)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if obfuscated_user_id and not isinstance(obfuscated_user_id, str):
            raise TypeError("Expected argument 'obfuscated_user_id' to be a str")
        pulumi.set(__self__, "obfuscated_user_id", obfuscated_user_id)
        if runtime_annotations and not isinstance(runtime_annotations, list):
            raise TypeError("Expected argument 'runtime_annotations' to be a list")
        pulumi.set(__self__, "runtime_annotations", runtime_annotations)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if transcript and not isinstance(transcript, dict):
            raise TypeError("Expected argument 'transcript' to be a dict")
        pulumi.set(__self__, "transcript", transcript)
        if ttl and not isinstance(ttl, str):
            raise TypeError("Expected argument 'ttl' to be a str")
        pulumi.set(__self__, "ttl", ttl)
        if turn_count and not isinstance(turn_count, int):
            raise TypeError("Expected argument 'turn_count' to be a int")
        pulumi.set(__self__, "turn_count", turn_count)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        An opaque, user-specified string representing the human agent who handled the conversation.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="callMetadata")
    def call_metadata(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ConversationCallMetadataResponse':
        """
        Call-specific metadata.
        """
        return pulumi.get(self, "call_metadata")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the conversation was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ConversationDataSourceResponse':
        """
        The source of the audio and transcription for the conversation.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="dialogflowIntents")
    def dialogflow_intents(self) -> Mapping[str, str]:
        """
        All the matched Dialogflow intents in the call. The key corresponds to a Dialogflow intent, format: projects/{project}/agent/{agent}/intents/{intent}
        """
        return pulumi.get(self, "dialogflow_intents")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The duration of the conversation.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time at which this conversation should expire. After this time, the conversation data and any associated analyses will be deleted.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map for the user to specify any custom fields. A maximum of 20 labels per conversation is allowed, with a maximum of 256 characters per entry.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        A user-specified language code for the conversation.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="latestAnalysis")
    def latest_analysis(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnalysisResponse':
        """
        The conversation's latest analysis, if one exists.
        """
        return pulumi.get(self, "latest_analysis")

    @property
    @pulumi.getter
    def medium(self) -> str:
        """
        Immutable. The conversation medium, if unspecified will default to PHONE_CALL.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The resource name of the conversation. Format: projects/{project}/locations/{location}/conversations/{conversation}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="obfuscatedUserId")
    def obfuscated_user_id(self) -> str:
        """
        Obfuscated user ID which the customer sent to us.
        """
        return pulumi.get(self, "obfuscated_user_id")

    @property
    @pulumi.getter(name="runtimeAnnotations")
    def runtime_annotations(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1RuntimeAnnotationResponse']:
        """
        The annotations that were generated during the customer and agent interaction.
        """
        return pulumi.get(self, "runtime_annotations")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time at which the conversation started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def transcript(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptResponse':
        """
        The conversation transcript.
        """
        return pulumi.get(self, "transcript")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Input only. The TTL for this resource. If specified, then this TTL will be used to calculate the expire time.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="turnCount")
    def turn_count(self) -> int:
        """
        The number of turns in the conversation.
        """
        return pulumi.get(self, "turn_count")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The most recent time at which the conversation was updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetConversationResult(GetConversationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConversationResult(
            agent_id=self.agent_id,
            call_metadata=self.call_metadata,
            create_time=self.create_time,
            data_source=self.data_source,
            dialogflow_intents=self.dialogflow_intents,
            duration=self.duration,
            expire_time=self.expire_time,
            labels=self.labels,
            language_code=self.language_code,
            latest_analysis=self.latest_analysis,
            medium=self.medium,
            name=self.name,
            obfuscated_user_id=self.obfuscated_user_id,
            runtime_annotations=self.runtime_annotations,
            start_time=self.start_time,
            transcript=self.transcript,
            ttl=self.ttl,
            turn_count=self.turn_count,
            update_time=self.update_time)


def get_conversation(conversation_id: Optional[str] = None,
                     location: Optional[str] = None,
                     project: Optional[str] = None,
                     view: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConversationResult:
    """
    Gets a conversation.
    """
    __args__ = dict()
    __args__['conversationId'] = conversation_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['view'] = view
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:contactcenterinsights/v1:getConversation', __args__, opts=opts, typ=GetConversationResult).value

    return AwaitableGetConversationResult(
        agent_id=__ret__.agent_id,
        call_metadata=__ret__.call_metadata,
        create_time=__ret__.create_time,
        data_source=__ret__.data_source,
        dialogflow_intents=__ret__.dialogflow_intents,
        duration=__ret__.duration,
        expire_time=__ret__.expire_time,
        labels=__ret__.labels,
        language_code=__ret__.language_code,
        latest_analysis=__ret__.latest_analysis,
        medium=__ret__.medium,
        name=__ret__.name,
        obfuscated_user_id=__ret__.obfuscated_user_id,
        runtime_annotations=__ret__.runtime_annotations,
        start_time=__ret__.start_time,
        transcript=__ret__.transcript,
        ttl=__ret__.ttl,
        turn_count=__ret__.turn_count,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_conversation)
def get_conversation_output(conversation_id: Optional[pulumi.Input[str]] = None,
                            location: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            view: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConversationResult]:
    """
    Gets a conversation.
    """
    ...
