# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTaskResult',
    'AwaitableGetTaskResult',
    'get_task',
    'get_task_output',
]

@pulumi.output_type
class GetTaskResult:
    def __init__(__self__, app_engine_http_request=None, create_time=None, name=None, pull_message=None, schedule_time=None, status=None, view=None):
        if app_engine_http_request and not isinstance(app_engine_http_request, dict):
            raise TypeError("Expected argument 'app_engine_http_request' to be a dict")
        pulumi.set(__self__, "app_engine_http_request", app_engine_http_request)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pull_message and not isinstance(pull_message, dict):
            raise TypeError("Expected argument 'pull_message' to be a dict")
        pulumi.set(__self__, "pull_message", pull_message)
        if schedule_time and not isinstance(schedule_time, str):
            raise TypeError("Expected argument 'schedule_time' to be a str")
        pulumi.set(__self__, "schedule_time", schedule_time)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if view and not isinstance(view, str):
            raise TypeError("Expected argument 'view' to be a str")
        pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter(name="appEngineHttpRequest")
    def app_engine_http_request(self) -> 'outputs.AppEngineHttpRequestResponse':
        """
        App Engine HTTP request that is sent to the task's target. Can be set only if app_engine_http_target is set on the queue. An App Engine task is a task that has AppEngineHttpRequest set.
        """
        return pulumi.get(self, "app_engine_http_request")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time that the task was created. `create_time` will be truncated to the nearest second.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optionally caller-specified in CreateTask. The task name. The task name must have the following format: `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID` * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), or periods (.). For more information, see [Identifying projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects) * `LOCATION_ID` is the canonical ID for the task's location. The list of available locations can be obtained by calling ListLocations. For more information, see https://cloud.google.com/about/locations/. * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or hyphens (-). The maximum length is 100 characters. * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), or underscores (_). The maximum length is 500 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pullMessage")
    def pull_message(self) -> 'outputs.PullMessageResponse':
        """
        LeaseTasks to process the task. Can be set only if pull_target is set on the queue. A pull task is a task that has PullMessage set.
        """
        return pulumi.get(self, "pull_message")

    @property
    @pulumi.getter(name="scheduleTime")
    def schedule_time(self) -> str:
        """
        The time when the task is scheduled to be attempted. For App Engine queues, this is when the task will be attempted or retried. For pull queues, this is the time when the task is available to be leased; if a task is currently leased, this is the time when the current lease expires, that is, the time that the task was leased plus the lease_duration. `schedule_time` will be truncated to the nearest microsecond.
        """
        return pulumi.get(self, "schedule_time")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.TaskStatusResponse':
        """
        The task status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def view(self) -> str:
        """
        The view specifies which subset of the Task has been returned.
        """
        return pulumi.get(self, "view")


class AwaitableGetTaskResult(GetTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskResult(
            app_engine_http_request=self.app_engine_http_request,
            create_time=self.create_time,
            name=self.name,
            pull_message=self.pull_message,
            schedule_time=self.schedule_time,
            status=self.status,
            view=self.view)


def get_task(location: Optional[str] = None,
             project: Optional[str] = None,
             queue_id: Optional[str] = None,
             response_view: Optional[str] = None,
             task_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskResult:
    """
    Gets a task.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['queueId'] = queue_id
    __args__['responseView'] = response_view
    __args__['taskId'] = task_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudtasks/v2beta2:getTask', __args__, opts=opts, typ=GetTaskResult).value

    return AwaitableGetTaskResult(
        app_engine_http_request=__ret__.app_engine_http_request,
        create_time=__ret__.create_time,
        name=__ret__.name,
        pull_message=__ret__.pull_message,
        schedule_time=__ret__.schedule_time,
        status=__ret__.status,
        view=__ret__.view)


@_utilities.lift_output_func(get_task)
def get_task_output(location: Optional[pulumi.Input[str]] = None,
                    project: Optional[pulumi.Input[Optional[str]]] = None,
                    queue_id: Optional[pulumi.Input[str]] = None,
                    response_view: Optional[pulumi.Input[Optional[str]]] = None,
                    task_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTaskResult]:
    """
    Gets a task.
    """
    ...
