# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    def __init__(__self__, app_engine_http_target=None, name=None, pull_target=None, purge_time=None, rate_limits=None, retry_config=None, state=None, stats=None, task_ttl=None, tombstone_ttl=None):
        if app_engine_http_target and not isinstance(app_engine_http_target, dict):
            raise TypeError("Expected argument 'app_engine_http_target' to be a dict")
        pulumi.set(__self__, "app_engine_http_target", app_engine_http_target)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pull_target and not isinstance(pull_target, dict):
            raise TypeError("Expected argument 'pull_target' to be a dict")
        pulumi.set(__self__, "pull_target", pull_target)
        if purge_time and not isinstance(purge_time, str):
            raise TypeError("Expected argument 'purge_time' to be a str")
        pulumi.set(__self__, "purge_time", purge_time)
        if rate_limits and not isinstance(rate_limits, dict):
            raise TypeError("Expected argument 'rate_limits' to be a dict")
        pulumi.set(__self__, "rate_limits", rate_limits)
        if retry_config and not isinstance(retry_config, dict):
            raise TypeError("Expected argument 'retry_config' to be a dict")
        pulumi.set(__self__, "retry_config", retry_config)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stats and not isinstance(stats, dict):
            raise TypeError("Expected argument 'stats' to be a dict")
        pulumi.set(__self__, "stats", stats)
        if task_ttl and not isinstance(task_ttl, str):
            raise TypeError("Expected argument 'task_ttl' to be a str")
        pulumi.set(__self__, "task_ttl", task_ttl)
        if tombstone_ttl and not isinstance(tombstone_ttl, str):
            raise TypeError("Expected argument 'tombstone_ttl' to be a str")
        pulumi.set(__self__, "tombstone_ttl", tombstone_ttl)

    @property
    @pulumi.getter(name="appEngineHttpTarget")
    def app_engine_http_target(self) -> 'outputs.AppEngineHttpTargetResponse':
        """
        App Engine HTTP target. An App Engine queue is a queue that has an AppEngineHttpTarget.
        """
        return pulumi.get(self, "app_engine_http_target")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Caller-specified and required in CreateQueue, after which it becomes output only. The queue name. The queue name must have the following format: `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID` * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), or periods (.). For more information, see [Identifying projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects) * `LOCATION_ID` is the canonical ID for the queue's location. The list of available locations can be obtained by calling ListLocations. For more information, see https://cloud.google.com/about/locations/. * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or hyphens (-). The maximum length is 100 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pullTarget")
    def pull_target(self) -> 'outputs.PullTargetResponse':
        """
        Pull target. A pull queue is a queue that has a PullTarget.
        """
        return pulumi.get(self, "pull_target")

    @property
    @pulumi.getter(name="purgeTime")
    def purge_time(self) -> str:
        """
        The last time this queue was purged. All tasks that were created before this time were purged. A queue can be purged using PurgeQueue, the [App Engine Task Queue SDK, or the Cloud Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue). Purge time will be truncated to the nearest microsecond. Purge time will be unset if the queue has never been purged.
        """
        return pulumi.get(self, "purge_time")

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> 'outputs.RateLimitsResponse':
        """
        Rate limits for task dispatches. rate_limits and retry_config are related because they both control task attempts however they control how tasks are attempted in different ways: * rate_limits controls the total rate of dispatches from a queue (i.e. all traffic dispatched from the queue, regardless of whether the dispatch is from a first attempt or a retry). * retry_config controls what happens to particular a task after its first attempt fails. That is, retry_config controls task retries (the second attempt, third attempt, etc).
        """
        return pulumi.get(self, "rate_limits")

    @property
    @pulumi.getter(name="retryConfig")
    def retry_config(self) -> 'outputs.RetryConfigResponse':
        """
        Settings that determine the retry behavior. * For tasks created using Cloud Tasks: the queue-level retry settings apply to all tasks in the queue that were created using Cloud Tasks. Retry settings cannot be set on individual tasks. * For tasks created using the App Engine SDK: the queue-level retry settings apply to all tasks in the queue which do not have retry settings explicitly set on the task and were created by the App Engine SDK. See [App Engine documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
        """
        return pulumi.get(self, "retry_config")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the queue. `state` can only be changed by called PauseQueue, ResumeQueue, or uploading [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref). UpdateQueue cannot be used to change `state`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> 'outputs.QueueStatsResponse':
        """
        The realtime, informational statistics for a queue. In order to receive the statistics the caller should include this field in the FieldMask.
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="taskTtl")
    def task_ttl(self) -> str:
        """
        The maximum amount of time that a task will be retained in this queue. Queues created by Cloud Tasks have a default `task_ttl` of 31 days. After a task has lived for `task_ttl`, the task will be deleted regardless of whether it was dispatched or not. The `task_ttl` for queues created via queue.yaml/xml is equal to the maximum duration because there is a [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for these queues. To view the maximum valid duration, see the documentation for Duration.
        """
        return pulumi.get(self, "task_ttl")

    @property
    @pulumi.getter(name="tombstoneTtl")
    def tombstone_ttl(self) -> str:
        """
        The task tombstone time to live (TTL). After a task is deleted or completed, the task's tombstone is retained for the length of time specified by `tombstone_ttl`. The tombstone is used by task de-duplication; another task with the same name can't be created until the tombstone has expired. For more information about task de-duplication, see the documentation for CreateTaskRequest. Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
        """
        return pulumi.get(self, "tombstone_ttl")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            app_engine_http_target=self.app_engine_http_target,
            name=self.name,
            pull_target=self.pull_target,
            purge_time=self.purge_time,
            rate_limits=self.rate_limits,
            retry_config=self.retry_config,
            state=self.state,
            stats=self.stats,
            task_ttl=self.task_ttl,
            tombstone_ttl=self.tombstone_ttl)


def get_queue(location: Optional[str] = None,
              project: Optional[str] = None,
              queue_id: Optional[str] = None,
              read_mask: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    Gets a queue.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['queueId'] = queue_id
    __args__['readMask'] = read_mask
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudtasks/v2beta2:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        app_engine_http_target=__ret__.app_engine_http_target,
        name=__ret__.name,
        pull_target=__ret__.pull_target,
        purge_time=__ret__.purge_time,
        rate_limits=__ret__.rate_limits,
        retry_config=__ret__.retry_config,
        state=__ret__.state,
        stats=__ret__.stats,
        task_ttl=__ret__.task_ttl,
        tombstone_ttl=__ret__.tombstone_ttl)


@_utilities.lift_output_func(get_queue)
def get_queue_output(location: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     queue_id: Optional[pulumi.Input[str]] = None,
                     read_mask: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueueResult]:
    """
    Gets a queue.
    """
    ...
