# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = ['ImportJobArgs', 'ImportJob']

@pulumi.input_type
class ImportJobArgs:
    def __init__(__self__, *,
                 import_method: pulumi.Input['ImportJobImportMethod'],
                 key_ring_id: pulumi.Input[str],
                 protection_level: pulumi.Input['ImportJobProtectionLevel'],
                 import_job_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ImportJob resource.
        :param pulumi.Input['ImportJobImportMethod'] import_method: Immutable. The wrapping method to be used for incoming key material.
        :param pulumi.Input['ImportJobProtectionLevel'] protection_level: Immutable. The protection level of the ImportJob. This must match the protection_level of the version_template on the CryptoKey you attempt to import into.
        :param pulumi.Input[str] import_job_id: Required. It must be unique within a KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        """
        pulumi.set(__self__, "import_method", import_method)
        pulumi.set(__self__, "key_ring_id", key_ring_id)
        pulumi.set(__self__, "protection_level", protection_level)
        if import_job_id is not None:
            pulumi.set(__self__, "import_job_id", import_job_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="importMethod")
    def import_method(self) -> pulumi.Input['ImportJobImportMethod']:
        """
        Immutable. The wrapping method to be used for incoming key material.
        """
        return pulumi.get(self, "import_method")

    @import_method.setter
    def import_method(self, value: pulumi.Input['ImportJobImportMethod']):
        pulumi.set(self, "import_method", value)

    @property
    @pulumi.getter(name="keyRingId")
    def key_ring_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key_ring_id")

    @key_ring_id.setter
    def key_ring_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_ring_id", value)

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> pulumi.Input['ImportJobProtectionLevel']:
        """
        Immutable. The protection level of the ImportJob. This must match the protection_level of the version_template on the CryptoKey you attempt to import into.
        """
        return pulumi.get(self, "protection_level")

    @protection_level.setter
    def protection_level(self, value: pulumi.Input['ImportJobProtectionLevel']):
        pulumi.set(self, "protection_level", value)

    @property
    @pulumi.getter(name="importJobId")
    def import_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. It must be unique within a KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        """
        return pulumi.get(self, "import_job_id")

    @import_job_id.setter
    def import_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_job_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ImportJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 import_job_id: Optional[pulumi.Input[str]] = None,
                 import_method: Optional[pulumi.Input['ImportJobImportMethod']] = None,
                 key_ring_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protection_level: Optional[pulumi.Input['ImportJobProtectionLevel']] = None,
                 __props__=None):
        """
        Create a new ImportJob within a KeyRing. ImportJob.import_method is required.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] import_job_id: Required. It must be unique within a KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        :param pulumi.Input['ImportJobImportMethod'] import_method: Immutable. The wrapping method to be used for incoming key material.
        :param pulumi.Input['ImportJobProtectionLevel'] protection_level: Immutable. The protection level of the ImportJob. This must match the protection_level of the version_template on the CryptoKey you attempt to import into.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImportJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a new ImportJob within a KeyRing. ImportJob.import_method is required.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param ImportJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImportJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 import_job_id: Optional[pulumi.Input[str]] = None,
                 import_method: Optional[pulumi.Input['ImportJobImportMethod']] = None,
                 key_ring_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protection_level: Optional[pulumi.Input['ImportJobProtectionLevel']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImportJobArgs.__new__(ImportJobArgs)

            __props__.__dict__["import_job_id"] = import_job_id
            if import_method is None and not opts.urn:
                raise TypeError("Missing required property 'import_method'")
            __props__.__dict__["import_method"] = import_method
            if key_ring_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_ring_id'")
            __props__.__dict__["key_ring_id"] = key_ring_id
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if protection_level is None and not opts.urn:
                raise TypeError("Missing required property 'protection_level'")
            __props__.__dict__["protection_level"] = protection_level
            __props__.__dict__["attestation"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["expire_event_time"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["generate_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["public_key"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["import_job_id", "key_ring_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ImportJob, __self__).__init__(
            'google-native:cloudkms/v1:ImportJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ImportJob':
        """
        Get an existing ImportJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ImportJobArgs.__new__(ImportJobArgs)

        __props__.__dict__["attestation"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["expire_event_time"] = None
        __props__.__dict__["expire_time"] = None
        __props__.__dict__["generate_time"] = None
        __props__.__dict__["import_job_id"] = None
        __props__.__dict__["import_method"] = None
        __props__.__dict__["key_ring_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["protection_level"] = None
        __props__.__dict__["public_key"] = None
        __props__.__dict__["state"] = None
        return ImportJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attestation(self) -> pulumi.Output['outputs.KeyOperationAttestationResponse']:
        """
        Statement that was generated and signed by the key creator (for example, an HSM) at key creation time. Use this statement to verify attributes of the key as stored on the HSM, independently of Google. Only present if the chosen ImportMethod is one with a protection level of HSM.
        """
        return pulumi.get(self, "attestation")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which this ImportJob was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireEventTime")
    def expire_event_time(self) -> pulumi.Output[str]:
        """
        The time this ImportJob expired. Only present if state is EXPIRED.
        """
        return pulumi.get(self, "expire_event_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[str]:
        """
        The time at which this ImportJob is scheduled for expiration and can no longer be used to import key material.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="generateTime")
    def generate_time(self) -> pulumi.Output[str]:
        """
        The time this ImportJob's key material was generated.
        """
        return pulumi.get(self, "generate_time")

    @property
    @pulumi.getter(name="importJobId")
    def import_job_id(self) -> pulumi.Output[str]:
        """
        Required. It must be unique within a KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        """
        return pulumi.get(self, "import_job_id")

    @property
    @pulumi.getter(name="importMethod")
    def import_method(self) -> pulumi.Output[str]:
        """
        Immutable. The wrapping method to be used for incoming key material.
        """
        return pulumi.get(self, "import_method")

    @property
    @pulumi.getter(name="keyRingId")
    def key_ring_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "key_ring_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name for this ImportJob in the format `projects/*/locations/*/keyRings/*/importJobs/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> pulumi.Output[str]:
        """
        Immutable. The protection level of the ImportJob. This must match the protection_level of the version_template on the CryptoKey you attempt to import into.
        """
        return pulumi.get(self, "protection_level")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output['outputs.WrappingPublicKeyResponse']:
        """
        The public key with which to wrap key material prior to import. Only returned if state is ACTIVE.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the ImportJob, indicating if it can be used.
        """
        return pulumi.get(self, "state")

