# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReleaseArgs', 'Release']

@pulumi.input_type
class ReleaseArgs:
    def __init__(__self__, *,
                 delivery_pipeline_id: pulumi.Input[str],
                 release_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['BuildArtifactArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 skaffold_config_path: Optional[pulumi.Input[str]] = None,
                 skaffold_config_uri: Optional[pulumi.Input[str]] = None,
                 skaffold_version: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Release resource.
        :param pulumi.Input[str] release_id: Required. ID of the `Release`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param pulumi.Input[Sequence[pulumi.Input['BuildArtifactArgs']]] build_artifacts: List of artifacts to pass through to Skaffold command.
        :param pulumi.Input[str] description: Description of the `Release`. Max length is 255 characters.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param pulumi.Input[str] name: Optional. Name of the `Release`. Format is projects/{project}/ locations/{location}/deliveryPipelines/{deliveryPipeline}/ releases/a-z{0,62}.
        :param pulumi.Input[str] request_id: Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] skaffold_config_path: Filepath of the Skaffold config inside of the config URI.
        :param pulumi.Input[str] skaffold_config_uri: Cloud Storage URI of tar.gz archive containing Skaffold configuration.
        :param pulumi.Input[str] skaffold_version: The Skaffold version to use when operating on this release, such as "1.20.0". Not all versions are valid; Google Cloud Deploy supports a specific set of versions. If unset, the most recent supported Skaffold version will be used.
        :param pulumi.Input[str] validate_only: Optional. If set to true, the request is validated and the user is provided with an expected result, but no actual change is made.
        """
        pulumi.set(__self__, "delivery_pipeline_id", delivery_pipeline_id)
        pulumi.set(__self__, "release_id", release_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if build_artifacts is not None:
            pulumi.set(__self__, "build_artifacts", build_artifacts)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if skaffold_config_path is not None:
            pulumi.set(__self__, "skaffold_config_path", skaffold_config_path)
        if skaffold_config_uri is not None:
            pulumi.set(__self__, "skaffold_config_uri", skaffold_config_uri)
        if skaffold_version is not None:
            pulumi.set(__self__, "skaffold_version", skaffold_version)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="deliveryPipelineId")
    def delivery_pipeline_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "delivery_pipeline_id")

    @delivery_pipeline_id.setter
    def delivery_pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_pipeline_id", value)

    @property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> pulumi.Input[str]:
        """
        Required. ID of the `Release`.
        """
        return pulumi.get(self, "release_id")

    @release_id.setter
    def release_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="buildArtifacts")
    def build_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildArtifactArgs']]]]:
        """
        List of artifacts to pass through to Skaffold command.
        """
        return pulumi.get(self, "build_artifacts")

    @build_artifacts.setter
    def build_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildArtifactArgs']]]]):
        pulumi.set(self, "build_artifacts", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the `Release`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Name of the `Release`. Format is projects/{project}/ locations/{location}/deliveryPipelines/{deliveryPipeline}/ releases/a-z{0,62}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="skaffoldConfigPath")
    def skaffold_config_path(self) -> Optional[pulumi.Input[str]]:
        """
        Filepath of the Skaffold config inside of the config URI.
        """
        return pulumi.get(self, "skaffold_config_path")

    @skaffold_config_path.setter
    def skaffold_config_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skaffold_config_path", value)

    @property
    @pulumi.getter(name="skaffoldConfigUri")
    def skaffold_config_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Storage URI of tar.gz archive containing Skaffold configuration.
        """
        return pulumi.get(self, "skaffold_config_uri")

    @skaffold_config_uri.setter
    def skaffold_config_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skaffold_config_uri", value)

    @property
    @pulumi.getter(name="skaffoldVersion")
    def skaffold_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Skaffold version to use when operating on this release, such as "1.20.0". Not all versions are valid; Google Cloud Deploy supports a specific set of versions. If unset, the most recent supported Skaffold version will be used.
        """
        return pulumi.get(self, "skaffold_version")

    @skaffold_version.setter
    def skaffold_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skaffold_version", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. If set to true, the request is validated and the user is provided with an expected result, but no actual change is made.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validate_only", value)


class Release(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildArtifactArgs']]]]] = None,
                 delivery_pipeline_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_id: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 skaffold_config_path: Optional[pulumi.Input[str]] = None,
                 skaffold_config_uri: Optional[pulumi.Input[str]] = None,
                 skaffold_version: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Release in a given project and location.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildArtifactArgs']]]] build_artifacts: List of artifacts to pass through to Skaffold command.
        :param pulumi.Input[str] description: Description of the `Release`. Max length is 255 characters.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param pulumi.Input[str] name: Optional. Name of the `Release`. Format is projects/{project}/ locations/{location}/deliveryPipelines/{deliveryPipeline}/ releases/a-z{0,62}.
        :param pulumi.Input[str] release_id: Required. ID of the `Release`.
        :param pulumi.Input[str] request_id: Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] skaffold_config_path: Filepath of the Skaffold config inside of the config URI.
        :param pulumi.Input[str] skaffold_config_uri: Cloud Storage URI of tar.gz archive containing Skaffold configuration.
        :param pulumi.Input[str] skaffold_version: The Skaffold version to use when operating on this release, such as "1.20.0". Not all versions are valid; Google Cloud Deploy supports a specific set of versions. If unset, the most recent supported Skaffold version will be used.
        :param pulumi.Input[str] validate_only: Optional. If set to true, the request is validated and the user is provided with an expected result, but no actual change is made.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Release in a given project and location.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param ReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildArtifactArgs']]]]] = None,
                 delivery_pipeline_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_id: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 skaffold_config_path: Optional[pulumi.Input[str]] = None,
                 skaffold_config_uri: Optional[pulumi.Input[str]] = None,
                 skaffold_version: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseArgs.__new__(ReleaseArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["build_artifacts"] = build_artifacts
            if delivery_pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_pipeline_id'")
            __props__.__dict__["delivery_pipeline_id"] = delivery_pipeline_id
            __props__.__dict__["description"] = description
            __props__.__dict__["etag"] = etag
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if release_id is None and not opts.urn:
                raise TypeError("Missing required property 'release_id'")
            __props__.__dict__["release_id"] = release_id
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["skaffold_config_path"] = skaffold_config_path
            __props__.__dict__["skaffold_config_uri"] = skaffold_config_uri
            __props__.__dict__["skaffold_version"] = skaffold_version
            __props__.__dict__["validate_only"] = validate_only
            __props__.__dict__["abandoned"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delivery_pipeline_snapshot"] = None
            __props__.__dict__["render_end_time"] = None
            __props__.__dict__["render_start_time"] = None
            __props__.__dict__["render_state"] = None
            __props__.__dict__["target_artifacts"] = None
            __props__.__dict__["target_renders"] = None
            __props__.__dict__["target_snapshots"] = None
            __props__.__dict__["uid"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["delivery_pipeline_id", "location", "project", "release_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Release, __self__).__init__(
            'google-native:clouddeploy/v1:Release',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Release':
        """
        Get an existing Release resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReleaseArgs.__new__(ReleaseArgs)

        __props__.__dict__["abandoned"] = None
        __props__.__dict__["annotations"] = None
        __props__.__dict__["build_artifacts"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["delivery_pipeline_id"] = None
        __props__.__dict__["delivery_pipeline_snapshot"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["release_id"] = None
        __props__.__dict__["render_end_time"] = None
        __props__.__dict__["render_start_time"] = None
        __props__.__dict__["render_state"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["skaffold_config_path"] = None
        __props__.__dict__["skaffold_config_uri"] = None
        __props__.__dict__["skaffold_version"] = None
        __props__.__dict__["target_artifacts"] = None
        __props__.__dict__["target_renders"] = None
        __props__.__dict__["target_snapshots"] = None
        __props__.__dict__["uid"] = None
        __props__.__dict__["validate_only"] = None
        return Release(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def abandoned(self) -> pulumi.Output[bool]:
        """
        Indicates whether this is an abandoned release.
        """
        return pulumi.get(self, "abandoned")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="buildArtifacts")
    def build_artifacts(self) -> pulumi.Output[Sequence['outputs.BuildArtifactResponse']]:
        """
        List of artifacts to pass through to Skaffold command.
        """
        return pulumi.get(self, "build_artifacts")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time at which the `Release` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deliveryPipelineId")
    def delivery_pipeline_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "delivery_pipeline_id")

    @property
    @pulumi.getter(name="deliveryPipelineSnapshot")
    def delivery_pipeline_snapshot(self) -> pulumi.Output['outputs.DeliveryPipelineResponse']:
        """
        Snapshot of the parent pipeline taken at release creation time.
        """
        return pulumi.get(self, "delivery_pipeline_snapshot")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the `Release`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Optional. Name of the `Release`. Format is projects/{project}/ locations/{location}/deliveryPipelines/{deliveryPipeline}/ releases/a-z{0,62}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> pulumi.Output[str]:
        """
        Required. ID of the `Release`.
        """
        return pulumi.get(self, "release_id")

    @property
    @pulumi.getter(name="renderEndTime")
    def render_end_time(self) -> pulumi.Output[str]:
        """
        Time at which the render completed.
        """
        return pulumi.get(self, "render_end_time")

    @property
    @pulumi.getter(name="renderStartTime")
    def render_start_time(self) -> pulumi.Output[str]:
        """
        Time at which the render began.
        """
        return pulumi.get(self, "render_start_time")

    @property
    @pulumi.getter(name="renderState")
    def render_state(self) -> pulumi.Output[str]:
        """
        Current state of the render operation.
        """
        return pulumi.get(self, "render_state")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="skaffoldConfigPath")
    def skaffold_config_path(self) -> pulumi.Output[str]:
        """
        Filepath of the Skaffold config inside of the config URI.
        """
        return pulumi.get(self, "skaffold_config_path")

    @property
    @pulumi.getter(name="skaffoldConfigUri")
    def skaffold_config_uri(self) -> pulumi.Output[str]:
        """
        Cloud Storage URI of tar.gz archive containing Skaffold configuration.
        """
        return pulumi.get(self, "skaffold_config_uri")

    @property
    @pulumi.getter(name="skaffoldVersion")
    def skaffold_version(self) -> pulumi.Output[str]:
        """
        The Skaffold version to use when operating on this release, such as "1.20.0". Not all versions are valid; Google Cloud Deploy supports a specific set of versions. If unset, the most recent supported Skaffold version will be used.
        """
        return pulumi.get(self, "skaffold_version")

    @property
    @pulumi.getter(name="targetArtifacts")
    def target_artifacts(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map from target ID to the target artifacts created during the render operation.
        """
        return pulumi.get(self, "target_artifacts")

    @property
    @pulumi.getter(name="targetRenders")
    def target_renders(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map from target ID to details of the render operation for that target.
        """
        return pulumi.get(self, "target_renders")

    @property
    @pulumi.getter(name="targetSnapshots")
    def target_snapshots(self) -> pulumi.Output[Sequence['outputs.TargetResponse']]:
        """
        Snapshot of the targets taken at release creation time.
        """
        return pulumi.get(self, "target_snapshots")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Unique identifier of the `Release`.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. If set to true, the request is validated and the user is provided with an expected result, but no actual change is made.
        """
        return pulumi.get(self, "validate_only")

